/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import java.lang.reflect.Field;
import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.nms.PlayerNavigation;
import net.minecraft.server.v1_7_R4.AttributeInstance;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.Navigation;
import net.minecraft.server.v1_7_R4.PathEntity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MCTargetStrategy
implements PathStrategy,
EntityTarget {
    private final boolean aggro;
    private int attackTicks;
    private CancelReason cancelReason;
    private final Entity handle;
    private final NPC npc;
    private final NavigatorParameters parameters;
    private final Entity target;
    private final TargetNavigator targetNavigator;
    private static final int ATTACK_DELAY_TICKS = 20;
    static final AttackStrategy DEFAULT_ATTACK_STRATEGY = new AttackStrategy(){

        @Override
        public boolean handle(LivingEntity attacker, LivingEntity bukkitTarget) {
            EntityLiving handle = NMS.getHandle(attacker);
            EntityLiving target = NMS.getHandle(bukkitTarget);
            if (handle instanceof EntityPlayer) {
                EntityPlayer humanHandle = (EntityPlayer)handle;
                humanHandle.attack((Entity)target);
                PlayerAnimation.ARM_SWING.play((Player)humanHandle.getBukkitEntity());
            } else {
                NMS.attack(handle, (Entity)target);
            }
            return false;
        }
    };
    private static Field E_NAV_E;
    private static Field E_NAV_J;
    private static Field E_NAV_M;
    private static final Location HANDLE_LOCATION;
    private static Field P_NAV_E;
    private static Field P_NAV_J;
    private static Field P_NAV_M;
    private static final Location TARGET_LOCATION;

    public MCTargetStrategy(NPC npc, org.bukkit.entity.Entity target, boolean aggro, NavigatorParameters params) {
        this.npc = npc;
        this.parameters = params;
        this.handle = ((CraftEntity)npc.getEntity()).getHandle();
        this.target = ((CraftEntity)target).getHandle();
        Navigation nav = NMS.getNavigation(this.handle);
        this.targetNavigator = nav != null && !params.useNewPathfinder() ? new NavigationFieldWrapper(nav) : new AStarTargeter();
        this.aggro = aggro;
    }

    private boolean canAttack() {
        return this.attackTicks == 0 && this.handle.boundingBox.e > this.target.boundingBox.b && this.handle.boundingBox.b < this.target.boundingBox.e && this.closeEnough(this.distanceSquared()) && this.hasLineOfSight();
    }

    @Override
    public void clearCancelReason() {
        this.cancelReason = null;
    }

    private boolean closeEnough(double distance) {
        return distance <= this.parameters.attackRange();
    }

    private double distanceSquared() {
        return this.handle.getBukkitEntity().getLocation(HANDLE_LOCATION).distanceSquared(this.target.getBukkitEntity().getLocation(TARGET_LOCATION));
    }

    @Override
    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    @Override
    public LivingEntity getTarget() {
        return (LivingEntity)this.target.getBukkitEntity();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.getTarget().getLocation();
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.ENTITY;
    }

    private boolean hasLineOfSight() {
        return ((LivingEntity)this.handle.getBukkitEntity()).hasLineOfSight((org.bukkit.entity.Entity)this.target.getBukkitEntity());
    }

    @Override
    public boolean isAggressive() {
        return this.aggro;
    }

    private void setPath() {
        this.targetNavigator.setPath();
    }

    @Override
    public void stop() {
        this.targetNavigator.stop();
    }

    public String toString() {
        return "MCTargetStrategy [target=" + this.target + "]";
    }

    @Override
    public boolean update() {
        if (this.target == null || !this.target.getBukkitEntity().isValid()) {
            this.cancelReason = CancelReason.TARGET_DIED;
            return true;
        }
        if (this.target.world != this.handle.world) {
            this.cancelReason = CancelReason.TARGET_MOVED_WORLD;
            return true;
        }
        if (this.cancelReason != null) {
            return true;
        }
        if (this.target.world.getWorld().getFullTime() % 10L == 0L) {
            this.setPath();
        }
        NMS.look(this.handle, this.target);
        if (this.aggro && this.canAttack()) {
            AttackStrategy strategy = this.parameters.attackStrategy();
            if (!(strategy != null && strategy.handle((LivingEntity)this.handle.getBukkitEntity(), this.getTarget()) || strategy == this.parameters.defaultAttackStrategy())) {
                this.parameters.defaultAttackStrategy().handle((LivingEntity)this.handle.getBukkitEntity(), this.getTarget());
            }
            this.attackTicks = 20;
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        return false;
    }

    static {
        HANDLE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        TARGET_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        E_NAV_E = NMS.getField(Navigation.class, "e");
        E_NAV_J = NMS.getField(Navigation.class, "j");
        E_NAV_M = NMS.getField(Navigation.class, "m");
        P_NAV_E = NMS.getField(PlayerNavigation.class, "e");
        P_NAV_J = NMS.getField(PlayerNavigation.class, "j");
        P_NAV_M = NMS.getField(PlayerNavigation.class, "m");
    }

    private static interface TargetNavigator {
        public void setPath();

        public void stop();
    }

    private class NavigationFieldWrapper
    implements TargetNavigator {
        boolean j = true;
        boolean k;
        boolean l;
        boolean m;
        private final Navigation navigation;
        float range;

        private NavigationFieldWrapper(Navigation navigation) {
            this.navigation = navigation;
            this.k = navigation.c();
            this.l = navigation.a();
            try {
                if (navigation instanceof PlayerNavigation) {
                    if (P_NAV_E != null) {
                        this.range = (float)((AttributeInstance)P_NAV_E.get(navigation)).getValue();
                    }
                    if (P_NAV_J != null) {
                        this.j = P_NAV_J.getBoolean(navigation);
                    }
                    if (P_NAV_M != null) {
                        this.m = P_NAV_M.getBoolean(navigation);
                    }
                } else {
                    if (E_NAV_E != null) {
                        this.range = (float)((AttributeInstance)E_NAV_E.get(navigation)).getValue();
                    }
                    if (E_NAV_J != null) {
                        this.j = E_NAV_J.getBoolean(navigation);
                    }
                    if (E_NAV_M != null) {
                        this.m = E_NAV_M.getBoolean(navigation);
                    }
                }
            }
            catch (Exception ex) {
                this.range = MCTargetStrategy.this.parameters.range();
            }
        }

        public PathEntity findPath(Entity from, Entity to) {
            return ((MCTargetStrategy)MCTargetStrategy.this).handle.world.findPath(from, to, this.range, this.j, this.k, this.l, this.m);
        }

        @Override
        public void setPath() {
            this.navigation.a(MCTargetStrategy.this.parameters.avoidWater());
            this.navigation.a(this.findPath(MCTargetStrategy.this.handle, MCTargetStrategy.this.target), (double)MCTargetStrategy.this.parameters.speed());
        }

        @Override
        public void stop() {
            NMS.stopNavigation(this.navigation);
        }
    }

    private class AStarTargeter
    implements TargetNavigator {
        private int failureTimes = 0;
        private PathStrategy strategy;

        public AStarTargeter() {
            this.setStrategy();
        }

        @Override
        public void setPath() {
            this.setStrategy();
            this.strategy.update();
            CancelReason subReason = this.strategy.getCancelReason();
            if (subReason == CancelReason.STUCK) {
                if (this.failureTimes++ > 10) {
                    MCTargetStrategy.this.cancelReason = this.strategy.getCancelReason();
                }
            } else {
                this.failureTimes = 0;
                MCTargetStrategy.this.cancelReason = this.strategy.getCancelReason();
            }
        }

        private void setStrategy() {
            Location location = MCTargetStrategy.this.target.getBukkitEntity().getLocation(TARGET_LOCATION);
            this.strategy = MCTargetStrategy.this.npc.isFlyable() ? new FlyingAStarNavigationStrategy(MCTargetStrategy.this.npc, location, MCTargetStrategy.this.parameters) : new AStarNavigationStrategy(MCTargetStrategy.this.npc, location, MCTargetStrategy.this.parameters);
        }

        @Override
        public void stop() {
            this.strategy.stop();
        }
    }
}

