/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityEnderDragon;
import net.minecraft.server.v1_7_R4.NBTTagCompound;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.util.Vector;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(World world) {
            this(world, null);
        }

        public EntityEnderDragonNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        protected String aT() {
            return this.npc == null ? super.aT() : this.npc.data().get("hurt-sound", super.aT());
        }

        protected String aU() {
            return this.npc == null ? super.aU() : this.npc.data().get("death-sound", super.aU());
        }

        public boolean bN() {
            if (this.npc == null) {
                return super.bN();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.bN();
            }
            if (super.bN()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void bq() {
            if (this.npc == null) {
                super.bq();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void e() {
            if (this.npc != null) {
                this.npc.update();
                if (this.motX != 0.0 || this.motY != 0.0 || this.motZ != 0.0) {
                    this.motX *= 0.98;
                    this.motY *= 0.98;
                    this.motZ *= 0.98;
                    this.yaw = this.getCorrectYaw(this.locX + this.motX, this.locZ + this.motZ);
                    this.setPosition(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
                }
            } else {
                super.e();
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new EnderDragonNPC(this);
            }
            return super.getBukkitEntity();
        }

        private float getCorrectYaw(double tX, double tZ) {
            if (this.locZ > tZ) {
                return (float)(-Math.toDegrees(Math.atan((this.locX - tX) / (this.locZ - tZ))));
            }
            if (this.locZ < tZ) {
                return (float)(-Math.toDegrees(Math.atan((this.locX - tX) / (this.locZ - tZ)))) + 180.0f;
            }
            return this.yaw;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected String t() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.t() : this.npc.data().get("ambient-sound", super.t());
        }

        protected void w() {
            if (this.npc == null) {
                super.w();
            }
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

