/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.network.EmptyNetHandler;
import net.citizensnpcs.npc.network.EmptyNetworkManager;
import net.citizensnpcs.npc.network.EmptySocket;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.citizensnpcs.util.nms.PlayerControllerJump;
import net.citizensnpcs.util.nms.PlayerControllerLook;
import net.citizensnpcs.util.nms.PlayerControllerMove;
import net.citizensnpcs.util.nms.PlayerNavigation;
import net.minecraft.server.v1_7_R4.AttributeInstance;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.EnumGamemode;
import net.minecraft.server.v1_7_R4.GenericAttributes;
import net.minecraft.server.v1_7_R4.MathHelper;
import net.minecraft.server.v1_7_R4.MinecraftServer;
import net.minecraft.server.v1_7_R4.Navigation;
import net.minecraft.server.v1_7_R4.Packet;
import net.minecraft.server.v1_7_R4.PacketListener;
import net.minecraft.server.v1_7_R4.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_7_R4.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_7_R4.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_7_R4.PlayerInteractManager;
import net.minecraft.server.v1_7_R4.WorldServer;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder {
    private PlayerControllerJump controllerJump;
    private PlayerControllerLook controllerLook;
    private PlayerControllerMove controllerMove;
    private boolean gravity = true;
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private static final float EPSILON = 0.005f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static Method PLAYER_INFO_ADD_METHOD;
    private static Constructor<PacketPlayOutPlayerInfo> PLAYER_INFO_CONSTRUCTOR;
    private static Method PLAYER_INFO_REMOVE_METHOD;

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, gameProfile, playerInteractManager);
        playerInteractManager.setGameMode(EnumGamemode.SURVIVAL);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.initialise(minecraftServer);
        }
    }

    protected void a(double d0, boolean flag) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag);
        }
    }

    protected void b(float f) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.b(f);
        }
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
    }

    public void e(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.e(f, f1);
        } else {
            NMS.flyingMoveLogic((EntityLiving)this, f, f1);
        }
    }

    public void g(double x, double y, double z) {
        if (this.npc == null) {
            super.g(x, y, z);
            return;
        }
        if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
            if (!this.npc.data().get("protected", true).booleanValue()) {
                super.g(x, y, z);
            }
            return;
        }
        Vector vector = new Vector(x, y, z);
        NPCPushEvent event = Util.callPushEvent(this.npc, vector);
        if (!event.isCancelled()) {
            vector = event.getCollisionVector();
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && this.bukkitEntity == null) {
            this.bukkitEntity = new PlayerNPC(this);
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    private Packet getListPacket(Player player, boolean removeFromPlayerList) {
        if (PLAYER_INFO_CONSTRUCTOR != null) {
            try {
                return (Packet)PLAYER_INFO_CONSTRUCTOR.newInstance(player.getPlayerListName(), !removeFromPlayerList, removeFromPlayerList ? 9999 : this.ping);
            }
            catch (Exception e) {
            }
        } else {
            try {
                return (Packet)(removeFromPlayerList ? PLAYER_INFO_REMOVE_METHOD.invoke(null, ((CraftPlayer)player).getHandle()) : PLAYER_INFO_ADD_METHOD.invoke(null, ((CraftPlayer)player).getHandle()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public void h() {
        super.h();
        if (this.npc == null) {
            return;
        }
        boolean navigating = this.npc.getNavigator().isNavigating();
        this.updatePackets(navigating);
        if (this.gravity && !navigating && this.getBukkitEntity() != null && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && !NMS.inWater((org.bukkit.entity.Entity)this.getBukkitEntity())) {
            this.move(0.0, -0.2, 0.0);
        }
        if (Math.abs(this.motX) < (double)0.005f && Math.abs(this.motY) < (double)0.005f && Math.abs(this.motZ) < (double)0.005f) {
            this.motZ = 0.0;
            this.motY = 0.0;
            this.motX = 0.0;
        }
        if (navigating) {
            if (!NMS.isNavigationFinished(this.navigation)) {
                NMS.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        } else if (this.motX != 0.0 || this.motZ != 0.0 || this.motY != 0.0) {
            this.e(0.0f, 0.0f);
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        this.npc.update();
    }

    public boolean h_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.h_();
        }
        return false;
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(false);
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.a((PacketListener)this.playerConnection);
        }
        catch (IOException e) {
            // empty catch block
        }
        NMS.setStepHeight((EntityLiving)this, 1.0f);
        try {
            socket.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        AttributeInstance range = this.getAttributeInstance(GenericAttributes.b);
        if (range == null) {
            range = this.getAttributeMap().b(GenericAttributes.b);
        }
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerLook = new PlayerControllerLook(this);
        this.controllerMove = new PlayerControllerMove(this);
        this.navigation = new PlayerNavigation(this, this.world);
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    private void moveOnCurrentHeading() {
        NMS.updateAI((EntityLiving)this);
        if (this.bc) {
            if (this.onGround && this.jumpTicks == 0) {
                this.bj();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bd *= 0.98f;
        this.be *= 0.98f;
        this.bf *= 0.9f;
        this.e(this.bd, this.be);
        NMS.setHeadYaw((Entity)this, this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setShouldJump() {
        this.controllerJump.a();
    }

    public void setTargetLook(Entity target, float yawOffset, float renderOffset) {
        this.controllerLook.a(target, yawOffset, renderOffset);
    }

    public void updateAI() {
        this.controllerMove.c();
        this.controllerLook.a();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        if (this.world.getWorld().getFullTime() % (long)Settings.Setting.PACKET_UPDATE_DELAY.asInt() == 0L) {
            try {
                this.datawatcher.watch(10, (Object)127);
            }
            catch (NullPointerException e) {
                this.datawatcher.a(10, (Object)127);
            }
            Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
            Packet[] packets = new Packet[navigating ? 5 : 6];
            if (!navigating) {
                packets[5] = new PacketPlayOutEntityHeadRotation((Entity)this, (byte)MathHelper.d((float)(NMS.getHeadYaw((EntityLiving)this) * 256.0f / 360.0f)));
            }
            for (int i = 0; i < 5; ++i) {
                packets[i] = new PacketPlayOutEntityEquipment(this.getId(), i, this.getEquipment(i));
            }
            boolean removeFromPlayerList = this.npc.data().get("removefromplayerlist", Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean());
            NMS.addOrRemoveFromPlayerList((org.bukkit.entity.Entity)this.getBukkitEntity(), removeFromPlayerList);
            Player otherOnline = null;
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().equalsIgnoreCase(this.getName()) || player instanceof NPCHolder) continue;
                otherOnline = player;
                break;
            }
            NMS.sendToOnline(this.getListPacket((Player)this.getBukkitEntity(), true));
            if (otherOnline != null) {
                NMS.sendToOnline(this.getListPacket(otherOnline, false));
            }
            NMS.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
        }
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    static {
        try {
            PLAYER_INFO_CONSTRUCTOR = PacketPlayOutPlayerInfo.class.getConstructor(String.class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            PLAYER_INFO_ADD_METHOD = PacketPlayOutPlayerInfo.class.getMethod("addPlayer", EntityPlayer.class);
            PLAYER_INFO_REMOVE_METHOD = PacketPlayOutPlayerInfo.class.getMethod("removePlayer", EntityPlayer.class);
            PLAYER_INFO_ADD_METHOD.setAccessible(true);
            PLAYER_INFO_REMOVE_METHOD.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getTrait(Inventory.class);
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setGravityEnabled(boolean enabled) {
            this.getHandle().gravity = enabled;
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }
    }
}

