/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityGhast;
import net.minecraft.server.v1_7_R4.NBTTagCompound;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftGhast;
import org.bukkit.entity.Ghast;
import org.bukkit.util.Vector;

public class GhastController
extends MobEntityController {
    public GhastController() {
        super(EntityGhastNPC.class);
    }

    public Ghast getBukkitEntity() {
        return (Ghast)super.getBukkitEntity();
    }

    public static class GhastNPC
    extends CraftGhast
    implements NPCHolder {
        private final CitizensNPC npc;

        public GhastNPC(EntityGhastNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityGhast)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityGhastNPC
    extends EntityGhast
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityGhastNPC(World world) {
            this(world, null);
        }

        public EntityGhastNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        protected String aT() {
            return this.npc == null ? super.aT() : this.npc.data().get("hurt-sound", super.aT());
        }

        protected String aU() {
            return this.npc == null ? super.aU() : this.npc.data().get("death-sound", super.aU());
        }

        public boolean bN() {
            if (this.npc == null) {
                return super.bN();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.bN();
            }
            if (super.bN()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void bq() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.bq();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new GhastNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected String t() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.t() : this.npc.data().get("ambient-sound", super.t());
        }

        protected void w() {
            if (this.npc == null) {
                super.w();
            }
        }
    }
}

