/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.EntityWither;
import net.minecraft.server.v1_7_R4.NBTTagCompound;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftWither;
import org.bukkit.entity.Wither;
import org.bukkit.util.Vector;

public class WitherController
extends MobEntityController {
    public WitherController() {
        super(EntityWitherNPC.class);
    }

    public Wither getBukkitEntity() {
        return (Wither)super.getBukkitEntity();
    }

    public static class WitherNPC
    extends CraftWither
    implements NPCHolder {
        private final CitizensNPC npc;

        public WitherNPC(EntityWitherNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityWither)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityWitherNPC
    extends EntityWither
    implements NPCHolder {
        private int jumpTicks;
        private final CitizensNPC npc;

        public EntityWitherNPC(World world) {
            this(world, null);
        }

        public EntityWitherNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        protected String aT() {
            return this.npc == null ? super.aT() : this.npc.data().get("hurt-sound", super.aT());
        }

        protected String aU() {
            return this.npc == null ? super.aU() : this.npc.data().get("death-sound", super.aU());
        }

        public void bn() {
            super.bn();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public boolean bN() {
            if (this.npc == null) {
                return super.bN();
            }
            boolean protectedDefault = this.npc.data().get("protected", true);
            if (!protectedDefault || !this.npc.data().get("protected-leash", protectedDefault).booleanValue()) {
                return super.bN();
            }
            if (super.bN()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void e() {
            if (this.npc == null) {
                super.e();
            } else {
                this.updateAIWithMovement();
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new WitherNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        protected String t() {
            return this.npc == null || !this.npc.data().has("ambient-sound") ? super.t() : this.npc.data().get("ambient-sound", super.t());
        }

        private void updateAIWithMovement() {
            NMS.updateAI((EntityLiving)this);
            if (this.bc) {
                if (this.onGround && this.jumpTicks == 0) {
                    this.bj();
                    this.jumpTicks = 10;
                }
            } else {
                this.jumpTicks = 0;
            }
            this.bd *= 0.98f;
            this.be *= 0.98f;
            this.bf *= 0.9f;
            this.e(this.bd, this.be);
            NMS.setHeadYaw((Entity)this, this.yaw);
            if (this.jumpTicks > 0) {
                --this.jumpTicks;
            }
        }

        protected void w() {
            if (this.npc == null) {
                super.w();
            }
        }
    }
}

