/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity.nonliving;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.MobEntityController;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityItemFrame;
import net.minecraft.server.v1_7_R4.NBTTagCompound;
import net.minecraft.server.v1_7_R4.World;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftItemFrame;
import org.bukkit.entity.ItemFrame;
import org.bukkit.util.Vector;

public class ItemFrameController
extends MobEntityController {
    public ItemFrameController() {
        super(EntityItemFrameNPC.class);
    }

    public ItemFrame getBukkitEntity() {
        return (ItemFrame)super.getBukkitEntity();
    }

    public static class ItemFrameNPC
    extends CraftItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemFrameNPC(EntityItemFrameNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityItemFrame)entity);
            this.npc = entity.npc;
            Material id = Material.STONE;
            int data = this.npc.data().get("item-type-data", this.npc.data().get("falling-block-data", 0));
            if (this.npc.data().has("item-type-id")) {
                id = Material.getMaterial((String)((String)this.npc.data().get("item-type-id")));
            }
            this.getItem().setType(id);
            this.getItem().setDurability((short)data);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", material.name());
            this.npc.data().setPersistent("item-type-data", data);
            if (this.npc.isSpawned()) {
                this.npc.despawn();
                this.npc.spawn(this.npc.getStoredLocation());
            }
        }
    }

    public static class EntityItemFrameNPC
    extends EntityItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemFrameNPC(World world) {
            this(world, null);
        }

        public EntityItemFrameNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.setDirection(0);
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void collide(Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new ItemFrameNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void h() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.h();
            }
        }

        public boolean survives() {
            return this.npc == null || !this.npc.isProtected() ? super.survives() : true;
        }
    }
}

