/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class Anchor {
    private Location location;
    private final String name;
    private final String unloaded_value;

    public Anchor(String name, String unloaded_value) {
        this.location = null;
        this.unloaded_value = unloaded_value;
        this.name = name;
    }

    public Anchor(String name, Location location) {
        this.location = location;
        this.name = name;
        this.unloaded_value = location.getWorld().getName() + ';' + location.getX() + ';' + location.getY() + ';' + location.getZ();
    }

    public boolean isLoaded() {
        return this.location != null;
    }

    public boolean load() {
        try {
            String[] parts = this.getUnloadedValue();
            this.location = new Location(Bukkit.getWorld((String)parts[0]), Double.valueOf(parts[1]).doubleValue(), Double.valueOf(parts[2]).doubleValue(), Double.valueOf(parts[3]).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.location != null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Anchor op = (Anchor)object;
        return new EqualsBuilder().append((Object)this.name, (Object)op.name).isEquals();
    }

    public Location getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String[] getUnloadedValue() {
        return this.unloaded_value.split(";");
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 21).append((Object)this.name).toHashCode();
    }

    public String stringValue() {
        return this.name + ';' + this.unloaded_value;
    }

    public String toString() {
        String[] parts = this.getUnloadedValue();
        return "Anchor{Name='" + this.name + "';World='" + parts[0] + "';Location='" + parts[1] + ',' + parts[2] + ',' + parts[3] + "';}";
    }
}

