/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.npc.network.EmptyChannel;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.AttributeInstance;
import net.minecraft.server.v1_7_R4.ControllerJump;
import net.minecraft.server.v1_7_R4.DamageSource;
import net.minecraft.server.v1_7_R4.EnchantmentManager;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.EntityHorse;
import net.minecraft.server.v1_7_R4.EntityHuman;
import net.minecraft.server.v1_7_R4.EntityInsentient;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.EntityMinecartAbstract;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.EntityTypes;
import net.minecraft.server.v1_7_R4.GenericAttributes;
import net.minecraft.server.v1_7_R4.MathHelper;
import net.minecraft.server.v1_7_R4.MobEffectList;
import net.minecraft.server.v1_7_R4.Navigation;
import net.minecraft.server.v1_7_R4.NetworkManager;
import net.minecraft.server.v1_7_R4.Packet;
import net.minecraft.server.v1_7_R4.PathfinderGoalSelector;
import net.minecraft.server.v1_7_R4.World;
import net.minecraft.server.v1_7_R4.WorldServer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftSound;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginLoadOrder;

public class NMS {
    private static final float DEFAULT_SPEED = 1.0f;
    private static Map<Class<?>, Integer> ENTITY_CLASS_TO_INT;
    private static Map<Class<?>, String> ENTITY_CLASS_TO_NAME;
    private static final Map<Class<?>, Constructor<?>> ENTITY_CONSTRUCTOR_CACHE;
    private static Map<Integer, Class<?>> ENTITY_INT_TO_CLASS;
    private static Field GOAL_FIELD;
    private static final Field JUMP_FIELD;
    private static Map<Class<?>, Integer> MC_ENTITY_CLASS_TO_INT;
    private static Map<Integer, Class<?>> MC_ENTITY_INT_TO_CLASS;
    private static Field NAVIGATION_WORLD_FIELD;
    private static Field NETWORK_ADDRESS;
    private static Field NETWORK_CHANNEL;
    private static final Location PACKET_CACHE_LOCATION;
    private static Field PATHFINDING_RANGE;
    private static final Random RANDOM;

    private NMS() {
    }

    public static void addOrRemoveFromPlayerList(org.bukkit.entity.Entity entity, boolean remove) {
        if (entity == null) {
            return;
        }
        Entity handle = NMS.getHandle(entity);
        if (handle.world == null) {
            return;
        }
        if (remove) {
            handle.world.players.remove(handle);
        } else if (!handle.world.players.contains(handle)) {
            handle.world.players.add(handle);
        }
    }

    public static void attack(EntityLiving handle, Entity target) {
        int fireAspectLevel;
        boolean success;
        AttributeInstance attribute = handle.getAttributeInstance(GenericAttributes.e);
        float damage = (float)(attribute == null ? 1.0 : attribute.getValue());
        if (handle.hasEffect(MobEffectList.INCREASE_DAMAGE)) {
            damage += (float)(3 << handle.getEffect(MobEffectList.INCREASE_DAMAGE).getAmplifier());
        }
        if (handle.hasEffect(MobEffectList.WEAKNESS)) {
            damage -= (float)(2 << handle.getEffect(MobEffectList.WEAKNESS).getAmplifier());
        }
        int knockbackLevel = 0;
        if (target instanceof EntityLiving) {
            damage += EnchantmentManager.a((EntityLiving)handle, (EntityLiving)((EntityLiving)target));
            knockbackLevel += EnchantmentManager.getKnockbackEnchantmentLevel((EntityLiving)handle, (EntityLiving)((EntityLiving)target));
        }
        if (!(success = target.damageEntity(DamageSource.mobAttack((EntityLiving)handle), damage))) {
            return;
        }
        if (knockbackLevel > 0) {
            target.g(-Math.sin((double)handle.yaw * Math.PI / 180.0) * (double)knockbackLevel * 0.5, 0.1, Math.cos((double)handle.yaw * Math.PI / 180.0) * (double)knockbackLevel * 0.5);
            handle.motX *= 0.6;
            handle.motZ *= 0.6;
        }
        if ((fireAspectLevel = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)handle)) > 0) {
            target.setOnFire(fireAspectLevel * 4);
        }
    }

    public static void changeWorlds(org.bukkit.entity.Entity entity, org.bukkit.World world) {
        NMS.getHandle((org.bukkit.entity.Entity)entity).world = ((CraftWorld)world).getHandle();
    }

    public static void clearGoals(PathfinderGoalSelector ... goalSelectors) {
        if (GOAL_FIELD == null || goalSelectors == null) {
            return;
        }
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                List list = (List)GOAL_FIELD.get(selector);
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
        }
    }

    public static void flyingMoveLogic(EntityLiving entity, float f, float f1) {
        if (entity.L()) {
            entity.a(f, f1, 0.02f);
            entity.move(entity.motX, entity.motY, entity.motZ);
            entity.motX *= (double)0.8f;
            entity.motY *= (double)0.8f;
            entity.motZ *= (double)0.8f;
        } else if (entity.P()) {
            entity.a(f, f1, 0.02f);
            entity.move(entity.motX, entity.motY, entity.motZ);
            entity.motX *= 0.5;
            entity.motY *= 0.5;
            entity.motZ *= 0.5;
        } else {
            float f2 = 0.91f;
            if (entity.onGround) {
                f2 = entity.world.getType((int)MathHelper.floor((double)entity.locX), (int)(MathHelper.floor((double)entity.boundingBox.b) - 1), (int)MathHelper.floor((double)entity.locZ)).frictionFactor * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            entity.a(f, f1, entity.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (entity.onGround) {
                f2 = entity.world.getType((int)MathHelper.floor((double)entity.locX), (int)(MathHelper.floor((double)entity.boundingBox.b) - 1), (int)MathHelper.floor((double)entity.locZ)).frictionFactor * 0.91f;
            }
            entity.move(entity.motX, entity.motY, entity.motZ);
            entity.motX *= (double)f2;
            entity.motY *= (double)f2;
            entity.motZ *= (double)f2;
        }
        entity.aE = entity.aF;
        double d0 = entity.locX - entity.lastX;
        double d1 = entity.locZ - entity.lastZ;
        float f4 = MathHelper.sqrt((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        entity.aF += (f4 - entity.aF) * 0.4f;
        entity.aG += entity.aF;
    }

    private static Constructor<?> getCustomEntityConstructor(Class<?> clazz, EntityType type) throws SecurityException, NoSuchMethodException {
        Constructor<?> constructor = ENTITY_CONSTRUCTOR_CACHE.get(clazz);
        if (constructor == null) {
            constructor = clazz.getConstructor(World.class);
            constructor.setAccessible(true);
            ENTITY_CLASS_TO_INT.put(clazz, Integer.valueOf(type.getTypeId()));
            ENTITY_CONSTRUCTOR_CACHE.put(clazz, constructor);
        }
        return constructor;
    }

    public static Field getField(Class<?> clazz, String field) {
        if (clazz == null) {
            return null;
        }
        Field f = null;
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-field", field, e.getLocalizedMessage());
        }
        return f;
    }

    public static EntityLiving getHandle(LivingEntity entity) {
        return (EntityLiving)NMS.getHandle((org.bukkit.entity.Entity)entity);
    }

    public static Entity getHandle(org.bukkit.entity.Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    public static float getHeadYaw(EntityLiving handle) {
        return handle.aO;
    }

    public static Navigation getNavigation(Entity handle) {
        return handle instanceof EntityInsentient ? ((EntityInsentient)handle).getNavigation() : (handle instanceof EntityHumanNPC ? ((EntityHumanNPC)handle).getNavigation() : null);
    }

    public static String getSound(String flag) throws CommandException {
        try {
            String ret = CraftSound.getSound((Sound)Sound.valueOf((String)flag.toUpperCase()));
            if (ret == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return ret;
        }
        catch (Exception e) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    public static float getSpeedFor(NPC npc) {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving handle = NMS.getHandle((LivingEntity)npc.getEntity());
        if (handle == null) {
            return 1.0f;
        }
        return 1.0f;
    }

    public static float getStepHeight(LivingEntity entity) {
        return NMS.getHandle((LivingEntity)entity).W;
    }

    public static void initNetworkManager(NetworkManager network) {
        if (NETWORK_CHANNEL == null || NETWORK_ADDRESS == null) {
            return;
        }
        try {
            NETWORK_CHANNEL.set(network, (Object)new EmptyChannel(null));
            NETWORK_ADDRESS.set(network, new SocketAddress(){
                private static final long serialVersionUID = 8207338859896320185L;
            });
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean inWater(org.bukkit.entity.Entity entity) {
        Entity mcEntity = NMS.getHandle(entity);
        if (mcEntity == null) {
            return false;
        }
        return mcEntity.M() || mcEntity.P();
    }

    public static boolean isNavigationFinished(Navigation navigation) {
        return navigation.g();
    }

    public static void loadPlugins() {
        ((CraftServer)Bukkit.getServer()).enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    public static void look(Entity handle, Entity target) {
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerLook().a(target, 10.0f, (float)((EntityInsentient)handle).x());
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setTargetLook(target, 10.0f, 40.0f);
        }
    }

    public static void look(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        Entity handle = NMS.getHandle(entity);
        if (handle == null) {
            return;
        }
        handle.yaw = yaw;
        NMS.setHeadYaw(handle, yaw);
        handle.pitch = pitch;
    }

    public static void minecartItemLogic(EntityMinecartAbstract minecart) {
        NPC npc = ((NPCHolder)minecart).getNPC();
        if (npc == null) {
            return;
        }
        Material mat = Material.getMaterial((String)npc.data().get("minecart-item-name", ""));
        int data = npc.data().get("minecart-item-data", 0);
        int offset = npc.data().get("minecart-item-offset", 0);
        if (mat == null) {
            minecart.a(false);
        } else {
            minecart.a(true);
            minecart.k(mat.getId());
        }
        minecart.l(data);
        minecart.m(offset);
    }

    public static float modifiedSpeed(float baseSpeed, NPC npc) {
        return npc == null ? baseSpeed : baseSpeed * npc.getNavigator().getLocalParameters().speedModifier();
    }

    public static void mount(org.bukkit.entity.Entity entity, org.bukkit.entity.Entity passenger) {
        if (NMS.getHandle(passenger) == null) {
            return;
        }
        NMS.getHandle(passenger).mount(NMS.getHandle(entity));
    }

    public static void openHorseScreen(Horse horse, Player equipper) {
        EntityLiving handle = NMS.getHandle((LivingEntity)horse);
        EntityLiving equipperHandle = NMS.getHandle((LivingEntity)equipper);
        if (handle == null || equipperHandle == null) {
            return;
        }
        boolean wasTamed = horse.isTamed();
        horse.setTamed(true);
        ((EntityHorse)handle).a((EntityHuman)equipperHandle);
        horse.setTamed(wasTamed);
    }

    public static void registerEntityClass(Class<?> clazz) {
        if (ENTITY_CLASS_TO_INT == null) {
            ENTITY_CLASS_TO_INT = MC_ENTITY_CLASS_TO_INT;
            ENTITY_INT_TO_CLASS = MC_ENTITY_INT_TO_CLASS;
        }
        if (ENTITY_CLASS_TO_INT == null || ENTITY_CLASS_TO_INT.containsKey(clazz)) {
            return;
        }
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && Entity.class.isAssignableFrom(search)) {
            if (!ENTITY_CLASS_TO_INT.containsKey(search)) continue;
            int code = ENTITY_CLASS_TO_INT.get(search);
            ENTITY_INT_TO_CLASS.put(code, clazz);
            ENTITY_CLASS_TO_INT.put(clazz, code);
            ENTITY_CLASS_TO_NAME.put(clazz, ENTITY_CLASS_TO_NAME.get(search));
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass");
    }

    public static void removeFromServerPlayerList(Player player) {
        EntityPlayer handle = (EntityPlayer)NMS.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    public static void sendPacket(Player player, Packet packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMS.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
    }

    public static void sendPacketNearby(Player from, Location location, Packet packet) {
        NMS.sendPacketsNearby(from, location, Arrays.asList(packet), 64.0);
    }

    public static void sendPacketsNearby(Player from, Location location, Collection<Packet> packets) {
        NMS.sendPacketsNearby(from, location, packets, 64.0);
    }

    public static void sendPacketsNearby(Player from, Location location, Collection<Packet> packets, double radius) {
        radius *= radius;
        org.bukkit.World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || from != null && !ply.canSee(from) || location.distanceSquared(ply.getLocation(PACKET_CACHE_LOCATION)) > radius) continue;
            for (Packet packet : packets) {
                NMS.sendPacket(ply, packet);
            }
        }
    }

    public static void sendPacketsNearby(Player from, Location location, Packet ... packets) {
        NMS.sendPacketsNearby(from, location, Arrays.asList(packets), 64.0);
    }

    public static void sendToOnline(Packet ... packets) {
        Validate.notNull((Object)packets, (String)"packets cannot be null");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !player.isOnline()) continue;
            for (Packet packet : packets) {
                NMS.sendPacket(player, packet);
            }
        }
    }

    public static void setDestination(org.bukkit.entity.Entity entity, double x, double y, double z, float speed) {
        Entity handle = NMS.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerMove().a(x, y, z, (double)speed);
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setMoveDestination(x, y, z, speed);
        }
    }

    public static void setHeadYaw(Entity en, float yaw) {
        if (!(en instanceof EntityLiving)) {
            return;
        }
        EntityLiving handle = (EntityLiving)en;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        handle.aO = yaw;
        if (!(handle instanceof EntityHuman)) {
            handle.aM = yaw;
        }
        handle.aP = yaw;
    }

    public static void setShouldJump(org.bukkit.entity.Entity entity) {
        Entity handle = NMS.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (handle instanceof EntityInsentient) {
            ControllerJump controller = ((EntityInsentient)handle).getControllerJump();
            controller.a();
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setShouldJump();
        }
    }

    public static void setStepHeight(EntityLiving entity, float height) {
        entity.W = height;
    }

    public static void setVerticalMovement(org.bukkit.entity.Entity bukkitEntity, double d) {
        if (!bukkitEntity.getType().isAlive()) {
            return;
        }
        EntityLiving handle = NMS.getHandle((LivingEntity)bukkitEntity);
        handle.be = (float)d;
    }

    public static boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof EntityLiving)) {
            return false;
        }
        try {
            return JUMP_FIELD.getBoolean(entity);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static org.bukkit.entity.Entity spawnCustomEntity(org.bukkit.World world, Location at, Class<? extends Entity> clazz, EntityType type) {
        WorldServer handle = ((CraftWorld)world).getHandle();
        Entity entity = null;
        try {
            Constructor<?> constructor = NMS.getCustomEntityConstructor(clazz, type);
            entity = (Entity)constructor.newInstance(handle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.spawning-custom-entity", e.getMessage());
            return null;
        }
        entity.setLocation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        handle.addEntity(entity);
        entity.setLocation(at.getX(), at.getY(), at.getZ(), at.getYaw(), at.getPitch());
        return entity.getBukkitEntity();
    }

    public static void stopNavigation(Navigation navigation) {
        navigation.h();
    }

    public static void trySwim(org.bukkit.entity.Entity entity) {
        NMS.trySwim(entity, 0.04f);
    }

    public static void trySwim(org.bukkit.entity.Entity entity, float power) {
        Entity handle = NMS.getHandle(entity);
        if (RANDOM.nextFloat() < 0.8f && NMS.inWater(entity)) {
            handle.motY += (double)power;
        }
    }

    public static void updateAI(EntityLiving entity) {
        if (entity instanceof EntityInsentient) {
            EntityInsentient handle = (EntityInsentient)entity;
            handle.getEntitySenses().a();
            NMS.updateNavigation(handle.getNavigation());
            handle.getControllerMove().c();
            handle.getControllerLook().a();
            handle.getControllerJump().b();
        } else if (entity instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity).updateAI();
        }
    }

    public static void updateNavigation(Navigation navigation) {
        navigation.f();
    }

    public static void updateNavigationWorld(org.bukkit.entity.Entity entity, org.bukkit.World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        Entity en = NMS.getHandle(entity);
        if (en == null || !(en instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.set(handle.getNavigation(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
    }

    public static void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (!npc.isSpawned() || !npc.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving en = NMS.getHandle((LivingEntity)npc.getEntity());
        if (!(en instanceof EntityInsentient)) {
            if (en instanceof EntityHumanNPC) {
                ((EntityHumanNPC)en).updatePathfindingRange(pathfindingRange);
            }
            return;
        }
        if (PATHFINDING_RANGE == null) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        Navigation navigation = handle.getNavigation();
        try {
            AttributeInstance inst = (AttributeInstance)PATHFINDING_RANGE.get(navigation);
            inst.setValue((double)pathfindingRange);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static {
        ENTITY_CONSTRUCTOR_CACHE = new WeakHashMap();
        GOAL_FIELD = NMS.getField(PathfinderGoalSelector.class, "b");
        JUMP_FIELD = NMS.getField(EntityLiving.class, "bc");
        MC_ENTITY_CLASS_TO_INT = null;
        MC_ENTITY_INT_TO_CLASS = null;
        NAVIGATION_WORLD_FIELD = NMS.getField(Navigation.class, "b");
        NETWORK_ADDRESS = NMS.getField(NetworkManager.class, "n");
        NETWORK_CHANNEL = NMS.getField(NetworkManager.class, "m");
        PACKET_CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        PATHFINDING_RANGE = NMS.getField(Navigation.class, "e");
        RANDOM = Util.getFastRandom();
        try {
            Field field = NMS.getField(EntityTypes.class, "e");
            ENTITY_INT_TO_CLASS = (Map)field.get(null);
            field = NMS.getField(EntityTypes.class, "f");
            ENTITY_CLASS_TO_INT = (Map)field.get(null);
            field = NMS.getField(EntityTypes.class, "d");
            ENTITY_CLASS_TO_NAME = (Map)field.get(null);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
            try {
                Field field = NMS.getField(Class.forName("ns"), "d");
                MC_ENTITY_INT_TO_CLASS = (Map)field.get(null);
                field = NMS.getField(Class.forName("ns"), "e");
                MC_ENTITY_CLASS_TO_INT = (Map)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

