/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Iterator;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCCombustByBlockEvent;
import net.citizensnpcs.api.event.NPCCombustByEntityEvent;
import net.citizensnpcs.api.event.NPCCombustEvent;
import net.citizensnpcs.api.event.NPCDamageByBlockEvent;
import net.citizensnpcs.api.event.NPCDamageByEntityEvent;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.trait.CurrentLocation;
import net.minecraft.server.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class EventListen
implements Listener {
    private final NPCRegistry npcRegistry = CitizensAPI.getNPCRegistry();
    private final ListMultimap<ChunkCoord, Integer> toRespawn = ArrayListMultimap.create();

    @EventHandler(ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        ChunkCoord coord = this.toCoord(event.getChunk());
        if (!this.toRespawn.containsKey((Object)coord)) {
            return;
        }
        Iterator i$ = this.toRespawn.get((Object)coord).iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            NPC npc = this.npcRegistry.getById(id);
            npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
        }
        this.toRespawn.removeAll((Object)coord);
    }

    @EventHandler(ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        ChunkCoord coord = this.toCoord(event.getChunk());
        for (NPC npc : this.npcRegistry) {
            if (!npc.isSpawned()) continue;
            Location loc = npc.getBukkitEntity().getLocation();
            Chunk chunk = loc.getChunk();
            if (!event.getWorld().equals(loc.getWorld()) || event.getChunk().getX() != chunk.getX() || event.getChunk().getZ() != chunk.getZ()) continue;
            npc.despawn();
            this.toRespawn.put((Object)coord, (Object)npc.getId());
        }
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        NPC npc = this.npcRegistry.getNPC(event.getEntity());
        if (npc == null) {
            return;
        }
        if (event instanceof EntityCombustByEntityEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByEntityEvent((EntityCombustByEntityEvent)event, npc));
        } else if (event instanceof EntityCombustByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustByBlockEvent((EntityCombustByBlockEvent)event, npc));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCCombustEvent(event, npc));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!this.npcRegistry.isNPC(event.getEntity())) {
            return;
        }
        NPC npc = this.npcRegistry.getNPC(event.getEntity());
        if (event instanceof EntityDamageByEntityEvent) {
            NPCDamageByEntityEvent damageEvent = new NPCDamageByEntityEvent(npc, (EntityDamageByEntityEvent)event);
            Bukkit.getPluginManager().callEvent((Event)damageEvent);
            if (!damageEvent.isCancelled() || !(damageEvent.getDamager() instanceof Player)) {
                return;
            }
            Player damager = (Player)damageEvent.getDamager();
            NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
            Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
        } else if (event instanceof EntityDamageByBlockEvent) {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageByBlockEvent(npc, (EntityDamageByBlockEvent)event));
        } else {
            Bukkit.getPluginManager().callEvent((Event)new NPCDamageEvent(npc, event));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (!this.npcRegistry.isNPC((Entity)event.getEntity())) {
            return;
        }
        NPC npc = this.npcRegistry.getNPC((Entity)event.getEntity());
        npc.despawn();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (event.isCancelled() && this.npcRegistry.isNPC((Entity)event.getEntity())) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        if (this.npcRegistry.isNPC(event.getEntity()) && event.getTarget() instanceof Player) {
            NPC npc = this.npcRegistry.getNPC(event.getEntity());
            Player player = (Player)event.getTarget();
            NPCRightClickEvent rightClickEvent = new NPCRightClickEvent(npc, player);
            Bukkit.getPluginManager().callEvent((Event)rightClickEvent);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        EntityPlayer handle = ((CraftPlayer)event.getPlayer()).getHandle();
        if (!(handle instanceof EntityHumanNPC)) {
            return;
        }
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        int maxChecks;
        if (event.getCreator().hasPermission("citizens.admin.avoid-limits")) {
            return;
        }
        int limit = Settings.Setting.DEFAULT_NPC_LIMIT.asInt();
        for (int i = maxChecks = Settings.Setting.MAX_NPC_LIMIT_CHECKS.asInt(); i >= 0; --i) {
            if (!event.getCreator().hasPermission("citizens.npc.limit." + i)) continue;
            limit = i;
            break;
        }
        if (limit < 0) {
            return;
        }
        int owned = 0;
        for (NPC npc : this.npcRegistry) {
            if (!npc.getTrait(Owner.class).isOwnedBy((CommandSender)event.getCreator())) continue;
            ++owned;
        }
        if (limit >= owned + 1 || limit == 0) {
            event.setCancelled(true);
            event.setCancelReason(String.format("Over the NPC limit of %d.", limit));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!this.npcRegistry.isNPC(event.getRightClicked())) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityTargetEvent(event.getRightClicked(), (Entity)event.getPlayer(), EntityTargetEvent.TargetReason.CUSTOM));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Editor.leave(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldLoad(WorldLoadEvent event) {
        for (ChunkCoord chunk : this.toRespawn.keySet()) {
            if (!event.getWorld().isChunkLoaded(chunk.x, chunk.z)) continue;
            Iterator i$ = this.toRespawn.get((Object)chunk).iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                NPC npc = this.npcRegistry.getById(id);
                npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
            }
            this.toRespawn.removeAll((Object)chunk);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        for (NPC npc : this.npcRegistry) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getWorld().equals(event.getWorld())) continue;
            this.storeForRespawn(npc);
            npc.despawn();
        }
    }

    private void storeForRespawn(NPC npc) {
        this.toRespawn.put((Object)this.toCoord(npc.getBukkitEntity().getLocation().getChunk()), (Object)npc.getId());
    }

    private ChunkCoord toCoord(Chunk chunk) {
        return new ChunkCoord(chunk);
    }

    private static class ChunkCoord {
        private final int x;
        private final int z;

        private ChunkCoord(Chunk chunk) {
            this(chunk.getX(), chunk.getZ());
        }

        private ChunkCoord(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkCoord other = (ChunkCoord)obj;
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            int prime = 31;
            return 31 * (31 + this.x) + this.z;
        }
    }
}

