/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;

public class NavigatorParameters
implements Cloneable {
    private boolean avoidWater;
    private float range;
    private float speed;
    private float speedModifier = 1.0f;
    private int stationaryTicks = -1;
    private StuckAction stuckAction = TeleportStuckAction.INSTANCE;

    public boolean avoidWater() {
        return this.avoidWater;
    }

    public NavigatorParameters avoidWater(boolean avoidWater) {
        this.avoidWater = avoidWater;
        return this;
    }

    public float baseSpeed() {
        return this.speed;
    }

    public NavigatorParameters clone() {
        try {
            return (NavigatorParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public float modifiedSpeed(float toModify) {
        return toModify * this.speedModifier();
    }

    public float range() {
        return this.range;
    }

    public NavigatorParameters range(float range) {
        this.range = range;
        return this;
    }

    public float speed() {
        return this.modifiedSpeed(this.speed);
    }

    public NavigatorParameters speed(float speed) {
        this.speed = speed;
        return this;
    }

    public float speedModifier() {
        return this.speedModifier;
    }

    public NavigatorParameters speedModifier(float percent) {
        this.speedModifier = percent;
        return this;
    }

    public int stationaryTicks() {
        return this.stationaryTicks;
    }

    public NavigatorParameters stationaryTicks(int ticks) {
        this.stationaryTicks = ticks;
        return this;
    }

    public StuckAction stuckAction() {
        return this.stuckAction;
    }

    public NavigatorParameters stuckAction(StuckAction action) {
        this.stuckAction = action;
        return this;
    }
}

