/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.NPCDataStore;
import net.citizensnpcs.PaymentListener;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.event.CitizensDisableEvent;
import net.citizensnpcs.api.event.CitizensEnableEvent;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.scripting.EventRegistrar;
import net.citizensnpcs.api.scripting.ObjectProvider;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.CommandManager;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.command.AdminCommands;
import net.citizensnpcs.command.command.EditorCommands;
import net.citizensnpcs.command.command.HelpCommands;
import net.citizensnpcs.command.command.NPCCommands;
import net.citizensnpcs.command.command.ScriptCommands;
import net.citizensnpcs.command.command.TraitCommands;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.CommandUsageException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.command.exception.UnhandledCommandException;
import net.citizensnpcs.command.exception.WrappedCommandException;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.npc.CitizensTraitFactory;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.util.Messages;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Translator;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final CommandManager commands = new CommandManager();
    private boolean compatible;
    private Settings config;
    private ClassLoader contextClassLoader;
    private CitizensNPCRegistry npcRegistry;
    private NPCDataStore saves;
    private NPCSelector selector;
    private CitizensTraitFactory traitFactory;
    private static final String COMPATIBLE_MC_VERSION = "1.3";

    private void despawnNPCs() {
        Iterator<NPC> itr = this.npcRegistry.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            npc.despawn();
            itr.remove();
        }
    }

    private void enableSubPlugins() {
        File[] files;
        File root = new File(this.getDataFolder(), Settings.Setting.SUBPLUGIN_FOLDER.asString());
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        for (File file : files = root.listFiles()) {
            Plugin plugin;
            try {
                plugin = Bukkit.getPluginManager().loadPlugin(file);
            }
            catch (Exception e) {
                continue;
            }
            if (plugin == null) continue;
            try {
                Messaging.logF("Loading %s", plugin.getDescription().getFullName());
                plugin.onLoad();
            }
            catch (Throwable ex) {
                Messaging.severe(ex.getMessage() + " initializing " + plugin.getDescription().getFullName());
                ex.printStackTrace();
            }
        }
        ((CraftServer)Bukkit.getServer()).enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    public Iterable<CommandManager.CommandInfo> getCommands(String base) {
        return this.commands.getCommands(base);
    }

    @Override
    public NPCRegistry getNPCRegistry() {
        return this.npcRegistry;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public File getScriptFolder() {
        return new File(this.getDataFolder(), "scripts");
    }

    @Override
    public TraitFactory getTraitFactory() {
        return this.traitFactory;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        block10: {
            try {
                String modifier;
                String[] split = new String[args.length + 1];
                System.arraycopy(args, 0, split, 1, args.length);
                split[0] = cmd.getName().toLowerCase();
                String string = modifier = args.length > 0 ? args[0] : "";
                if (!this.commands.hasCommand(split[0], modifier) && !modifier.isEmpty()) {
                    return this.suggestClosestModifier(sender, split[0], modifier);
                }
                NPC npc = this.selector.getSelected(sender);
                try {
                    this.commands.execute(split, sender, sender, npc);
                }
                catch (ServerCommandException ex) {
                    Messaging.send(sender, "You must be in-game to execute that command.");
                }
                catch (CommandUsageException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                    Messaging.sendError(sender, ex.getUsage());
                }
                catch (WrappedCommandException ex) {
                    throw ex.getCause();
                }
                catch (UnhandledCommandException ex) {
                    return false;
                }
                catch (CommandException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                }
            }
            catch (NumberFormatException ex) {
                Messaging.sendError(sender, "That is not a valid number.");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!(sender instanceof Player)) break block10;
                Messaging.sendError(sender, "Please report this error: [See console]");
                Messaging.sendError(sender, ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        return true;
    }

    public void onDisable() {
        Bukkit.getPluginManager().callEvent((Event)new CitizensDisableEvent());
        Editor.leaveAll();
        CitizensAPI.shutdown();
        this.tearDownScripting();
        if (this.compatible) {
            this.saves.storeAll(this.npcRegistry);
            this.saves.saveToDiskImmediate();
            this.despawnNPCs();
            this.npcRegistry = null;
        }
        Messaging.logF("v%s disabled.", this.getDescription().getVersion());
    }

    public void onEnable() {
        String mcVersion = ((CraftServer)this.getServer()).getServer().getVersion();
        this.compatible = mcVersion.startsWith(COMPATIBLE_MC_VERSION);
        if (!this.compatible) {
            Messaging.severeF("v%s is not compatible with Minecraft v%s. Disabling.", this.getDescription().getVersion(), mcVersion);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerScriptHelpers();
        this.config = new Settings(this.getDataFolder());
        this.saves = NPCDataStore.create(this.getDataFolder());
        if (this.saves == null) {
            Messaging.severeTr(Messages.FAILED_LOAD_SAVES);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.npcRegistry = new CitizensNPCRegistry(this.saves);
        this.traitFactory = new CitizensTraitFactory();
        this.selector = new NPCSelector(this);
        CitizensAPI.setImplementation(this);
        this.getServer().getPluginManager().registerEvents((Listener)new EventListen(), (Plugin)this);
        if (Settings.Setting.NPC_COST.asDouble() > 0.0) {
            this.setupEconomy();
        }
        this.registerCommands();
        this.setupTranslator();
        Messaging.logF("v%s enabled.", this.getDescription().getVersion());
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Citizens.this.saves.loadInto(Citizens.this.npcRegistry);
                Citizens.this.startMetrics();
                Citizens.this.enableSubPlugins();
                Citizens.this.scheduleSaveTask(Settings.Setting.SAVE_TASK_DELAY.asInt());
                Bukkit.getPluginManager().callEvent((Event)new CitizensEnableEvent());
            }
        }) == -1) {
            Messaging.severe("NPC load task couldn't be scheduled - disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severeTr(Messages.CITIZENS_IMPLEMENTATION_DISABLED);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(HelpCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(ScriptCommands.class);
        this.commands.register(TraitCommands.class);
    }

    private void registerScriptHelpers() {
        this.setupScripting();
        ScriptCompiler compiler = CitizensAPI.getScriptCompiler();
        compiler.registerGlobalContextProvider(new EventRegistrar(this));
        compiler.registerGlobalContextProvider(new ObjectProvider("plugin", this));
    }

    public void reload() throws NPCLoadException {
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs();
        this.saves.loadInto(this.npcRegistry);
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    private void scheduleSaveTask(int delay) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Citizens.this.storeNPCs();
                Citizens.this.saves.saveToDisk();
            }
        });
    }

    private void setupEconomy() {
        try {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
            if (provider != null && provider.getProvider() != null) {
                Economy economy = (Economy)provider.getProvider();
                Bukkit.getPluginManager().registerEvents((Listener)new PaymentListener(economy), (Plugin)this);
            }
        }
        catch (NoClassDefFoundError e) {
            Messaging.log("Unable to use economy handling. Has Vault been enabled?");
        }
    }

    private void setupScripting() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
    }

    private void setupTranslator() {
        Locale locale = Locale.getDefault();
        String[] parts = Settings.Setting.LOCALE.asString().split("[\\._]");
        switch (parts.length) {
            case 1: {
                locale = new Locale(parts[0]);
                break;
            }
            case 2: {
                locale = new Locale(parts[0], parts[1]);
                break;
            }
            case 3: {
                locale = new Locale(parts[0], parts[1], parts[2]);
                break;
            }
        }
        Translator.setInstance(new File(this.getDataFolder(), "i18n"), locale);
        Messaging.logF("Using locale %s.", locale);
    }

    private void startMetrics() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Metrics metrics = new Metrics(Citizens.this);
                    if (metrics.isOptOut()) {
                        return;
                    }
                    metrics.addCustomData(new Metrics.Plotter("Total NPCs"){

                        @Override
                        public int getValue() {
                            return Iterables.size((Iterable)Citizens.this.npcRegistry);
                        }
                    });
                    Citizens.this.traitFactory.addPlotters(metrics.createGraph("traits"));
                    metrics.start();
                    Messaging.log("Metrics started.");
                }
                catch (IOException e) {
                    Messaging.logF("Unable to start metrics: %s.", e.getMessage());
                }
            }
        }.start();
    }

    public void storeNPCs() {
        if (this.saves == null) {
            return;
        }
        for (NPC npc : this.npcRegistry) {
            this.saves.store(npc);
        }
    }

    public void storeNPCs(CommandContext args) {
        this.storeNPCs();
        boolean async = args.hasFlag('a');
        if (async) {
            this.saves.saveToDisk();
        } else {
            this.saves.saveToDiskImmediate();
        }
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        String closest = "";
        for (String string : this.commands.getAllCommandModifiers(command)) {
            int distance = StringHelper.getLevenshteinDistance(modifier, string);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = string;
        }
        if (!closest.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "Unknown command. Did you mean:");
            sender.sendMessage(StringHelper.wrap(" /") + command + " " + StringHelper.wrap(closest));
            return true;
        }
        return false;
    }

    private void tearDownScripting() {
        if (Thread.currentThread().getContextClassLoader() == this.getClassLoader()) {
            Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        }
    }
}

