/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandAction
extends NPCShopAction {
    @Persist
    public List<String> commands = Lists.newArrayList();
    @Persist
    public boolean op = false;
    @Persist
    public boolean server = false;

    public CommandAction() {
    }

    public CommandAction(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public String describe() {
        String description = this.commands.size() + " command";
        for (int i = 0; i < this.commands.size(); ++i) {
            description = description + "\n" + this.commands.get(i);
            if (i != 3) continue;
            description = description + "...";
            break;
        }
        return description;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventory) {
        return -1;
    }

    @Override
    public NPCShopAction.Transaction grant(ShopTrait.NPCShopStorage storage, Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        return NPCShopAction.Transaction.create(() -> true, () -> {
            for (int i = 0; i < repeats; ++i) {
                for (String command : this.commands) {
                    Util.runCommand(null, player, command, this.op, !this.server);
                }
            }
            inventory.refresh();
        }, () -> {});
    }

    @Override
    public NPCShopAction.Transaction take(ShopTrait.NPCShopStorage storage, Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        return NPCShopAction.Transaction.create(() -> true, () -> {
            for (int i = 0; i < repeats; ++i) {
                for (String command : this.commands) {
                    Util.runCommand(null, player, command, this.op, !this.server);
                }
            }
            inventory.refresh();
        }, () -> {});
    }

    public static class CommandActionGUI
    implements NPCShopAction.GUI {
        @Override
        public boolean canUse(HumanEntity entity) {
            return entity.hasPermission("citizens.npc.shop.editor.actions.edit-command");
        }

        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            return new CommandActionEditor(previous == null ? new CommandAction() : (CommandAction)previous, callback);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            String description = null;
            if (previous != null) {
                CommandAction old = (CommandAction)previous;
                description = old.describe();
            }
            return Util.createItem(Util.getFallbackMaterial("COMMAND_BLOCK", "COMMAND"), "Command", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof CommandAction;
        }
    }

    @Menu(title="Command editor", dimensions={4, 9})
    public static class CommandActionEditor
    extends InventoryMenuPage {
        private CommandAction base;
        private Consumer<NPCShopAction> callback;

        public CommandActionEditor() {
        }

        public CommandActionEditor(CommandAction base, Consumer<NPCShopAction> callback) {
            this.base = base;
            this.callback = callback;
        }

        @Override
        public void initialise(MenuContext ctx) {
            for (int i = 0; i < 27; ++i) {
                int idx = i;
                ctx.getSlot(i).clear();
                if (i < this.base.commands.size()) {
                    ctx.getSlot(i).setItemStack(new ItemStack(Material.FEATHER), "<f>Set command", "Right click to remove\nCurrently: " + this.base.commands.get(i));
                }
                ctx.getSlot(i).setClickHandler(event -> {
                    if (event.isRightClick()) {
                        event.setCancelled(true);
                        if (idx < this.base.commands.size()) {
                            this.base.commands.remove(idx);
                            ctx.getSlot(idx).setItemStack(null);
                        }
                        return;
                    }
                    ctx.getMenu().transition(InputMenus.stringSetter(() -> idx < this.base.commands.size() ? this.base.commands.get(idx) : "", res -> {
                        if (res == null) {
                            if (idx < this.base.commands.size()) {
                                this.base.commands.remove(idx);
                            }
                            return;
                        }
                        if (idx < this.base.commands.size()) {
                            this.base.commands.set(idx, (String)res);
                        } else {
                            this.base.commands.add((String)res);
                        }
                    }));
                });
            }
            ctx.getSlot(30).setItemStack(new ItemStack(Util.getFallbackMaterial("COMMAND_BLOCK", "COMMAND")), "Run commands as server", this.base.server ? ChatColor.GREEN + "On" : ChatColor.RED + "OFF");
            ctx.getSlot(30).addClickHandler(InputMenus.toggler(res -> {
                this.base.server = res;
            }, this.base.server));
            ctx.getSlot(31).setItemStack(new ItemStack(Util.getFallbackMaterial("COMPARATOR", "REDSTONE_COMPARATOR")), "Run commands as op", this.base.op ? ChatColor.GREEN + "On" : ChatColor.RED + "OFF");
            ctx.getSlot(31).addClickHandler(InputMenus.clickToggle(res -> {
                this.base.op = res;
                return res != false ? ChatColor.GREEN + "On" : ChatColor.RED + "Off";
            }, this.base.server));
        }

        @Override
        public void onClose(HumanEntity player) {
            this.callback.accept(this.base.commands.isEmpty() ? null : this.base);
        }
    }
}

