/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.Map;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.GuidedWaypointProvider;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;

@TraitName(value="waypoints")
public class Waypoints
extends Trait {
    private WaypointProvider provider = new LinearWaypointProvider();
    private String providerName = "linear";
    private static final Map<String, Constructor<? extends WaypointProvider>> PROVIDERS = Maps.newHashMap();

    public Waypoints() {
        super("waypoints");
    }

    private WaypointProvider create(String name, Constructor<? extends WaypointProvider> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void describeProviders(CommandSender sender) {
        Messaging.sendTr(sender, "citizens.waypoints.available-providers-header", new Object[0]);
        for (String name : PROVIDERS.keySet()) {
            Messaging.send(sender, "    - " + StringHelper.wrap(name));
        }
    }

    public WaypointProvider getCurrentProvider() {
        return this.provider;
    }

    public String getCurrentProviderName() {
        return this.providerName;
    }

    public Editor getEditor(CommandSender player, CommandContext args) {
        return this.provider.createEditor(player, args);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.providerName = key.getString("provider", "linear");
        this.provider = this.create(this.providerName, PROVIDERS.get(this.providerName));
        if (this.provider == null) {
            return;
        }
        PersistenceLoader.load(this.provider, key.getRelative(this.providerName));
        if (this.npc != null) {
            this.provider.onSpawn(this.npc);
        }
    }

    @Override
    public void onSpawn() {
        if (this.provider != null) {
            this.provider.onSpawn(this.getNPC());
        }
    }

    @Override
    public void save(DataKey key) {
        if (this.provider == null) {
            return;
        }
        PersistenceLoader.save(this.provider, key.getRelative(this.providerName));
        key.setString("provider", this.providerName);
    }

    public boolean setWaypointProvider(String name) {
        if (name == null || name.isEmpty()) {
            if (this.provider != null) {
                this.provider.onRemove();
            }
            this.provider = null;
            return true;
        }
        name = name.toLowerCase(Locale.ROOT);
        Constructor<? extends WaypointProvider> clazz = PROVIDERS.get(name);
        if (this.provider != null) {
            this.provider.onRemove();
        }
        this.provider = null;
        this.providerName = null;
        if (clazz == null || (this.provider = this.create(name, clazz)) == null) {
            return false;
        }
        this.providerName = name;
        if (this.npc != null && this.npc.isSpawned()) {
            this.provider.onSpawn(this.npc);
        }
        return true;
    }

    public static void registerWaypointProvider(Class<? extends WaypointProvider> clazz, String name) {
        try {
            PROVIDERS.put(name, clazz.getConstructor(new Class[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Waypoints.registerWaypointProvider(LinearWaypointProvider.class, "linear");
        Waypoints.registerWaypointProvider(WanderWaypointProvider.class, "wander");
        Waypoints.registerWaypointProvider(GuidedWaypointProvider.class, "guided");
    }
}

