/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.Direction;
import net.citizensnpcs.api.hpastar.HPACluster;
import net.citizensnpcs.api.hpastar.HPAGraphAStarNode;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;
import net.citizensnpcs.api.hpastar.ReversableAStarNode;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Location;

public class HPAGraph {
    private final BlockSource blockSource;
    public List<List<HPACluster>> clusters = new ArrayList<List<HPACluster>>();
    private final int cx;
    private final int cy;
    private final int cz;
    private final List<PhTreeSolid<HPACluster>> phtrees = new ArrayList<PhTreeSolid<HPACluster>>();
    private static int BASE_CLUSTER_HEIGHT = (int)(2.0 * Math.pow(2.0, 2.0));
    private static int BASE_CLUSTER_SIZE = (int)(2.0 * Math.pow(2.0, 3.0));
    private static final float DIAGONAL_WEIGHT = (float)Math.sqrt(2.0);
    private static int MAX_CLUSTER_SIZE = (int)(2.0 * Math.pow(2.0, 5.0));
    private static int MAX_DEPTH = 3;

    public HPAGraph(BlockSource blockSource, int cx, int cy, int cz) {
        this.blockSource = blockSource;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        while (this.clusters.size() <= MAX_DEPTH) {
            this.clusters.add(new ArrayList());
            if (this.clusters.size() == this.phtrees.size()) continue;
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
    }

    public void addClusters(int x, int z) {
        PhTreeSolid<HPACluster> baseLevel;
        PhTreeSolid.PhQueryS existingQuery;
        int baseX = MAX_CLUSTER_SIZE * ((x - this.cx) / MAX_CLUSTER_SIZE) + this.cx;
        int baseZ = MAX_CLUSTER_SIZE * ((z - this.cz) / MAX_CLUSTER_SIZE) + this.cz;
        if (this.phtrees.size() == 0) {
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
        if ((existingQuery = (baseLevel = this.phtrees.get(0)).queryIntersect(new long[]{baseX, 0L, baseZ}, new long[]{baseX + MAX_CLUSTER_SIZE, 256L, baseZ + MAX_CLUSTER_SIZE})).hasNext()) {
            Messaging.log("Clusters already exist for region:", baseX, baseZ);
            return;
        }
        Messaging.log("Building clusters for:", baseX, baseZ);
        ArrayList<HPACluster> newClusters = new ArrayList<HPACluster>();
        int clusterSize = BASE_CLUSTER_SIZE;
        int clusterHeight = BASE_CLUSTER_HEIGHT;
        for (int y = 0; y < 256; y += clusterHeight) {
            for (int ci = 0; ci < MAX_CLUSTER_SIZE; ci += clusterSize) {
                for (int cj = 0; cj < MAX_CLUSTER_SIZE; cj += clusterSize) {
                    HPACluster cluster = new HPACluster(this, 0, clusterSize, clusterHeight, baseX + ci, y, baseZ + cj);
                    if (!cluster.hasWalkableNodes()) continue;
                    newClusters.add(cluster);
                    baseLevel.put(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize}, (Object)cluster);
                    Messaging.log(cluster);
                }
            }
        }
        HashMultimap neighbours = HashMultimap.create();
        for (HPACluster cluster : newClusters) {
            PhTreeSolid.PhQueryS q = baseLevel.queryIntersect(new long[]{cluster.clusterX - clusterSize, cluster.clusterY - clusterHeight, cluster.clusterZ - clusterSize}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize});
            while (q.hasNext()) {
                int dz;
                int dy;
                HPACluster neighbour = (HPACluster)q.nextValue();
                if (neighbour == cluster || neighbours.get((Object)cluster).contains(neighbour)) continue;
                int dx = neighbour.clusterX - cluster.clusterX;
                int nonZeroCount = (dx != 0 ? 1 : 0) + ((dy = neighbour.clusterY - cluster.clusterY) != 0 ? 1 : 0) + ((dz = neighbour.clusterZ - cluster.clusterZ) != 0 ? 1 : 0);
                if (nonZeroCount == 1) {
                    Direction direction = null;
                    if (dx > 0) {
                        direction = Direction.EAST;
                    } else if (dx < 0) {
                        direction = Direction.WEST;
                    } else if (dz > 0) {
                        direction = Direction.NORTH;
                    } else if (dz < 0) {
                        direction = Direction.SOUTH;
                    } else if (dy > 0) {
                        direction = Direction.UP;
                    } else if (dy < 0) {
                        direction = Direction.DOWN;
                    }
                    if (direction == null) continue;
                    cluster.connect(neighbour, direction);
                    neighbours.get((Object)cluster).add(neighbour);
                    neighbours.get((Object)neighbour).add(cluster);
                    Messaging.log("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (nonZeroCount != 2 || dy != 0) continue;
                cluster.connectDiagonal(neighbour, Integer.signum(dx), Integer.signum(dz), DIAGONAL_WEIGHT);
                neighbours.get((Object)cluster).add(neighbour);
                neighbours.get((Object)neighbour).add(cluster);
                Messaging.log("CONNECTED DIAGONAL", cluster, neighbour);
            }
        }
        for (HPACluster cluster : newClusters) {
            cluster.connectIntra();
        }
        this.addClustersAtDepth(0, newClusters);
        for (int depth = 1; depth <= MAX_DEPTH; ++depth) {
            newClusters = new ArrayList();
            clusterSize = (int)((double)BASE_CLUSTER_SIZE * Math.pow(2.0, depth));
            clusterHeight = (int)((double)BASE_CLUSTER_HEIGHT * Math.pow(2.0, depth));
            for (int y = 0; y < 256; y += clusterHeight) {
                for (int ci = 0; ci < MAX_CLUSTER_SIZE; ci += clusterSize) {
                    for (int cj = 0; cj < MAX_CLUSTER_SIZE; cj += clusterSize) {
                        HPACluster cluster = new HPACluster(this, depth, clusterSize, clusterHeight, baseX + ci, y, baseZ + cj);
                        ArrayList parentClusters = Lists.newArrayList((Iterator)this.phtrees.get(depth - 1).queryInclude(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize}));
                        if (parentClusters.size() == 0) continue;
                        cluster.buildFrom(parentClusters);
                        this.phtrees.get(depth).put(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize}, (Object)cluster);
                        Messaging.log(cluster);
                        newClusters.add(cluster);
                    }
                }
            }
            this.addClustersAtDepth(depth, newClusters);
        }
    }

    public void addClustersAtDepth(int depth, List<HPACluster> other) {
        this.clusters.get(depth).addAll(other);
    }

    public Plan findPath(Location start, Location goal) {
        ArrayList<HPACluster> clustersToClean = new ArrayList<HPACluster>();
        HPAGraphNode startNode = new HPAGraphNode(start.getBlockX(), start.getBlockY(), start.getBlockZ());
        HPAGraphNode goalNode = new HPAGraphNode(goal.getBlockX(), goal.getBlockY(), goal.getBlockZ());
        HPACluster startCluster = this.getClusterAt(0, startNode.x, startNode.y, startNode.z);
        HPACluster goalCluster = this.getClusterAt(0, goalNode.x, goalNode.y, goalNode.z);
        if (startCluster == null || goalCluster == null) {
            return new Path(Collections.emptyList());
        }
        startCluster.insert(startNode);
        clustersToClean.add(startCluster);
        if (goalCluster != startCluster) {
            goalCluster.insert(goalNode);
            clustersToClean.add(goalCluster);
        } else if (!goalNode.equals(startNode)) {
            startCluster.insert(goalNode);
        }
        AStarSolution sln = this.pathfind(startNode, goalNode, 0);
        System.out.println(":" + start + "->" + goal + "@" + sln.cost);
        for (HPACluster cluster : clustersToClean) {
            cluster.remove(startNode, goalNode);
        }
        return new Path(sln.convertToVectors());
    }

    public void invalidateCluster(int x, int y, int z) {
        for (int depth = 0; depth < this.phtrees.size(); ++depth) {
            PhTreeSolid<HPACluster> phtree = this.phtrees.get(depth);
            PhTreeSolid.PhQueryS q = phtree.queryIntersect(new long[]{x, y, z}, new long[]{x, y, z});
            while (q.hasNext()) {
                HPACluster cluster = (HPACluster)q.nextValue();
                phtree.remove(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + cluster.clusterSize, cluster.clusterY + cluster.clusterHeight, cluster.clusterZ + cluster.clusterSize});
                this.clusters.get(depth).remove(cluster);
                Messaging.log("Invalidated cluster:", cluster);
            }
        }
        this.addClusters(x, z);
    }

    AStarSolution pathfind(HPAGraphNode start, HPAGraphNode dest, int level) {
        if (start.equals(dest)) {
            return new AStarSolution(Lists.newArrayList((Object[])new ReversableAStarNode[]{new HPAGraphAStarNode(start, null)}), 0.0f);
        }
        HashMap<HPAGraphAStarNode, Float> open = new HashMap<HPAGraphAStarNode, Float>();
        HashMap<HPAGraphAStarNode, Float> closed = new HashMap<HPAGraphAStarNode, Float>();
        PriorityQueue<HPAGraphAStarNode> frontier = new PriorityQueue<HPAGraphAStarNode>();
        HPAGraphAStarNode startNode = new HPAGraphAStarNode(start, null);
        frontier.add(startNode);
        open.put(startNode, Float.valueOf(startNode.g));
        while (!frontier.isEmpty()) {
            HPAGraphAStarNode node = (HPAGraphAStarNode)frontier.poll();
            List<HPAGraphEdge> edges = node.node.getEdges(level);
            if (start != node.node) {
                closed.put(node, Float.valueOf(node.g));
            }
            open.remove(node);
            for (HPAGraphEdge edge : edges) {
                HPAGraphAStarNode neighbour = new HPAGraphAStarNode(edge.to, edge);
                if (closed.containsKey(neighbour)) continue;
                neighbour.parent = node;
                neighbour.g = node.g + edge.weight;
                neighbour.h = (float)edge.to.distance(dest);
                if (edge.to.equals(dest)) {
                    return new AStarSolution(neighbour.reconstructSolution(), neighbour.g);
                }
                if (open.containsKey(neighbour)) {
                    if (neighbour.g > ((Float)open.get(neighbour)).floatValue()) continue;
                    frontier.remove(neighbour);
                }
                open.put(neighbour, Float.valueOf(neighbour.g));
                frontier.add(neighbour);
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    public boolean walkable(int x, int y, int z) {
        if (y == 0) {
            return false;
        }
        return MinecraftBlockExaminer.canStandIn(this.blockSource.getMaterialAt(x, y, z)) && MinecraftBlockExaminer.canStandIn(this.blockSource.getMaterialAt(x, y + 1, z)) && MinecraftBlockExaminer.canStandOn(this.blockSource.getMaterialAt(x, y - 1, z));
    }

    private HPACluster getClusterAt(int depth, int x, int y, int z) {
        PhTreeSolid.PhQueryS q = this.phtrees.get(depth).queryIntersect(new long[]{x, y, z}, new long[]{x, y, z});
        return q.hasNext() ? (HPACluster)q.next() : null;
    }
}

