/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.Waypoints;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class DelayWaypointTrigger
implements WaypointTrigger {
    @Persist
    private int delay = 0;

    @Override
    public void onWaypointReached(NPC npc, Location waypoint) {
        if (this.delay > 0) {
            this.scheduleTask(npc.getTrait(Waypoints.class).getCurrentProvider());
        }
    }

    private void scheduleTask(final WaypointProvider provider) {
        provider.setPaused(true);
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                provider.setPaused(false);
            }
        }, (long)this.delay);
    }

    public void setDelay(int newDelay) {
        this.delay = newDelay;
    }
}

