/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Navigation;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet18ArmAnimation;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;

public class MCTargetStrategy
implements PathStrategy,
EntityTarget {
    private final boolean aggro;
    private int attackTicks;
    private CancelReason cancelReason;
    private final EntityLiving handle;
    private final EntityLiving target;
    private final Navigation navigation;
    private final NavigatorParameters parameters;
    private static final int ATTACK_DELAY_TICKS = 20;
    private static final double ATTACK_DISTANCE = 3.0625;

    public MCTargetStrategy(CitizensNPC handle, LivingEntity target, boolean aggro, NavigatorParameters params) {
        this.handle = handle.getHandle();
        this.target = ((CraftLivingEntity)target).getHandle();
        this.navigation = this.handle.getNavigation();
        this.aggro = aggro;
        this.parameters = params;
        this.navigation.a(this.parameters.avoidWater());
    }

    private boolean canAttack() {
        return this.attackTicks == 0 && this.handle.boundingBox.e > this.target.boundingBox.b && this.handle.boundingBox.b < this.target.boundingBox.e && this.distanceSquared() <= 3.0625 && this.handle.l((Entity)this.target);
    }

    @Override
    public void clearCancelReason() {
        this.cancelReason = null;
    }

    private double distanceSquared() {
        return this.handle.getBukkitEntity().getLocation().distanceSquared(this.target.getBukkitEntity().getLocation());
    }

    @Override
    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    @Override
    public LivingEntity getTarget() {
        return (LivingEntity)this.target.getBukkitEntity();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.getTarget().getLocation();
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.ENTITY;
    }

    @Override
    public boolean isAggressive() {
        return this.aggro;
    }

    @Override
    public void stop() {
        this.navigation.g();
    }

    @Override
    public boolean update() {
        if (this.target == null || this.target.dead) {
            this.cancelReason = CancelReason.TARGET_DIED;
            return true;
        }
        if (this.target.world != this.handle.world) {
            this.cancelReason = CancelReason.TARGET_MOVED_WORLD;
            return true;
        }
        if (this.cancelReason != null) {
            return true;
        }
        this.navigation.a(this.parameters.avoidWater());
        this.navigation.a(this.target, this.parameters.speed());
        NMS.look(this.handle.getControllerLook(), this.handle, this.target);
        if (this.aggro && this.canAttack()) {
            AttackStrategy strategy = this.parameters.attackStrategy();
            if (strategy == null || !strategy.handle((LivingEntity)this.handle.getBukkitEntity(), this.getTarget())) {
                if (this.handle instanceof EntityPlayer) {
                    EntityPlayer humanHandle = (EntityPlayer)this.handle;
                    humanHandle.attack((Entity)this.target);
                    Util.sendPacketNearby(this.handle.getBukkitEntity().getLocation(), (Packet)new Packet18ArmAnimation((Entity)humanHandle, 1), 64.0);
                } else {
                    NMS.attack(this.handle, this.target);
                }
            }
            this.attackTicks = 20;
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        return false;
    }
}

