/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet17EntityLocationAction;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet40EntityMetadata;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public enum PlayerAnimation {
    HURT{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet18ArmAnimation packet = new Packet18ArmAnimation((Entity)player, 2);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    SLEEP{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet17EntityLocationAction packet = new Packet17EntityLocationAction((Entity)player, 0, (int)player.locX, (int)player.locY, (int)player.locZ);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    SNEAK{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setSneaking(true);
            this.sendPacketNearby((Packet)new Packet40EntityMetadata(player.id, player.getDataWatcher(), true), player, radius);
        }
    }
    ,
    STOP_SLEEPING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet18ArmAnimation packet = new Packet18ArmAnimation((Entity)player, 3);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    }
    ,
    STOP_SNEAKING{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            player.getBukkitEntity().setSneaking(false);
            this.sendPacketNearby((Packet)new Packet40EntityMetadata(player.id, player.getDataWatcher(), true), player, radius);
        }
    }
    ,
    SWING_ARM{

        @Override
        protected void playAnimation(EntityPlayer player, int radius) {
            Packet18ArmAnimation packet = new Packet18ArmAnimation((Entity)player, 1);
            this.sendPacketNearby((Packet)packet, player, radius);
        }
    };


    public void play(Player player) {
        this.playAnimation(((CraftPlayer)player).getHandle(), 64);
    }

    protected void playAnimation(EntityPlayer player, int radius) {
        throw new UnsupportedOperationException("unimplemented animation");
    }

    protected void sendPacketNearby(Packet packet, EntityPlayer player, int radius) {
        radius *= radius;
        CraftWorld world = player.world.getWorld();
        Location location = player.getBukkitEntity().getLocation();
        for (Player dest : Bukkit.getServer().getOnlinePlayers()) {
            if (dest == null || world != dest.getWorld() || location.distanceSquared(dest.getLocation()) > (double)radius) continue;
            ((CraftPlayer)dest).getHandle().netServerHandler.sendPacket(packet);
        }
    }
}

