/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Equipment
extends Trait {
    private final ItemStack[] equipment = new ItemStack[5];

    public Equipment() {
        super("equipment");
    }

    public ItemStack get(int slot) {
        if (this.npc.getBukkitEntity() instanceof Enderman && slot != 0) {
            throw new IllegalArgumentException("Slot must be 0 for enderman");
        }
        if (this.npc.getBukkitEntity() instanceof Player && (slot < 0 || slot > 4)) {
            throw new IllegalArgumentException("Slot must be between 0 and 4");
        }
        return this.equipment[slot];
    }

    public ItemStack[] getEquipment() {
        return this.equipment;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (key.keyExists("hand")) {
            this.equipment[0] = ItemStorage.loadItemStack(key.getRelative("hand"));
        }
        if (key.keyExists("helmet")) {
            this.equipment[1] = ItemStorage.loadItemStack(key.getRelative("helmet"));
        }
        if (key.keyExists("chestplate")) {
            this.equipment[2] = ItemStorage.loadItemStack(key.getRelative("chestplate"));
        }
        if (key.keyExists("leggings")) {
            this.equipment[3] = ItemStorage.loadItemStack(key.getRelative("leggings"));
        }
        if (key.keyExists("boots")) {
            this.equipment[4] = ItemStorage.loadItemStack(key.getRelative("boots"));
        }
    }

    @Override
    public void onSpawn() {
        if (this.npc.getBukkitEntity() instanceof Enderman) {
            Enderman enderman = (Enderman)this.npc.getBukkitEntity();
            if (this.equipment[0] != null) {
                enderman.setCarriedMaterial(this.equipment[0].getData());
            }
        } else if (this.npc.getBukkitEntity() instanceof Player) {
            Player player = (Player)this.npc.getBukkitEntity();
            if (this.equipment[0] != null) {
                player.setItemInHand(this.equipment[0]);
            }
            ItemStack[] armor = new ItemStack[]{this.equipment[4], this.equipment[3], this.equipment[2], this.equipment[1]};
            player.getInventory().setArmorContents(armor);
            player.updateInventory();
        }
    }

    @Override
    public void save(DataKey key) {
        this.saveOrRemove(key.getRelative("hand"), this.equipment[0]);
        this.saveOrRemove(key.getRelative("helmet"), this.equipment[1]);
        this.saveOrRemove(key.getRelative("chestplate"), this.equipment[2]);
        this.saveOrRemove(key.getRelative("leggings"), this.equipment[3]);
        this.saveOrRemove(key.getRelative("boots"), this.equipment[4]);
    }

    private void saveOrRemove(DataKey key, ItemStack item) {
        if (item != null) {
            ItemStorage.saveItem(key, item);
        } else if (key.keyExists("")) {
            key.removeKey("");
        }
    }

    public void set(int slot, ItemStack item) {
        if (this.npc.getBukkitEntity() instanceof Enderman) {
            if (slot != 0) {
                throw new UnsupportedOperationException("Slot can only be 0 for enderman");
            }
            ((Enderman)this.npc.getBukkitEntity()).setCarriedMaterial(item.getData());
        } else if (this.npc.getBukkitEntity() instanceof Player) {
            Player player = (Player)this.npc.getBukkitEntity();
            switch (slot) {
                case 0: {
                    player.setItemInHand(item);
                    break;
                }
                case 1: {
                    player.getInventory().setHelmet(item);
                    break;
                }
                case 2: {
                    player.getInventory().setChestplate(item);
                    break;
                }
                case 3: {
                    player.getInventory().setLeggings(item);
                    break;
                }
                case 4: {
                    player.getInventory().setBoots(item);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Slot must be between 0 and 4");
                }
            }
            player.updateInventory();
        }
        this.equipment[slot] = item;
    }

    public String toString() {
        return "{hand=" + this.equipment[0] + ",helmet=" + this.equipment[1] + ",chestplate=" + this.equipment[2] + ",leggings=" + this.equipment[3] + ",boots=" + this.equipment[4] + "}";
    }
}

