/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityPig;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPig;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CitizensPigNPC
extends CitizensMobNPC
implements Equipable {
    public CitizensPigNPC(int id, String name) {
        super(id, name, EntityPigNPC.class);
    }

    @Override
    public void equip(Player equipper, ItemStack hand) {
        if (hand.getType() == Material.SADDLE) {
            if (!this.getBukkitEntity().hasSaddle()) {
                this.getTrait(Saddle.class).toggle();
                hand.setAmount(0);
                Messaging.sendTr((CommandSender)equipper, "citizens.editors.equipment.saddled-set", this.getName());
            }
        } else if (this.getBukkitEntity().hasSaddle()) {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), new ItemStack(Material.SADDLE, 1));
            this.getTrait(Saddle.class).toggle();
            Messaging.sendTr((CommandSender)equipper, "citizens.editors.equipment.saddled-stopped", this.getName());
        }
    }

    public Pig getBukkitEntity() {
        return (Pig)super.getBukkitEntity();
    }

    public static class PigNPC
    extends CraftPig
    implements NPCHolder {
        private final CitizensNPC npc;

        public PigNPC(EntityPigNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPig)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }

    public static class EntityPigNPC
    extends EntityPig
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityPigNPC(World world) {
            this(world, null);
        }

        public EntityPigNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMS.clearGoals(this.goalSelector, this.targetSelector);
                NMS.setPersistent((EntityLiving)this);
            }
        }

        public void a(EntityLightning entitylightning) {
            if (this.npc == null) {
                super.a(entitylightning);
            }
        }

        public void bi() {
            super.bi();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void collide(net.minecraft.server.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, entity);
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                if (!this.npc.data().get("protected", true).booleanValue()) {
                    super.g(x, y, z);
                }
                return;
            }
            Vector vector = new Vector(x, y, z);
            NPCPushEvent event = Util.callPushEvent(this.npc, vector);
            if (!event.isCancelled()) {
                vector = event.getCollisionVector();
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public Entity getBukkitEntity() {
            if (this.bukkitEntity == null && this.npc != null) {
                this.bukkitEntity = new PigNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

