/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.waypoint.triggers.ChatTrigger;
import net.citizensnpcs.trait.waypoint.triggers.ChatTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.DelayTrigger;
import net.citizensnpcs.trait.waypoint.triggers.DelayTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTrigger;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTriggerPrompt;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.conversations.Prompt;

public class WaypointTriggerRegistry
implements Persister {
    private static final Map<String, Class<? extends Prompt>> triggerPrompts = Maps.newHashMap();
    private static final Map<String, Class<? extends WaypointTrigger>> triggers = Maps.newHashMap();

    @Override
    public Object create(DataKey root) {
        String type = root.getString("type");
        Class<? extends WaypointTrigger> clazz = triggers.get(type);
        return clazz == null ? null : (WaypointTrigger)((Object)PersistenceLoader.load(clazz, root));
    }

    @Override
    public void save(Object instance, DataKey root) {
        PersistenceLoader.save(instance, root);
    }

    public static void addTrigger(String name, Class<? extends WaypointTrigger> triggerClass, Class<? extends WaypointTriggerPrompt> promptClass) {
        triggers.put(name, triggerClass);
        triggerPrompts.put(name, promptClass);
    }

    public static String describeValidTriggerNames() {
        return Joiner.on((String)", ").join(triggerPrompts.keySet());
    }

    public static Prompt getTriggerPromptFrom(String input) {
        Class<? extends Prompt> promptClass = triggerPrompts.get(input);
        if (promptClass == null) {
            return null;
        }
        try {
            return promptClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        WaypointTriggerRegistry.addTrigger("teleport", TeleportTrigger.class, TeleportTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("delay", DelayTrigger.class, DelayTriggerPrompt.class);
        WaypointTriggerRegistry.addTrigger("chat", ChatTrigger.class, ChatTriggerPrompt.class);
    }
}

