/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.citizensnpcs.util.Messages;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;

public class Translator {
    private final Locale defaultLocale;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private ResourceBundle preferredBundle;
    private final File resourceFile;
    private static ResourceBundle defaultBundle;
    private static Translator instance;
    public static final String PREFIX = "messages";

    private Translator(File resourceFile, Locale locale) {
        this.resourceFile = resourceFile;
        this.defaultLocale = locale;
        try {
            this.preferredBundle = ResourceBundle.getBundle(PREFIX, this.defaultLocale, new FileClassLoader(Translator.class.getClassLoader(), resourceFile));
        }
        catch (MissingResourceException e) {
            this.preferredBundle = this.getDefaultBundle();
            Messaging.log(this.translate("citizens.notifications.missing-translations", locale));
        }
    }

    private String format(String key, Locale locale, Object ... msg) {
        String unreplaced = this.translate(key, locale);
        MessageFormat formatter = this.getFormatter(unreplaced);
        return formatter.format(msg);
    }

    private ResourceBundle getBundle(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(PREFIX, locale, new FileClassLoader(Translator.class.getClassLoader(), this.resourceFile));
            return bundle == null ? this.preferredBundle : bundle;
        }
        catch (MissingResourceException e) {
            return this.preferredBundle;
        }
    }

    private ResourceBundle getDefaultBundle() {
        return Translator.getDefaultResourceBundle(this.resourceFile, "messages_en.properties");
    }

    private MessageFormat getFormatter(String unreplaced) {
        MessageFormat formatter = this.messageFormatCache.get(unreplaced);
        if (formatter == null) {
            formatter = new MessageFormat(unreplaced);
            this.messageFormatCache.put(unreplaced, formatter);
        }
        return formatter;
    }

    private String translate(String key, Locale locale) {
        ResourceBundle bundle = this.preferredBundle;
        if (locale != this.defaultLocale) {
            bundle = this.getBundle(locale);
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            try {
                return this.getDefaultBundle().getString(key);
            }
            catch (MissingResourceException ex) {
                return "?" + key + "?";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getDefaultBundleProperties() {
        Properties defaults = new Properties();
        InputStream in = null;
        try {
            in = Messages.class.getResourceAsStream("/messages_en.properties");
            defaults.load(in);
        }
        catch (IOException iOException) {
        }
        finally {
            Closeables.closeQuietly((Closeable)in);
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getDefaultResourceBundle(File resourceDirectory, String fileName) {
        if (defaultBundle != null) {
            return defaultBundle;
        }
        resourceDirectory.mkdirs();
        File bundleFile = new File(resourceDirectory, fileName);
        if (!bundleFile.exists()) {
            try {
                bundleFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Translator.populateDefaults(bundleFile);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(bundleFile);
            defaultBundle = new PropertyResourceBundle(stream);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                defaultBundle = Translator.getFallbackResourceBundle();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        Closeables.closeQuietly((Closeable)stream);
        return defaultBundle;
    }

    private static ResourceBundle getFallbackResourceBundle() {
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return new Object[0][0];
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void populateDefaults(File bundleFile) {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(bundleFile);
            properties.load(in);
        }
        catch (IOException e) {
            Closeables.closeQuietly((Closeable)in);
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        Properties defaults = Translator.getDefaultBundleProperties();
        for (Map.Entry<Object, Object> entry : defaults.entrySet()) {
            if (properties.containsKey(entry.getKey())) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(bundleFile);
            properties.store(stream, "");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        Closeables.closeQuietly((Closeable)stream);
    }

    public static void setInstance(File resourceFile, Locale locale) {
        instance = new Translator(resourceFile, locale);
    }

    public static String translate(String key, Locale preferredLocale, Object ... msg) {
        return StringHelper.parseColors(msg.length == 0 ? instance.translate(key, preferredLocale) : instance.format(key, preferredLocale, msg));
    }

    public static String translate(String key, Object ... msg) {
        return Translator.translate(key, Translator.instance.defaultLocale, msg);
    }

    private static class SaveResourceThread
    implements Runnable {
        private final String fileName;
        private final File rootFolder;

        private SaveResourceThread(File rootFolder, String fileName) {
            this.rootFolder = rootFolder;
            this.fileName = fileName;
        }

        @Override
        public void run() {
            File file = new File(this.rootFolder, this.fileName);
            if (file.exists()) {
                return;
            }
            final InputStream stream = Translator.class.getResourceAsStream('/' + this.fileName);
            if (stream == null) {
                return;
            }
            InputSupplier<InputStream> in = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return stream;
                }
            };
            try {
                this.rootFolder.mkdirs();
                File to = File.createTempFile(this.fileName, null, this.rootFolder);
                to.deleteOnExit();
                Files.copy((InputSupplier)in, (File)to);
                if (!file.exists()) {
                    to.renameTo(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class FileClassLoader
    extends ClassLoader {
        private final File folder;

        public FileClassLoader(ClassLoader classLoader, File folder) {
            super(classLoader);
            this.folder = folder;
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                }
            } else {
                string = string.replaceFirst("/", "");
                URL test = Translator.class.getResource('/' + string);
                if (test != null) {
                    return test;
                }
            }
            return super.getResource(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                }
            } else {
                string = string.replaceFirst("/", "");
                InputStream stream = Translator.class.getResourceAsStream('/' + string);
                if (stream != null) {
                    new Thread(new SaveResourceThread(this.folder, string)).start();
                    return stream;
                }
            }
            return super.getResourceAsStream(string);
        }
    }
}

