/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.goals.WanderGoal;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.InstantBehavior;
import net.citizensnpcs.api.ai.tree.expr.ExpressionRegistry;
import net.citizensnpcs.api.ai.tree.expr.ExpressionScope;
import net.citizensnpcs.api.ai.tree.expr.Memory;
import net.citizensnpcs.api.ai.tree.expr.SignalManager;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BehaviorRegistry {
    private final Map<String, BehaviorFactory> behaviors = new HashMap<String, BehaviorFactory>();
    private final ExpressionRegistry expressions;
    private final SignalManager signals;

    public BehaviorRegistry() {
        this.expressions = new ExpressionRegistry();
        this.signals = new SignalManager();
        this.registerDefaults();
    }

    public BehaviorRegistry(ExpressionRegistry expressions) {
        this.expressions = expressions;
        this.signals = new SignalManager();
        this.registerDefaults();
    }

    public BehaviorRegistry(ExpressionRegistry expressionRegistry, SignalManager signals) {
        this.expressions = expressionRegistry;
        this.signals = signals;
        this.registerDefaults();
    }

    public Behavior createBehavior(String name, DataKey params, BehaviorContext context) {
        BehaviorFactory factory = this.behaviors.get(name.toLowerCase(Locale.ROOT));
        if (factory == null) {
            return null;
        }
        return factory.create(params, context);
    }

    public ExpressionRegistry getExpressionRegistry() {
        return this.expressions;
    }

    public SignalManager getSignalManager() {
        return this.signals;
    }

    public boolean hasBehavior(String name) {
        return this.behaviors.containsKey(name.toLowerCase(Locale.ROOT));
    }

    protected int parseDuration(String durationStr, ExpressionScope scope) {
        if (durationStr == null || durationStr.isEmpty()) {
            return 20;
        }
        int ticks = SpigotUtil.parseTicks(durationStr);
        if (ticks >= 0) {
            return ticks;
        }
        ExpressionRegistry.ExpressionValue holder = this.expressions.parseValue(durationStr);
        return (int)holder.evaluateAsNumber(scope);
    }

    public void registerBehavior(String name, BehaviorFactory factory) {
        this.behaviors.put(name.toLowerCase(), factory);
    }

    protected void registerDefaults() {
        this.registerBehavior("wait", (params, context) -> {
            final String durationStr = params != null ? params.getString("") : "20";
            final ExpressionRegistry.ExpressionValue durationHolder = this.expressions.parseValue(durationStr);
            return new Behavior(){
                private int ticksRemaining;

                @Override
                public void reset() {
                    this.ticksRemaining = SpigotUtil.parseTicks(durationHolder.evaluateAsString(context.getScope()));
                }

                @Override
                public BehaviorStatus run() {
                    if (--this.ticksRemaining <= 0) {
                        return BehaviorStatus.SUCCESS;
                    }
                    return BehaviorStatus.RUNNING;
                }

                @Override
                public boolean shouldExecute() {
                    this.ticksRemaining = BehaviorRegistry.this.parseDuration(durationStr, context.getScope());
                    return this.ticksRemaining > 0;
                }
            };
        });
        this.registerBehavior("emit_signal", (params, context) -> {
            String signalName = context.getArgOrParam(0, "", params, "");
            if (signalName.isEmpty() && params != null) {
                signalName = params.getString("");
            }
            final ExpressionRegistry.ExpressionValue value = this.expressions.parseValue(signalName);
            return new InstantBehavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    String signal = value.evaluateAsString(context.getScope());
                    BehaviorRegistry.this.signals.emit(context.getNPC(), signal);
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("emit_signal_to", (params, context) -> {
            String npcIdStr = context.getArgOrParam(0, "npc", params, null);
            String signalName = context.getArgOrParam(1, "signal", params, null);
            if (npcIdStr == null || signalName == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue npcIdHolder = this.expressions.parseValue(npcIdStr);
            final ExpressionRegistry.ExpressionValue signalHolder = this.expressions.parseValue(signalName);
            return new InstantBehavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    Object idValue = npcIdHolder.evaluate(context.getScope());
                    NPC npc = null;
                    if (idValue instanceof String) {
                        String idString = (String)idValue;
                        try {
                            UUID uuid = UUID.fromString(idString);
                            npc = CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(uuid);
                        }
                        catch (IllegalArgumentException e) {
                            try {
                                int npcId = Integer.parseInt(idString);
                                npc = CitizensAPI.getNPCRegistry().getById(npcId);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if (idValue instanceof Number) {
                        int npcId = ((Number)idValue).intValue();
                        npc = CitizensAPI.getNPCRegistry().getById(npcId);
                    }
                    if (npc == null) {
                        return BehaviorStatus.FAILURE;
                    }
                    BehaviorRegistry.this.signals.emitToNPC(npc.getUniqueId(), signalHolder.evaluateAsString(context.getScope()));
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("emit_global_signal", (params, context) -> {
            String signalName = context.getArgOrParam(0, "", params, "");
            if (signalName.isEmpty() && params != null) {
                signalName = params.getString("");
            }
            final ExpressionRegistry.ExpressionValue signalHolder = this.expressions.parseValue(signalName);
            return new InstantBehavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    String signal = signalHolder.evaluateAsString(context.getScope());
                    BehaviorRegistry.this.signals.emitGlobal(signal);
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("wait_for_signal", (params, context) -> {
            String signalName = context.getArgOrParam(0, "", params, "");
            if (signalName.isEmpty() && params != null) {
                signalName = params.getString("");
            }
            final ExpressionRegistry.ExpressionValue signalHolder = this.expressions.parseValue(signalName);
            return new Behavior(){
                private String currentSignal;
                private SignalManager.SignalListener listener;
                private boolean signalReceived = false;

                @Override
                public void reset() {
                    this.signalReceived = false;
                    if (this.listener != null && this.currentSignal != null) {
                        BehaviorRegistry.this.signals.unlisten(context.getNPC(), this.currentSignal, this.listener);
                        this.listener = null;
                        this.currentSignal = null;
                    }
                }

                @Override
                public BehaviorStatus run() {
                    if (this.signalReceived) {
                        BehaviorRegistry.this.signals.unlisten(context.getNPC(), this.currentSignal, this.listener);
                        this.listener = null;
                        return BehaviorStatus.SUCCESS;
                    }
                    return BehaviorStatus.RUNNING;
                }

                @Override
                public boolean shouldExecute() {
                    this.currentSignal = signalHolder.evaluateAsString(context.getScope());
                    this.listener = () -> {
                        this.signalReceived = true;
                    };
                    BehaviorRegistry.this.signals.listen(context.getNPC(), this.currentSignal, this.listener);
                    return true;
                }
            };
        });
        this.registerBehavior("succeed", (params, context) -> new Behavior(){

            @Override
            public void reset() {
            }

            @Override
            public BehaviorStatus run() {
                return BehaviorStatus.SUCCESS;
            }

            @Override
            public boolean shouldExecute() {
                return true;
            }
        });
        this.registerBehavior("repeat", (params, context) -> {
            String countStr = context.getArgOrParam(0, "count", params, "1");
            final ExpressionRegistry.ExpressionValue countHolder = this.getExpressionRegistry().parseValue(countStr);
            if (params == null || !params.getSubKeys().iterator().hasNext()) {
                return null;
            }
            return new Behavior(){
                private int remaining;
                private int total;

                @Override
                public void reset() {
                    this.remaining = this.total = (int)countHolder.evaluateAsNumber(context.getScope());
                }

                @Override
                public BehaviorStatus run() {
                    if (this.remaining <= 0) {
                        return BehaviorStatus.SUCCESS;
                    }
                    --this.remaining;
                    return BehaviorStatus.RUNNING;
                }

                @Override
                public boolean shouldExecute() {
                    this.remaining = this.total = (int)countHolder.evaluateAsNumber(context.getScope());
                    return this.total > 0;
                }
            };
        });
        this.registerBehavior("fail", (params, context) -> new Behavior(){

            @Override
            public void reset() {
            }

            @Override
            public BehaviorStatus run() {
                return BehaviorStatus.FAILURE;
            }

            @Override
            public boolean shouldExecute() {
                return true;
            }
        });
        this.registerBehavior("set", (params, context) -> {
            final String key = context.getArgOrParam(0, "key", params, null);
            String valueStr = context.getArgOrParam(1, "value", params, null);
            if (key == null || valueStr == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue valueHolder = this.expressions.parseValue(valueStr);
            return new InstantBehavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    Object value = valueHolder.evaluate(context.getScope());
                    context.getMemory().set(key, value);
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("wait_until", (params, context) -> {
            String conditionStr = context.getArgOrParam(0, "condition", params, null);
            if (conditionStr == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue conditionHolder = this.expressions.parseValue(conditionStr);
            return new Behavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    if (conditionHolder.evaluateAsBoolean(context.getScope())) {
                        return BehaviorStatus.SUCCESS;
                    }
                    return BehaviorStatus.RUNNING;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("cooldown", (params, context) -> {
            String key = context.getArgOrParam(0, "key", params, null);
            String durationStr = context.getArgOrParam(1, "duration", params, "1s");
            if (key == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue durationHolder = this.expressions.parseValue(durationStr);
            final String cooldownKey = "cooldown." + key;
            return new InstantBehavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    long lastUsed = (long)context.getMemory().getNumber(cooldownKey, 0.0);
                    Duration duration = SpigotUtil.parseDuration(durationHolder.evaluateAsString(context.getScope()), TimeUnit.MILLISECONDS);
                    if (System.currentTimeMillis() - lastUsed >= duration.toMillis()) {
                        context.getMemory().set(cooldownKey, System.currentTimeMillis());
                        return BehaviorStatus.SUCCESS;
                    }
                    return BehaviorStatus.FAILURE;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("forget", (params, context) -> {
            final String key = context.getArgOrParam(0, "key", params, null);
            if (key == null) {
                return null;
            }
            return new InstantBehavior(){

                @Override
                public void reset() {
                }

                @Override
                public BehaviorStatus run() {
                    context.getMemory().remove(key);
                    return BehaviorStatus.SUCCESS;
                }

                @Override
                public boolean shouldExecute() {
                    return true;
                }
            };
        });
        this.registerBehavior("clear_memory", (params, context) -> new InstantBehavior(){

            @Override
            public void reset() {
            }

            @Override
            public BehaviorStatus run() {
                context.getMemory().clear();
                return BehaviorStatus.SUCCESS;
            }

            @Override
            public boolean shouldExecute() {
                return true;
            }
        });
        this.registerBehavior("walkto", (params, context) -> {
            String xStr = null;
            String yStr = null;
            String zStr = null;
            String speedStr = null;
            String rangeStr = null;
            String distanceMarginStr = null;
            String[] args = context.getArgs();
            if (args != null && args.length >= 3) {
                xStr = args[0];
                yStr = args[1];
                zStr = args[2];
                block11: for (int i = 3; i < args.length; ++i) {
                    String arg = args[i];
                    if (!arg.contains("=")) continue;
                    String[] parts = arg.split("=", 2);
                    String key = parts[0].toLowerCase();
                    String value = parts[1];
                    switch (key) {
                        case "speed": {
                            speedStr = value;
                            continue block11;
                        }
                        case "range": {
                            rangeStr = value;
                            continue block11;
                        }
                        case "distance_margin": 
                        case "margin": {
                            distanceMarginStr = value;
                        }
                    }
                }
            } else if (params != null) {
                xStr = params.getString("x", null);
                yStr = params.getString("y", null);
                zStr = params.getString("z", null);
                speedStr = params.getString("speed", null);
                rangeStr = params.getString("range", null);
                distanceMarginStr = params.getString("distance_margin", null);
            }
            if (xStr == null || yStr == null || zStr == null) {
                return null;
            }
            final ExpressionRegistry.ExpressionValue xHolder = this.expressions.parseValue(xStr);
            final ExpressionRegistry.ExpressionValue yHolder = this.expressions.parseValue(yStr);
            final ExpressionRegistry.ExpressionValue zHolder = this.expressions.parseValue(zStr);
            final ExpressionRegistry.ExpressionValue speedHolder = speedStr != null ? this.expressions.parseValue(speedStr) : null;
            final ExpressionRegistry.ExpressionValue rangeHolder = rangeStr != null ? this.expressions.parseValue(rangeStr) : null;
            final ExpressionRegistry.ExpressionValue distanceMarginHolder = distanceMarginStr != null ? this.expressions.parseValue(distanceMarginStr) : null;
            return new Behavior(){
                private boolean started = false;

                @Override
                public void reset() {
                    this.started = false;
                }

                @Override
                public BehaviorStatus run() {
                    NPC npc = context.getNPC();
                    if (!npc.isSpawned()) {
                        return BehaviorStatus.FAILURE;
                    }
                    if (!this.started) {
                        double x = xHolder.evaluateAsNumber(context.getScope());
                        double y = yHolder.evaluateAsNumber(context.getScope());
                        double z = zHolder.evaluateAsNumber(context.getScope());
                        Location target = new Location(npc.getStoredLocation().getWorld(), x, y, z);
                        npc.getNavigator().setTarget(target);
                        if (speedHolder != null) {
                            npc.getNavigator().getLocalParameters().speedModifier((float)speedHolder.evaluateAsNumber(context.getScope()));
                        }
                        if (rangeHolder != null) {
                            npc.getNavigator().getLocalParameters().range((float)rangeHolder.evaluateAsNumber(context.getScope()));
                        }
                        if (distanceMarginHolder != null) {
                            npc.getNavigator().getLocalParameters().distanceMargin(distanceMarginHolder.evaluateAsNumber(context.getScope()));
                        }
                        this.started = true;
                    }
                    if (!npc.getNavigator().isNavigating()) {
                        return BehaviorStatus.SUCCESS;
                    }
                    return BehaviorStatus.RUNNING;
                }

                @Override
                public boolean shouldExecute() {
                    return context.getNPC().isSpawned() && !context.getNPC().getNavigator().isNavigating();
                }
            };
        });
        this.registerBehavior("wander", (params, context) -> {
            Map<String, String> parsedArgs = context.parseArgs(1, params);
            String radiusStr = context.getFromParsedArgs(parsedArgs, "0", "radius");
            String pathfindStr = context.getFromParsedArgs(parsedArgs, "1", "pathfind");
            if (radiusStr == null) {
                radiusStr = "10";
            }
            final ExpressionRegistry.ExpressionValue radiusHolder = this.expressions.parseValue(radiusStr);
            final ExpressionRegistry.ExpressionValue pathfindHolder = this.expressions.parseValue(pathfindStr);
            return new Behavior(){
                private WanderGoal wander = null;

                @Override
                public void reset() {
                    this.wander = null;
                }

                @Override
                public BehaviorStatus run() {
                    NPC npc = context.getNPC();
                    if (!npc.isSpawned()) {
                        return BehaviorStatus.FAILURE;
                    }
                    if (this.wander == null) {
                        int radius = (int)radiusHolder.evaluateAsNumber(context.getScope());
                        this.wander = WanderGoal.builder(npc).xrange(radius).yrange(radius).pathfind(pathfindHolder.evaluateAsBoolean(context.getScope())).build();
                    }
                    return this.wander.run();
                }

                @Override
                public boolean shouldExecute() {
                    return context.getNPC().isSpawned();
                }
            };
        });
        this.registerBehavior("break_block", (params, context) -> {
            Map<String, String> parsedArgs = context.parseArgs(3, params);
            String xStr = context.getFromParsedArgs(parsedArgs, "0", "x");
            String yStr = context.getFromParsedArgs(parsedArgs, "1", "y");
            String zStr = context.getFromParsedArgs(parsedArgs, "2", "z");
            String radiusStr = context.getFromParsedArgs(parsedArgs, "3", "radius");
            if (xStr == null || yStr == null || zStr == null) {
                return null;
            }
            if (radiusStr == null) {
                radiusStr = "3";
            }
            final ExpressionRegistry.ExpressionValue xHolder = this.expressions.parseValue(xStr);
            final ExpressionRegistry.ExpressionValue yHolder = this.expressions.parseValue(yStr);
            final ExpressionRegistry.ExpressionValue zHolder = this.expressions.parseValue(zStr);
            final ExpressionRegistry.ExpressionValue radiusHolder = this.expressions.parseValue(radiusStr);
            return new Behavior(){
                private BlockBreaker breaker = null;

                @Override
                public void reset() {
                    if (this.breaker != null) {
                        this.breaker.reset();
                        this.breaker = null;
                    }
                }

                @Override
                public BehaviorStatus run() {
                    NPC npc = context.getNPC();
                    if (!npc.isSpawned()) {
                        return BehaviorStatus.FAILURE;
                    }
                    if (this.breaker == null) {
                        int x = (int)xHolder.evaluateAsNumber(context.getScope());
                        int y = (int)yHolder.evaluateAsNumber(context.getScope());
                        int z = (int)zHolder.evaluateAsNumber(context.getScope());
                        double radius = radiusHolder.evaluateAsNumber(context.getScope());
                        Block target = npc.getEntity().getWorld().getBlockAt(x, y, z);
                        if (target.isEmpty()) {
                            return BehaviorStatus.SUCCESS;
                        }
                        BlockBreaker.BlockBreakerConfiguration cfg = new BlockBreaker.BlockBreakerConfiguration();
                        if (radius > 0.0) {
                            cfg.radius(radius);
                        }
                        this.breaker = npc.getBlockBreaker(target, cfg);
                    }
                    return this.breaker.run();
                }

                @Override
                public boolean shouldExecute() {
                    return context.getNPC().isSpawned();
                }
            };
        });
    }

    @FunctionalInterface
    public static interface BehaviorFactory {
        public Behavior create(DataKey var1, BehaviorContext var2);
    }

    public static class BehaviorContext {
        private String[] args;
        private final ExpressionRegistry expressionRegistry;
        private final Memory memory;
        private final NPC npc;
        private final ExpressionScope scope;

        public BehaviorContext(NPC npc, ExpressionScope scope, ExpressionRegistry expressionRegistry, Memory memory) {
            this.npc = npc;
            this.scope = scope;
            this.expressionRegistry = expressionRegistry;
            this.memory = memory;
        }

        public String getArgOrParam(int index, String name, DataKey params, String defaultValue) {
            if (this.args != null && index < this.args.length) {
                return this.args[index];
            }
            if (params != null) {
                return params.getString(name, defaultValue);
            }
            return defaultValue;
        }

        public String[] getArgs() {
            return this.args;
        }

        public ExpressionRegistry getExpressionRegistry() {
            return this.expressionRegistry;
        }

        public String getFromParsedArgs(Map<String, String> parsedArgs, String ... keys) {
            for (String key : keys) {
                String value = parsedArgs.get(key);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public Memory getMemory() {
            return this.memory;
        }

        public NPC getNPC() {
            return this.npc;
        }

        public ExpressionScope getScope() {
            return this.scope;
        }

        public Map<String, String> parseArgs(int positionalCount, DataKey params) {
            HashMap<String, String> result;
            block4: {
                block3: {
                    int i;
                    result = new HashMap<String, String>();
                    if (this.args == null || this.args.length < positionalCount) break block3;
                    for (i = 0; i < positionalCount && i < this.args.length; ++i) {
                        result.put(String.valueOf(i), this.args[i]);
                    }
                    for (i = positionalCount; i < this.args.length; ++i) {
                        String arg = this.args[i];
                        if (!arg.contains("=")) continue;
                        String[] parts = arg.split("=", 2);
                        result.put(parts[0].toLowerCase(), parts[1]);
                    }
                    break block4;
                }
                if (params == null) break block4;
                for (DataKey sub : params.getSubKeys()) {
                    result.put(sub.name(), params.getString(sub.name()));
                }
            }
            return result;
        }

        public void setArgs(String[] args) {
            this.args = args;
        }
    }
}

