/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.api.util.DataKey;

public class MemoryDataKey
extends DataKey {
    private final String name;
    private final Map<String, Object> root;

    public MemoryDataKey() {
        this(new HashMap<String, Object>(), "", "");
    }

    public MemoryDataKey(Map<String, Object> root) {
        this(root, "", "");
    }

    private MemoryDataKey(Map<String, Object> root, String path, String name) {
        super(path);
        this.root = root;
        this.name = name;
    }

    @Override
    public MemoryDataKey copy() {
        Map<String, Object> copied = this.deepCopyMap(this.getCurrentSection());
        return new MemoryDataKey(copied, "", "");
    }

    private Map<String, Object> deepCopyMap(Map<String, Object> source) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                result.put(entry.getKey(), this.deepCopyMap((Map)value));
                continue;
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataKey other = (MemoryDataKey)obj;
        return Objects.equals(this.path, other.path) && this.root == other.root;
    }

    @Override
    public boolean getBoolean(String key) {
        Object value = this.getRaw(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    private Map<String, Object> getCurrentSection() {
        String[] segments;
        if (this.path.isEmpty()) {
            return this.root;
        }
        Map current = this.root;
        for (String segment : segments = this.path.split("\\.")) {
            Object next = current.get(segment);
            if (!(next instanceof Map)) {
                return Collections.emptyMap();
            }
            current = (Map)next;
        }
        return current;
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double def) {
        String raw;
        Object value = this.getRaw(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value != null && !(raw = value.toString()).isEmpty()) {
            Double res = Doubles.tryParse((String)raw);
            return res != null ? res : def;
        }
        return def;
    }

    @Override
    public DataKey getFromRoot(String path) {
        return this.navigatePath(this.root, "", path);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int def) {
        String raw;
        Object value = this.getRaw(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null && !(raw = value.toString()).isEmpty()) {
            Integer res = Ints.tryParse((String)raw);
            return res != null ? res : def;
        }
        return def;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long def) {
        String raw;
        Object value = this.getRaw(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null && !(raw = value.toString()).isEmpty()) {
            Long res = Longs.tryParse((String)raw);
            return res != null ? res : def;
        }
        return def;
    }

    @Override
    public Object getRaw(String key) {
        if (key == null || key.isEmpty()) {
            return this.getValueAtCurrentPath();
        }
        return this.navigateToValue(key);
    }

    @Override
    public MemoryDataKey getRelative(String relative) {
        if (relative == null || relative.isEmpty()) {
            return this;
        }
        return this.navigatePath(this.root, this.path, relative);
    }

    public Map<String, Object> getRootMap() {
        return this.root;
    }

    @Override
    public String getString(String key) {
        Object val = this.getRaw(key);
        if (val != null && !(val instanceof Map)) {
            return val.toString();
        }
        return "";
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        Map<String, Object> current = this.getCurrentSection();
        if (current == null || current.isEmpty()) {
            return Collections.emptyList();
        }
        return Iterables.transform(current.keySet(), k -> {
            String newPath = this.path.isEmpty() ? k : this.path + "." + k;
            return new MemoryDataKey(this.root, newPath, (String)k);
        });
    }

    private Object getValueAtCurrentPath() {
        if (this.path.isEmpty()) {
            return this.root;
        }
        Map current = this.root;
        String[] segments = this.path.split("\\.");
        for (int i = 0; i < segments.length - 1; ++i) {
            Object next = current.get(segments[i]);
            if (!(next instanceof Map)) {
                return null;
            }
            current = (Map)next;
        }
        return current.get(segments[segments.length - 1]);
    }

    @Override
    public Map<String, Object> getValuesDeep() {
        Map<String, Object> section = this.getCurrentSection();
        if (section == null) {
            return Collections.emptyMap();
        }
        return this.deepCopyMap(section);
    }

    @Override
    public int hashCode() {
        return 31 * (this.path == null ? 0 : this.path.hashCode()) + System.identityHashCode(this.root);
    }

    @Override
    public boolean keyExists(String key) {
        if (key == null || key.isEmpty()) {
            return !this.getCurrentSection().isEmpty();
        }
        return this.navigateToValue(key) != null;
    }

    @Override
    public String name() {
        return this.name;
    }

    private MemoryDataKey navigatePath(Map<String, Object> root, String currentPath, String relativePath) {
        String newPath = currentPath.isEmpty() ? relativePath : (relativePath.startsWith(".") ? currentPath + relativePath : currentPath + "." + relativePath);
        int lastSegment = relativePath.lastIndexOf(46);
        return new MemoryDataKey(root, newPath, lastSegment == -1 ? relativePath : relativePath.substring(lastSegment + 1));
    }

    private Object navigateToValue(String relativePath) {
        Map current = this.getCurrentSection();
        if (current == null) {
            return null;
        }
        String[] segments = relativePath.split("\\.");
        for (int i = 0; i < segments.length - 1; ++i) {
            Object next = current.get(segments[i]);
            if (!(next instanceof Map)) {
                return null;
            }
            current = (Map)next;
        }
        return current.get(segments[segments.length - 1]);
    }

    @Override
    public void removeKey(String key) {
        this.setRaw(key, null);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.setRaw(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.setRaw(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.setRaw(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.setRaw(key, value);
    }

    @Override
    public void setMap(String key, Map<String, Object> value) {
        this.setRaw(key, value);
    }

    @Override
    public void setRaw(String key, Object value) {
        String fullPath = key == null || key.isEmpty() ? this.path : (this.path.isEmpty() ? key : this.path + "." + key);
        if (fullPath.isEmpty()) {
            if (value == null) {
                this.root.clear();
            } else if (value instanceof Map) {
                this.root.clear();
                this.root.putAll((Map)value);
            }
            throw new IllegalStateException("Setting root to a value not supported");
        }
        String[] segments = fullPath.split("\\.");
        Map current = this.root;
        for (int i = 0; i < segments.length - 1; ++i) {
            HashMap next = current.get(segments[i]);
            if (!(next instanceof Map)) {
                if (value == null) {
                    return;
                }
                next = new HashMap();
                current.put(segments[i], next);
            }
            current = next;
        }
        String lastSegment = segments[segments.length - 1];
        if (value == null) {
            current.remove(lastSegment);
        } else {
            current.put(lastSegment, value);
        }
    }

    @Override
    public void setString(String key, String value) {
        this.setRaw(key, value);
    }

    public String toString() {
        return "MemoryDataKey[" + this.path + "]";
    }
}

