/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree.expr;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.util.DataKey;

public class Memory {
    private final MetadataStore store;

    public Memory() {
        this.store = new SimpleMetadataStore();
    }

    public Memory(MetadataStore store) {
        this.store = store;
    }

    public void clear() {
        for (String key : this.getKeys()) {
            this.store.remove(key);
        }
    }

    public Object get(String key) {
        return this.store.get(key);
    }

    public Object get(String key, Object defaultValue) {
        return this.store.get(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        Object value = this.store.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public Iterable<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        return keys;
    }

    public List<Object> getList(String key) {
        Object value = this.store.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        this.store.set(key, newList);
        return newList;
    }

    public double getNumber(String key) {
        Object value = this.store.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    public double getNumber(String key, double defaultValue) {
        Object value = this.store.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultValue;
    }

    public MetadataStore getStore() {
        return this.store;
    }

    public String getString(String key) {
        Object value = this.store.get(key);
        return value != null ? value.toString() : null;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.store.get(key);
        return value != null ? value.toString() : defaultValue;
    }

    public boolean has(String key) {
        return this.store.has(key);
    }

    private boolean isPrimitive(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character;
    }

    private boolean isValidType(Object value) {
        if (this.isPrimitive(value)) {
            return true;
        }
        if (value instanceof List) {
            List list = (List)value;
            for (Object item : list) {
                if (item == null || this.isPrimitive(item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void listAdd(String key, Object item) {
        if (item != null && !this.isPrimitive(item)) {
            throw new IllegalArgumentException("List items must be primitive types");
        }
        this.getList(key).add(item);
    }

    public void listClear(String key) {
        this.getList(key).clear();
    }

    public boolean listContains(String key, Object item) {
        return this.getList(key).contains(item);
    }

    public Object listGet(String key, int index) {
        List<Object> list = this.getList(key);
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return null;
    }

    public boolean listRemove(String key, Object item) {
        List<Object> list = this.getList(key);
        return list.remove(item);
    }

    public Object listRemoveAt(String key, int index) {
        List<Object> list = this.getList(key);
        if (index >= 0 && index < list.size()) {
            return list.remove(index);
        }
        return null;
    }

    public void listSet(String key, int index, Object item) {
        if (item != null && !this.isPrimitive(item)) {
            throw new IllegalArgumentException("List items must be primitive types");
        }
        List<Object> list = this.getList(key);
        while (list.size() <= index) {
            list.add(null);
        }
        list.set(index, item);
    }

    public int listSize(String key) {
        return this.getList(key).size();
    }

    public void loadFrom(DataKey key) {
        this.store.loadFrom(key);
    }

    public void remove(String key) {
        this.store.remove(key);
    }

    public void saveTo(DataKey key) {
        this.store.saveTo(key);
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.store.remove(key);
            return;
        }
        if (!this.isValidType(value)) {
            throw new IllegalArgumentException("Memory can only store primitive types and Lists of primitives. Got: " + value.getClass().getName());
        }
        if (value instanceof List) {
            this.store.set(key, value);
        } else {
            this.store.setPersistent(key, value);
        }
    }

    public int size() {
        return this.store.size();
    }
}

