/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree.expr;

import com.google.common.primitives.Doubles;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.citizensnpcs.api.ai.tree.expr.CompiledExpression;
import net.citizensnpcs.api.ai.tree.expr.ExpressionEngine;
import net.citizensnpcs.api.ai.tree.expr.ExpressionScope;

public class ExpressionRegistry {
    private String defaultEngineName = "molang";
    private final Map<String, ExpressionEngine> engines = new HashMap<String, ExpressionEngine>();
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("^([a-zA-Z_]*)\\`(.+)\\`$");

    public String applyDefaultExpressionMarkup(String expression) {
        return '`' + expression + '`';
    }

    public CompiledExpression compile(String expr) throws ExpressionEngine.ExpressionCompileException {
        ExpressionEngine engine;
        if (this.defaultEngineName == null) {
            throw new ExpressionEngine.ExpressionCompileException("No expression engines registered");
        }
        Matcher matcher = EXPRESSION_PATTERN.matcher(expr);
        if (!matcher.matches()) {
            throw new ExpressionEngine.ExpressionCompileException("Invalid expression syntax: " + expr);
        }
        String prefix = matcher.group(1).toLowerCase(Locale.ROOT);
        String expression = matcher.group(2);
        String language = this.defaultEngineName;
        if (this.engines.containsKey(prefix)) {
            language = prefix;
        }
        if ((engine = this.engines.get(language)) == null) {
            throw new ExpressionEngine.ExpressionCompileException("Unknown expression engine: " + language);
        }
        return engine.compile(expression);
    }

    public String getDefaultEngineName() {
        return this.defaultEngineName;
    }

    public ExpressionEngine getEngine(String name) {
        return this.engines.get(name.toLowerCase(Locale.ROOT));
    }

    public boolean isPossiblyExpression(String value) {
        return value != null && EXPRESSION_PATTERN.matcher(value).matches();
    }

    public ExpressionValue parseValue(String expr) {
        if (this.isPossiblyExpression(expr)) {
            try {
                CompiledExpression compiled = this.compile(expr);
                return new ExpressionValue(compiled);
            }
            catch (ExpressionEngine.ExpressionCompileException e) {
                e.printStackTrace();
                return new ExpressionValue(expr);
            }
        }
        return new ExpressionValue(expr);
    }

    public void registerEngine(ExpressionEngine engine) {
        this.engines.put(engine.getName().toLowerCase(Locale.ROOT), engine);
    }

    public void setDefaultEngine(String language) {
        if (!this.engines.containsKey(language.toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("Unknown engine: " + language);
        }
        this.defaultEngineName = language.toLowerCase(Locale.ROOT);
    }

    public static class ExpressionValue {
        private final CompiledExpression expression;
        private final Object literal;

        ExpressionValue(CompiledExpression expression) {
            this.expression = expression;
            this.literal = null;
        }

        ExpressionValue(Object literal) {
            this.expression = null;
            this.literal = literal;
        }

        public Object evaluate(ExpressionScope scope) {
            if (this.expression != null) {
                return this.expression.evaluate(scope);
            }
            return this.literal;
        }

        public boolean evaluateAsBoolean(ExpressionScope scope) {
            if (this.expression != null) {
                return this.expression.evaluateAsBoolean(scope);
            }
            if (this.literal instanceof Boolean) {
                return (Boolean)this.literal;
            }
            if (this.literal instanceof Number) {
                return ((Number)this.literal).doubleValue() != 0.0;
            }
            if (this.literal instanceof String) {
                return Boolean.parseBoolean((String)this.literal) || !((String)this.literal).isEmpty();
            }
            return this.literal != null;
        }

        public double evaluateAsNumber(ExpressionScope scope) {
            if (this.expression != null) {
                return this.expression.evaluateAsNumber(scope);
            }
            if (this.literal instanceof Number) {
                return ((Number)this.literal).doubleValue();
            }
            if (this.literal instanceof String) {
                return Doubles.tryParse((String)this.literal.toString());
            }
            return 0.0;
        }

        public String evaluateAsString(ExpressionScope scope) {
            if (this.expression != null) {
                return this.expression.evaluateAsString(scope);
            }
            return this.literal == null ? "" : this.literal.toString();
        }

        public boolean isExpression() {
            return this.expression != null;
        }
    }
}

