/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree.expr;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.citizensnpcs.api.ai.tree.expr.CompiledExpression;
import net.citizensnpcs.api.ai.tree.expr.ExpressionEngine;
import net.citizensnpcs.api.ai.tree.expr.ExpressionScope;

public class JSR223Engine
implements ExpressionEngine {
    private final boolean compilable;
    private final ScriptEngine engine;
    private final String name;

    public JSR223Engine(String language) {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName(language);
        if (this.engine == null) {
            throw new IllegalArgumentException("Script engine not found: " + language);
        }
        this.name = language.toLowerCase();
        this.compilable = this.engine instanceof Compilable;
    }

    @Override
    public CompiledExpression compile(String expression) throws ExpressionEngine.ExpressionCompileException {
        if (this.compilable) {
            try {
                CompiledScript compiled = ((Compilable)((Object)this.engine)).compile(expression);
                return new JSR223CompiledExpression(compiled);
            }
            catch (ScriptException e) {
                throw new ExpressionEngine.ExpressionCompileException("Failed to compile script: " + expression, e);
            }
        }
        return new JSR223InterpretedExpression(this.engine, expression);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static Bindings createBindings(ExpressionScope scope) {
        SimpleBindings bindings = new SimpleBindings();
        for (String name : scope.getVariableNames()) {
            if (name.contains(".")) {
                String[] parts = name.split("\\.");
                Map<String, Object> current = bindings;
                for (int i = 0; i < parts.length - 1; ++i) {
                    Map next;
                    Object existing = current.get(parts[i]);
                    if (existing instanceof Map) {
                        next = (Map)existing;
                    } else {
                        next = new LazyMap();
                        current.put(parts[i], next);
                    }
                    current = next;
                }
                if (scope.isConstant(name)) {
                    Object value = scope.get(name);
                    if (value == null) continue;
                    current.put(parts[parts.length - 1], value);
                    continue;
                }
                Supplier<?> supplier = scope.getSupplier(name);
                if (supplier == null) continue;
                current.put(parts[parts.length - 1], new LazyValue(supplier));
                continue;
            }
            if (scope.isConstant(name)) {
                Object value = scope.get(name);
                if (value == null) continue;
                bindings.put(name, value);
                continue;
            }
            Supplier<?> supplier = scope.getSupplier(name);
            if (supplier == null) continue;
            bindings.put(name, (Object)new LazyValue(supplier));
        }
        return bindings;
    }

    public static JSR223Engine javascript() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        if (engine == null) {
            engine = manager.getEngineByName("graal.js");
        }
        if (engine == null) {
            engine = manager.getEngineByName("js");
        }
        if (engine == null) {
            throw new IllegalStateException("No JavaScript engine available");
        }
        return new JSR223Engine("js");
    }

    private static class JSR223CompiledExpression
    implements CompiledExpression {
        private final CompiledScript compiled;

        JSR223CompiledExpression(CompiledScript compiled) {
            this.compiled = compiled;
        }

        @Override
        public Object evaluate(ExpressionScope scope) {
            try {
                Bindings bindings = JSR223Engine.createBindings(scope);
                return this.compiled.eval(bindings);
            }
            catch (ScriptException e) {
                return null;
            }
        }
    }

    private static class JSR223InterpretedExpression
    implements CompiledExpression {
        private final ScriptEngine engine;
        private final String expression;

        JSR223InterpretedExpression(ScriptEngine engine, String expression) {
            this.engine = engine;
            this.expression = expression;
        }

        @Override
        public Object evaluate(ExpressionScope scope) {
            try {
                Bindings bindings = JSR223Engine.createBindings(scope);
                return this.engine.eval(this.expression, bindings);
            }
            catch (ScriptException e) {
                return null;
            }
        }
    }

    private static class LazyMap
    extends HashMap<String, Object> {
        private LazyMap() {
        }

        @Override
        public Object get(Object key) {
            Object value = super.get(key);
            if (value instanceof LazyValue) {
                return ((LazyValue)value).getValue();
            }
            return value;
        }
    }

    private static class LazyValue {
        private Object cachedValue;
        private boolean evaluated = false;
        private final Supplier<?> supplier;

        LazyValue(Supplier<?> supplier) {
            this.supplier = supplier;
        }

        public Object getValue() {
            if (!this.evaluated) {
                this.cachedValue = this.supplier.get();
                this.evaluated = true;
            }
            return this.cachedValue;
        }

        public String toString() {
            Object value = this.getValue();
            return value == null ? "" : value.toString();
        }
    }
}

