/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class RetryDecorator
implements Behavior {
    private final int limit;
    private int retries;
    private final Behavior wrapping;

    private RetryDecorator(Behavior wrapping, int limit) {
        this.limit = limit;
        this.wrapping = wrapping;
    }

    @Override
    public void reset() {
        this.retries = 0;
        this.wrapping.reset();
    }

    @Override
    public BehaviorStatus run() {
        BehaviorStatus status = this.wrapping.run();
        if (status == BehaviorStatus.FAILURE && (this.limit < 0 || ++this.retries < this.limit)) {
            this.reset();
            return BehaviorStatus.RUNNING;
        }
        return status;
    }

    @Override
    public boolean shouldExecute() {
        return this.wrapping.shouldExecute();
    }

    public static RetryDecorator retry(Behavior wrapping, int n) {
        return new RetryDecorator(wrapping, n);
    }

    public static RetryDecorator unlimited(Behavior wrapping) {
        return RetryDecorator.retry(wrapping, -1);
    }
}

