/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.utilities.debugging;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;

public class LogInterceptor
extends PrintStream {
    boolean redirected = false;
    public PrintStream standardOut;
    private boolean antiLoop = false;

    public LogInterceptor() {
        super(System.out, true);
    }

    @Override
    public void print(String s) {
        if (this.antiLoop) {
            super.print(s);
            return;
        }
        this.antiLoop = true;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(DenizenCore.getImplementation().cleanseLogString(s)));
        List<String> Determinations = OldEventManager.doEvents(Arrays.asList("console output"), DenizenCore.getImplementation().getEmptyScriptEntryData(), context);
        for (String str : Determinations) {
            if (!str.equalsIgnoreCase("cancelled")) continue;
            this.antiLoop = false;
            return;
        }
        super.print(s);
        this.antiLoop = false;
    }

    public void redirectOutput() {
        if (this.redirected) {
            return;
        }
        this.standardOut = System.out;
        System.setOut(this);
    }

    public void standardOutput() {
        if (!this.redirected) {
            return;
        }
        System.setOut(this.standardOut);
    }
}

