/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.CatHelper;
import com.denizenscript.denizen.utilities.entity.FoxHelper;
import com.denizenscript.denizen.utilities.entity.PandaHelper;
import com.denizenscript.denizen.utilities.entity.TropicalFishHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.DyeColor;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public class EntityColor
implements Property {
    public static final String[] handledTags = new String[]{"color"};
    public static final String[] handledMechs = new String[]{"color"};
    EntityTag colored;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        EntityType type = ((EntityTag)entity).getBukkitEntityType();
        return type == EntityType.SHEEP || type == EntityType.HORSE || type == EntityType.WOLF || type == EntityType.OCELOT || type == EntityType.RABBIT || type == EntityType.LLAMA || type == EntityType.PARROT || type == EntityType.SHULKER || type == EntityType.MUSHROOM_COW || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.CAT || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.FOX || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.PANDA || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.ARROW || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.VILLAGER || type == EntityType.TROPICAL_FISH;
    }

    public static EntityColor getFrom(ObjectTag entity) {
        if (!EntityColor.describes(entity)) {
            return null;
        }
        return new EntityColor((EntityTag)entity);
    }

    private EntityColor(EntityTag entity) {
        this.colored = entity;
    }

    private String getColor() {
        EntityType type = this.colored.getBukkitEntityType();
        if (type == EntityType.HORSE) {
            Horse horse = (Horse)this.colored.getBukkitEntity();
            return horse.getColor().name() + "|" + horse.getStyle().name();
        }
        if (type == EntityType.SHEEP) {
            return ((Sheep)this.colored.getBukkitEntity()).getColor().name();
        }
        if (type == EntityType.WOLF) {
            return ((Wolf)this.colored.getBukkitEntity()).getCollarColor().name();
        }
        if (type == EntityType.OCELOT) {
            return ((Ocelot)this.colored.getBukkitEntity()).getCatType().name();
        }
        if (type == EntityType.RABBIT) {
            return ((Rabbit)this.colored.getBukkitEntity()).getRabbitType().name();
        }
        if (type == EntityType.LLAMA) {
            return ((Llama)this.colored.getBukkitEntity()).getColor().name();
        }
        if (type == EntityType.PARROT) {
            return ((Parrot)this.colored.getBukkitEntity()).getVariant().name();
        }
        if (type == EntityType.SHULKER) {
            DyeColor color = ((Shulker)this.colored.getBukkitEntity()).getColor();
            return color == null ? null : color.name();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.MUSHROOM_COW) {
            return ((MushroomCow)this.colored.getBukkitEntity()).getVariant().name();
        }
        if (type == EntityType.TROPICAL_FISH) {
            return TropicalFishHelper.getColor(this.colored);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.FOX) {
            return FoxHelper.getColor(this.colored);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.CAT) {
            return CatHelper.getColor(this.colored);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.PANDA) {
            return PandaHelper.getColor(this.colored);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.VILLAGER) {
            return ((Villager)this.colored.getBukkitEntity()).getVillagerType().name();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.ARROW) {
            try {
                return new ColorTag(((Arrow)this.colored.getBukkitEntity()).getColor()).identify();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        String color = this.getColor();
        return color == null ? null : CoreUtilities.toLowerCase(color);
    }

    @Override
    public String getPropertyId() {
        return "color";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("color")) {
            return new ElementTag(CoreUtilities.toLowerCase(this.getColor())).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("color")) {
            EntityType type = this.colored.getBukkitEntityType();
            if (type == EntityType.HORSE) {
                ListTag horse_info = mechanism.valueAsType(ListTag.class);
                if (horse_info.size() > 0 && new ElementTag(horse_info.get(0)).matchesEnum((Enum[])Horse.Color.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setColor(Horse.Color.valueOf((String)horse_info.get(0).toUpperCase()));
                }
                if (horse_info.size() > 1 && new ElementTag(horse_info.get(1)).matchesEnum((Enum[])Horse.Style.values())) {
                    ((Horse)this.colored.getBukkitEntity()).setStyle(Horse.Style.valueOf((String)horse_info.get(1).toUpperCase()));
                }
            } else if (type == EntityType.SHEEP && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Sheep)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.WOLF && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Wolf)this.colored.getBukkitEntity()).setCollarColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.OCELOT && mechanism.getValue().matchesEnum((Enum[])Ocelot.Type.values())) {
                ((Ocelot)this.colored.getBukkitEntity()).setCatType(Ocelot.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.RABBIT && mechanism.getValue().matchesEnum((Enum[])Rabbit.Type.values())) {
                ((Rabbit)this.colored.getBukkitEntity()).setRabbitType(Rabbit.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.LLAMA) {
                ((Llama)this.colored.getBukkitEntity()).setColor(Llama.Color.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.PARROT) {
                ((Parrot)this.colored.getBukkitEntity()).setVariant(Parrot.Variant.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.SHULKER && mechanism.getValue().matchesEnum((Enum[])DyeColor.values())) {
                ((Shulker)this.colored.getBukkitEntity()).setColor(DyeColor.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.MUSHROOM_COW) {
                ((MushroomCow)this.colored.getBukkitEntity()).setVariant(MushroomCow.Variant.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (type == EntityType.TROPICAL_FISH) {
                TropicalFishHelper.setColor(this.colored, mechanism.getValue().asString());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.FOX) {
                FoxHelper.setColor(this.colored, mechanism.getValue().asString());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.CAT) {
                CatHelper.setColor(this.colored, mechanism.getValue().asString());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.PANDA) {
                PandaHelper.setColor(this.colored, mechanism.getValue().asString());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.VILLAGER) {
                ((Villager)this.colored.getBukkitEntity()).setVillagerType(Villager.Type.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14) && type == EntityType.ARROW) {
                ((Arrow)this.colored.getBukkitEntity()).setColor(mechanism.valueAsType(ColorTag.class).getColor());
            } else {
                Debug.echoError("Could not apply color '" + mechanism.getValue().toString() + "' to entity of type " + type.name() + ".");
            }
        }
    }
}

