/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.block.data.type.TurtleEgg;

public class MaterialCount
implements Property {
    public static final String[] handledMechs = new String[]{"count", "pickle_count"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && (((MaterialTag)material).getModernData().data instanceof SeaPickle || ((MaterialTag)material).getModernData().data instanceof TurtleEgg);
    }

    public static MaterialCount getFrom(ObjectTag _material) {
        if (!MaterialCount.describes(_material)) {
            return null;
        }
        return new MaterialCount((MaterialTag)_material);
    }

    private MaterialCount(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("count", (attribute, material) -> new ElementTag(material.getCurrent()), "pickle_count");
        PropertyParser.registerTag("count_max", (attribute, material) -> new ElementTag(material.getMax()), "pickle_max");
        PropertyParser.registerTag("count_min", (attribute, material) -> new ElementTag(material.getMin()), "pickle_min");
    }

    public SeaPickle getSeaPickle() {
        return (SeaPickle)this.material.getModernData().data;
    }

    public TurtleEgg getTurtleEgg() {
        return (TurtleEgg)this.material.getModernData().data;
    }

    public boolean isSeaPickle() {
        return this.material.getModernData().data instanceof SeaPickle;
    }

    public int getCurrent() {
        if (this.isSeaPickle()) {
            return this.getSeaPickle().getPickles();
        }
        return this.getTurtleEgg().getEggs();
    }

    public int getMax() {
        if (this.isSeaPickle()) {
            return this.getSeaPickle().getMaximumPickles();
        }
        return this.getTurtleEgg().getMaximumEggs();
    }

    public int getMin() {
        if (this.isSeaPickle()) {
            return this.getSeaPickle().getMinimumPickles();
        }
        return this.getTurtleEgg().getMinimumEggs();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "count";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("count") || mechanism.matches("pickle_count")) && mechanism.requireInteger()) {
            int count = mechanism.getValue().asInt();
            if (count < this.getMin() || count > this.getMax()) {
                Debug.echoError("Material count mechanism value '" + count + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + ".");
                return;
            }
            if (this.isSeaPickle()) {
                this.getSeaPickle().setPickles(count);
            } else {
                this.getTurtleEgg().setEggs(count);
            }
        }
    }
}

