/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_13.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.v1_13_R2.FurnaceRecipe;
import net.minecraft.server.v1_13_R2.GameProfileSerializer;
import net.minecraft.server.v1_13_R2.IRecipe;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.Item;
import net.minecraft.server.v1_13_R2.ItemStack;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NonNullList;
import net.minecraft.server.v1_13_R2.RecipeItemStack;
import net.minecraft.server.v1_13_R2.ShapelessRecipes;
import net.minecraft.server.v1_13_R2.TileEntityFurnace;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_13_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_13_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemHelperImpl
extends ItemHelper {
    public static IRecipe getNMSRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        Object2ObjectLinkedOpenHashMap recipeMap = ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes;
        return (IRecipe)recipeMap.get((Object)nmsKey);
    }

    @Override
    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, "maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(Item.class, "maxStackSize").invoke((Item)IRegistry.ITEM.get(MinecraftKey.a((String)material.getKey().getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public Integer burnTime(Material material) {
        return (Integer)TileEntityFurnace.p().get(CraftMagicNumbers.getItem((Material)material));
    }

    @Override
    public Recipe getRecipeById(NamespacedKey key) {
        IRecipe recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            return null;
        }
        return recipe.toBukkitRecipe();
    }

    @Override
    public void removeRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        Object2ObjectLinkedOpenHashMap recipeMap = ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes;
        recipeMap.remove((Object)nmsKey);
    }

    @Override
    public void clearDenizenRecipes() {
        Object2ObjectLinkedOpenHashMap recipeMap = ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes;
        for (MinecraftKey key : new ArrayList(recipeMap.keySet())) {
            if (!key.b().equalsIgnoreCase("denizen")) continue;
            recipeMap.remove((Object)key);
        }
    }

    @Override
    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c, org.bukkit.inventory.ItemStack[] item, boolean exact) {
        if (exact) {
            recipe.setIngredient(c, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static RecipeItemStack itemArrayToRecipe(org.bukkit.inventory.ItemStack[] items, boolean exact) {
        RecipeItemStack.StackProvider[] stacks = new RecipeItemStack.StackProvider[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)items[i]));
        }
        RecipeItemStack itemRecipe = new RecipeItemStack(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    @Override
    public void registerFurnaceRecipe(String keyName, String group, org.bukkit.inventory.ItemStack result, org.bukkit.inventory.ItemStack[] ingredient, float exp, int time, String type, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        FurnaceRecipe recipe = new FurnaceRecipe(key, group, itemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), exp, time);
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().a((IRecipe)recipe);
    }

    @Override
    public void registerShapelessRecipe(String keyName, String group, org.bukkit.inventory.ItemStack result, List<org.bukkit.inventory.ItemStack[]> ingredients, boolean[] exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        ArrayList<RecipeItemStack> ingredientList = new ArrayList<RecipeItemStack>();
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(key, group, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), NonNullList.a(null, (Object[])ingredientList.toArray(new RecipeItemStack[0])));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().a((IRecipe)recipe);
    }

    @Override
    public String getInternalNameFromMaterial(Material material) {
        return "minecraft:" + CoreUtilities.toLowerCase(material.name());
    }

    @Override
    public Material getMaterialFromInternalName(String internalName) {
        return Material.matchMaterial((String)internalName);
    }

    @Override
    public String getJsonString(org.bukkit.inventory.ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack).A().getChatModifier().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    @Override
    public String getRawHoverText(org.bukkit.inventory.ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return "";
        }
        return CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack).A().getChatModifier().i().b().getText();
    }

    @Override
    public PlayerProfile getSkullSkin(org.bukkit.inventory.ItemStack is) {
        GameProfile profile;
        NBTTagCompound tag;
        ItemStack itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is);
        if (itemStack.hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10) && (profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    @Override
    public org.bukkit.inventory.ItemStack setSkullSkin(org.bukkit.inventory.ItemStack itemStack, PlayerProfile playerProfile) {
        ItemStack nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        NBTTagCompound tag = (nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack)).hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameProfile));
        nmsItemStack.setTag(tag);
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack);
    }

    @Override
    public org.bukkit.inventory.ItemStack addNbtData(org.bukkit.inventory.ItemStack itemStack, String key, Tag value) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.setTag(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.inventory.ItemStack itemStack) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.hasTag()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.getTag());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    @Override
    public org.bukkit.inventory.ItemStack setNbtData(org.bukkit.inventory.ItemStack itemStack, CompoundTag compoundTag) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        nmsItemStack.setTag(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack);
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles, Color color, boolean icon) {
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }
}

