/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SheepDyeWoolEvent;

public class SheepDyedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static SheepDyedScriptEvent instance;
    public EntityTag entity;
    public DyeColor color;
    public SheepDyeWoolEvent event;

    public SheepDyedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("sheep dyed") || path.eventLower.startsWith("player dyes sheep");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String new_color;
        String cmd = path.eventArgLowerAt(1);
        String string = new_color = cmd.equals("dyes") ? path.eventArgLowerAt(3) : path.eventArgLowerAt(2);
        if (!new_color.isEmpty() && !new_color.equals(CoreUtilities.toLowerCase(this.color.toString()))) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "SheepDyed";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (!SheepDyedScriptEvent.isDefaultDetermination(determinationObj)) {
            try {
                this.color = DyeColor.valueOf((String)determinationObj.toString().toUpperCase());
                this.event.setColor(this.color);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("color")) {
            return new ElementTag(this.color.toString());
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSheepDyed(SheepDyeWoolEvent event) {
        this.entity = new EntityTag((Entity)event.getEntity());
        this.color = DyeColor.valueOf((String)event.getColor().toString());
        this.event = event;
        this.fire((Event)event);
    }
}

