/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class PlayerPicksUpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPicksUpScriptEvent instance;
    public ItemTag item;
    public LocationTag location;
    public PlayerPickupItemEvent event;
    private static final Set<UUID> editedItems;

    public PlayerPicksUpScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        boolean isUp = path.eventLower.startsWith("player picks up");
        if (!isUp && !path.eventLower.startsWith("player takes")) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("from")) {
            return false;
        }
        return this.couldMatchItem(path.eventArgLowerAt(isUp ? 3 : 2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String iTest;
        String string = iTest = path.eventArgLowerAt(1).equals("picks") ? path.eventArgLowerAt(3) : path.eventArgLowerAt(2);
        if (!this.tryItem(this.item, iTest)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerPicksUp";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("item:")) {
            this.item = ItemTag.valueOf(determination.substring("item:".length()), path.container);
            editedItems.add(this.event.getItem().getUniqueId());
            this.event.getItem().setItemStack(this.item.getItemStack());
            this.event.setCancelled(true);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("entity")) {
            return new EntityTag((Entity)this.event.getItem());
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerPicksUp(PlayerPickupItemEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Item itemEntity = event.getItem();
        UUID itemUUID = itemEntity.getUniqueId();
        if (editedItems.contains(itemUUID)) {
            editedItems.remove(itemUUID);
            return;
        }
        this.location = new LocationTag(itemEntity.getLocation());
        this.item = new ItemTag(itemEntity.getItemStack());
        this.event = event;
        this.fire((Event)event);
    }

    static {
        editedItems = new HashSet<UUID>();
    }
}

