/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;

public class ItemKnowledgeBookRecipes
implements Property {
    public static final String[] handledTags = new String[]{"knowledge_book_recipes"};
    public static final String[] handledMechs = new String[]{"knowledge_book_recipes"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemStack().getType() == Material.KNOWLEDGE_BOOK;
    }

    public static ItemKnowledgeBookRecipes getFrom(ObjectTag _item) {
        if (!ItemKnowledgeBookRecipes.describes(_item)) {
            return null;
        }
        return new ItemKnowledgeBookRecipes((ItemTag)_item);
    }

    private ItemKnowledgeBookRecipes(ItemTag _item) {
        this.item = _item;
    }

    public ListTag recipeList() {
        ListTag output = new ListTag();
        ItemStack itemStack = this.item.getItemStack();
        if (itemStack.hasItemMeta() && itemStack.getItemMeta() instanceof KnowledgeBookMeta) {
            for (NamespacedKey key : ((KnowledgeBookMeta)itemStack.getItemMeta()).getRecipes()) {
                output.add(key.toString());
            }
        }
        return output;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("knowledge_book_recipes")) {
            return this.recipeList().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ListTag recipes = this.recipeList();
        if (recipes.size() > 0) {
            return recipes.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "knowledge_book_recipes";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("knowledge_book_recipes")) {
            KnowledgeBookMeta meta = (KnowledgeBookMeta)this.item.getItemMeta();
            ArrayList<NamespacedKey> recipes = new ArrayList<NamespacedKey>();
            ListTag newRecipes = mechanism.valueAsType(ListTag.class);
            for (String str : newRecipes) {
                recipes.add(Utilities.parseNamespacedKey(str));
            }
            meta.setRecipes(recipes);
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

