/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExpBottleEvent;

public class ExperienceBottleBreaksScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ExperienceBottleBreaksScriptEvent instance;
    public ExpBottleEvent event;

    public ExperienceBottleBreaksScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventLower.startsWith("experience bottle breaks")) {
            return false;
        }
        return this.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "ExperienceBottleBreaks";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String lower = determinationObj.toString().toLowerCase();
        if (lower.startsWith("experience:")) {
            int experience = Argument.valueOf(lower.substring(11)).asElement().asInt();
            this.event.setExperience(experience);
        } else if (lower.startsWith("effect:")) {
            boolean effect = Argument.valueOf(lower.substring(7)).asElement().asBoolean();
            this.event.setShowEffect(effect);
        } else {
            return super.applyDetermination(path, determinationObj);
        }
        return true;
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return new EntityTag((Entity)this.event.getEntity());
        }
        if (name.equals("experience")) {
            return new ElementTag(this.event.getExperience());
        }
        if (name.equals("show_effect")) {
            return new ElementTag(this.event.getShowEffect());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onExperienceBottleBreaks(ExpBottleEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

