/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.properties;

import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyParser {
    public static Map<Class<? extends ObjectTag>, ClassPropertiesInfo> propertiesByClass = new HashMap<Class<? extends ObjectTag>, ClassPropertiesInfo>();
    public static Class currentlyRegisteringPropertyClass;
    public static PropertyGetter currentlyRegisteringProperty;
    public static ObjectFetcher.ObjectType currentlyRegisteringObjectType;
    public static AsciiMatcher needsEscapingMatcher;
    public static List<Property> empty;

    public static <P extends Property> void registerTag(String name, PropertyTag<P> runnable, String ... variants) {
        PropertyGetter getter = currentlyRegisteringProperty;
        Class propertyClass = currentlyRegisteringPropertyClass;
        ObjectTagProcessor<ObjectTag> tagProcessor = PropertyParser.currentlyRegisteringObjectType.tagProcessor;
        tagProcessor.registerTag(name, (attribute, object) -> {
            Property prop = getter.get(object);
            if (prop == null) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("Property '" + propertyClass.getSimpleName() + "' does not describe the input object.");
                }
                return null;
            }
            return runnable.run(attribute, prop);
        }, variants);
    }

    public static void registerPropertyGetter(PropertyGetter getter, Class<? extends ObjectTag> object, String[] tags, String[] mechs, Class property) {
        currentlyRegisteringPropertyClass = property;
        currentlyRegisteringProperty = getter;
        currentlyRegisteringObjectType = ObjectFetcher.objectsByClass.get(object);
        boolean didRegisterTags = false;
        try {
            for (Method registerMethod : property.getDeclaredMethods()) {
                if (!registerMethod.getName().equals("registerTags") || registerMethod.getParameterCount() != 0) continue;
                registerMethod.invoke(null, new Object[0]);
                didRegisterTags = true;
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        currentlyRegisteringProperty = null;
        currentlyRegisteringObjectType = null;
        currentlyRegisteringPropertyClass = null;
        ClassPropertiesInfo propInfo = propertiesByClass.get(object);
        if (propInfo == null) {
            propInfo = new ClassPropertiesInfo();
            propertiesByClass.put(object, propInfo);
        }
        propInfo.allProperties.add(getter);
        if (tags != null) {
            String propName = property.getSimpleName();
            for (String tag : tags) {
                propInfo.propertiesByTag.put(tag, getter);
                propInfo.propertyNamesByTag.put(tag, propName);
            }
        } else if (!didRegisterTags) {
            propInfo.propertiesAnyTags.add(getter);
        }
        if (mechs != null) {
            for (String mech : mechs) {
                propInfo.propertiesByMechanism.put(mech, getter);
            }
            propInfo.propertiesWithMechs.add(getter);
        } else {
            propInfo.propertiesAnyMechs.add(getter);
            propInfo.propertiesWithMechs.add(getter);
        }
    }

    public static String[] getStringField(Class property, String fieldName) {
        try {
            Field f = property.getDeclaredField(fieldName);
            return (String[])f.get(null);
        }
        catch (IllegalAccessException e) {
            Debug.echoError("Invalid property field '" + fieldName + "' for property class '" + property.getSimpleName() + "': field is not a String[]: " + e.getMessage() + "!");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static void registerProperty(Class property, Class<? extends ObjectTag> object, PropertyGetter getter) {
        PropertyParser.registerPropertyGetter(getter, object, PropertyParser.getStringField(property, "handledTags"), PropertyParser.getStringField(property, "handledMechs"), property);
    }

    public static void registerProperty(Class property, Class<? extends ObjectTag> object) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            CallSite site = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(PropertyGetter.class), MethodType.methodType(Property.class, ObjectTag.class), lookup.findStatic(property, "getFrom", MethodType.methodType(property, ObjectTag.class)), MethodType.methodType(property, ObjectTag.class));
            PropertyGetter getter = site.getTarget().invoke();
            PropertyParser.registerProperty(property, object, getter);
        }
        catch (Throwable e) {
            Debug.echoError("Unable to register property '" + property.getSimpleName() + "'!");
            Debug.echoError(e);
        }
    }

    public static String escapePropertyValue(String input) {
        if (needsEscapingMatcher.containsAnyMatch(input)) {
            input = CoreUtilities.replace(input, "&", "&amp");
            input = CoreUtilities.replace(input, ";", "&sc");
            input = CoreUtilities.replace(input, "[", "&lb");
            input = CoreUtilities.replace(input, "]", "&rb");
        }
        return input;
    }

    public static String getPropertiesString(ObjectTag object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return "";
        }
        StringBuilder prop_string = new StringBuilder(properties.propertiesWithMechs.size() * 10);
        for (PropertyGetter getter : properties.propertiesWithMechs) {
            String description;
            Property property = getter.get(object);
            if (property == null || (description = property.getPropertyString()) == null) continue;
            description = PropertyParser.escapePropertyValue(description);
            prop_string.append(property.getPropertyId()).append('=').append(description).append(';');
        }
        if (prop_string.length() > 0) {
            return "[" + prop_string.substring(0, prop_string.length() - 1) + "]";
        }
        return "";
    }

    public static List<Property> getProperties(ObjectTag object, String attribLow) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return empty;
        }
        PropertyGetter getter = properties.propertiesByTag.get(attribLow);
        if (getter != null) {
            Property prop = getter.get(object);
            if (prop == null) {
                return empty;
            }
            return Collections.singletonList(getter.get(object));
        }
        return PropertyParser.getProperties(object);
    }

    public static List<Property> getProperties(ObjectTag object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return empty;
        }
        ArrayList<Property> props = new ArrayList<Property>(properties.allProperties.size());
        for (PropertyGetter getter : properties.allProperties) {
            Property prop = getter.get(object);
            if (prop == null) continue;
            props.add(prop);
        }
        return props;
    }

    static {
        needsEscapingMatcher = new AsciiMatcher("&;[]");
        empty = new ArrayList<Property>();
    }

    @FunctionalInterface
    public static interface PropertyTag<T extends Property> {
        public ObjectTag run(Attribute var1, T var2);
    }

    public static class ClassPropertiesInfo {
        public List<PropertyGetter> allProperties = new ArrayList<PropertyGetter>();
        public List<PropertyGetter> propertiesAnyTags = new ArrayList<PropertyGetter>();
        public List<PropertyGetter> propertiesAnyMechs = new ArrayList<PropertyGetter>();
        public List<PropertyGetter> propertiesWithMechs = new ArrayList<PropertyGetter>();
        public Map<String, PropertyGetter> propertiesByTag = new HashMap<String, PropertyGetter>();
        public Map<String, PropertyGetter> propertiesByMechanism = new HashMap<String, PropertyGetter>();
        public Map<String, String> propertyNamesByTag = new HashMap<String, String>();
    }

    @FunctionalInterface
    public static interface PropertyGetter {
        public Property get(ObjectTag var1);
    }
}

