/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.inventory.InventoryContents;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.AbstractMap;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemInventory
implements Property {
    public static final String[] handledTags = new String[]{"inventory", "inventory_contents"};
    public static final String[] handledMechs = new String[]{"inventory", "inventory_contents"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemMeta() instanceof BlockStateMeta && ((BlockStateMeta)((ItemTag)item).getItemMeta()).getBlockState() instanceof InventoryHolder;
    }

    public static ItemInventory getFrom(ObjectTag _item) {
        if (!ItemInventory.describes(_item)) {
            return null;
        }
        return new ItemInventory((ItemTag)_item);
    }

    private InventoryTag getItemInventory() {
        return InventoryTag.mirrorBukkitInventory(((InventoryHolder)((BlockStateMeta)this.item.getItemMeta()).getBlockState()).getInventory());
    }

    private ItemInventory(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("inventory_contents")) {
            return this.getInventoryContents().getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            Deprecations.itemInventoryTag.warn(attribute.context);
            return this.getItemInventory().getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public ListTag getInventoryContents() {
        InventoryTag inventory = this.getItemInventory();
        if (inventory == null) {
            return null;
        }
        return InventoryContents.getFrom(inventory).getContents(false);
    }

    @Override
    public String getPropertyString() {
        ListTag inv = this.getInventoryContents();
        return inv != null ? inv.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "inventory_contents";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("inventory_contents") || mechanism.matches("inventory")) && mechanism.hasValue()) {
            AbstractMap.SimpleEntry<Integer, InventoryTag> inventoryPair;
            if (mechanism.matches("inventory")) {
                Deprecations.itemInventoryTag.warn(mechanism.context);
            }
            if ((inventoryPair = Conversion.getInventory(mechanism.getValue().asString(), mechanism.context)) == null || ((InventoryTag)inventoryPair.getValue()).getInventory() == null) {
                return;
            }
            BlockStateMeta bsm = (BlockStateMeta)this.item.getItemMeta();
            InventoryHolder invHolder = (InventoryHolder)bsm.getBlockState();
            ListTag items = InventoryContents.getFrom((ObjectTag)inventoryPair.getValue()).getContents(false);
            if (items.size() > invHolder.getInventory().getSize()) {
                Debug.echoError("Invalid inventory_contents input size; expected " + invHolder.getInventory().getSize() + " or less.");
                return;
            }
            ItemStack[] itemArray = new ItemStack[items.size()];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = ((ItemTag)items.objectForms.get(i)).getItemStack().clone();
            }
            invHolder.getInventory().setContents(itemArray);
            bsm.setBlockState((BlockState)invHolder);
            this.item.setItemMeta((ItemMeta)bsm);
        }
    }
}

