/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.maps.MapObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class MapText
extends MapObject {
    protected String textTag;
    protected Map<UUID, String> playerTexts = new HashMap<UUID, String>();

    public MapText(String xTag, String yTag, String visibilityTag, boolean debug, String textTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.textTag = textTag;
    }

    @Override
    public void update(PlayerTag player, UUID uuid) {
        super.update(player, uuid);
        this.playerTexts.put(uuid, this.tag(this.textTag, player));
    }

    public String getText(PlayerTag player) {
        return this.playerTexts.get(player.getPlayerEntity().getUniqueId());
    }

    public void setText(String textTag) {
        this.textTag = textTag;
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "TEXT");
        data.put("text", this.textTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        if (!this.playerTexts.containsKey(uuid)) {
            this.playerTexts.put(uuid, this.tag(this.textTag, player));
        }
        mapCanvas.drawText(this.getX(player, uuid), this.getY(player, uuid), (MapFont)MinecraftFont.Font, this.getText(player));
    }
}

