/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class WebGetCommand
extends AbstractCommand
implements Holdable {
    public WebGetCommand() {
        this.setName("webget");
        this.setSyntax("webget [<url>] (post:<data>) (headers:<header>/<value>|...) (timeout:<duration>/{10s}) (savefile:<path>) (hide_failure)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("url")) {
                scriptEntry.addObject("url", new ElementTag(arg.raw_value));
                continue;
            }
            if (!scriptEntry.hasObject("data") && arg.matchesPrefix("data", "post")) {
                scriptEntry.addObject("data", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("method") && arg.matchesPrefix("method") && arg.matches("get", "post", "head", "options", "put", "delete", "trace")) {
                scriptEntry.addObject("method", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("hide_failure") && arg.matches("hide_failure")) {
                scriptEntry.addObject("hide_failure", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("timeout") && arg.matchesPrefix("timeout", "t") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("timeout", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("headers") && arg.matchesPrefix("headers") && arg.getValue().startsWith("map@")) {
                scriptEntry.addObject("headers", arg.asType(MapTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("headers") && arg.matchesPrefix("headers")) {
                MapTag map = new MapTag();
                for (String str : arg.asType(ListTag.class)) {
                    int ind = str.indexOf(47);
                    if (ind <= 0) continue;
                    map.putObject(str.substring(0, ind), new ElementTag(str.substring(ind + 1)));
                }
                scriptEntry.addObject("headers", map);
                continue;
            }
            if (!scriptEntry.hasObject("savefile") && arg.matchesPrefix("savefile")) {
                scriptEntry.addObject("savefile", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("url")) {
            throw new InvalidArgumentsException("Must have a valid URL!");
        }
        ElementTag url = scriptEntry.getElement("url");
        if (!url.asString().startsWith("http://") && !url.asString().startsWith("https://")) {
            throw new InvalidArgumentsException("Must have a valid (HTTP/HTTPS) URL! Attempted: " + url.asString());
        }
        scriptEntry.defaultObject("timeout", new DurationTag(10));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        if (!DenizenCore.getImplementation().allowedToWebget()) {
            Debug.echoError(scriptEntry.getResidingQueue(), "WebGet disabled by config!");
            return;
        }
        final ElementTag url = scriptEntry.getElement("url");
        final ElementTag data = scriptEntry.getElement("data");
        final ElementTag method = scriptEntry.getElement("method");
        final DurationTag timeout = (DurationTag)scriptEntry.getObjectTag("timeout");
        final MapTag headers = (MapTag)scriptEntry.getObjectTag("headers");
        final ElementTag saveFile = scriptEntry.getElement("savefile");
        final ElementTag hideFailure = scriptEntry.getElement("hide_failure");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), url.debug() + (data != null ? data.debug() : "") + (method != null ? method.debug() : "") + (timeout != null ? timeout.debug() : "") + (saveFile != null ? saveFile.debug() : "") + (hideFailure != null ? hideFailure.debug() : "") + (headers != null ? headers.debug() : ""));
        }
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                WebGetCommand.this.webGet(scriptEntry, data, method, url, timeout, headers, saveFile, hideFailure);
            }
        });
        thr.start();
    }

    public void buildResult(BufferedReader buffIn, StringBuilder sb) {
        try {
            String temp;
            while ((temp = buffIn.readLine()) != null) {
                sb.append(temp).append("\n");
            }
        }
        catch (Exception ex) {
        }
    }

    public void writeToFile(InputStream in, ElementTag saveFile) throws Exception {
        File file = new File(saveFile.asString());
        if (!DenizenCore.getImplementation().canWriteToFile(file)) {
            Debug.echoError("Cannot write to that file, as dangerous file paths have been disabled in the Denizen config.");
        } else {
            int len;
            FileOutputStream fout = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) > 0) {
                fout.write(buffer, 0, len);
            }
            fout.flush();
            fout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webGet(final ScriptEntry scriptEntry, ElementTag data, ElementTag method, ElementTag urlp, DurationTag timeout, MapTag headers, final ElementTag saveFile, ElementTag hideFailure) {
        BufferedReader buffIn = null;
        HttpURLConnection uc = null;
        try {
            final long timeStart = System.currentTimeMillis();
            URL url = new URL(urlp.asString().replace(" ", "%20"));
            uc = (HttpURLConnection)url.openConnection();
            uc.setDoInput(true);
            uc.setDoOutput(true);
            if (method != null) {
                uc.setRequestMethod(method.asString().toUpperCase());
            } else if (data != null) {
                uc.setRequestMethod("POST");
            }
            if (headers != null) {
                for (Map.Entry<StringHolder, ObjectTag> pair : headers.map.entrySet()) {
                    uc.setRequestProperty(pair.getKey().str, pair.getValue().toString());
                }
            }
            uc.setConnectTimeout((int)timeout.getMillis());
            uc.connect();
            if (data != null) {
                uc.getOutputStream().write(data.asString().getBytes(StandardCharsets.UTF_8));
            }
            final int status = uc.getResponseCode();
            final StringBuilder sb = new StringBuilder();
            if (saveFile != null) {
                this.writeToFile(uc.getInputStream(), saveFile);
            } else {
                buffIn = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                this.buildResult(buffIn, sb);
                buffIn.close();
                buffIn = null;
            }
            final MapTag resultHeaders = new MapTag();
            for (Map.Entry<String, List<String>> header : uc.getHeaderFields().entrySet()) {
                String key = header.getKey();
                if (key == null) {
                    key = "null";
                }
                resultHeaders.putObject(key, new ListTag(header.getValue()));
            }
            final long timeDone = System.currentTimeMillis();
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    scriptEntry.addObject("status", new ElementTag(status));
                    scriptEntry.addObject("failed", new ElementTag(status >= 200 && status < 400 ? "false" : "true"));
                    if (saveFile == null) {
                        scriptEntry.addObject("result", new ElementTag(sb.toString()));
                        scriptEntry.addObject("result_headers", resultHeaders);
                    }
                    scriptEntry.addObject("time_ran", new DurationTag((double)(timeDone - timeStart) / 1000.0));
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        catch (Exception e) {
            StringBuilder sb;
            int tempStatus;
            block30: {
                if (hideFailure == null || !hideFailure.asBoolean()) {
                    Debug.echoError(e);
                }
                tempStatus = -1;
                sb = new StringBuilder();
                if (uc != null) {
                    try {
                        tempStatus = uc.getResponseCode();
                        InputStream errorStream = uc.getErrorStream();
                        if (errorStream == null) break block30;
                        if (saveFile != null) {
                            this.writeToFile(errorStream, saveFile);
                            break block30;
                        }
                        buffIn = new BufferedReader(new InputStreamReader(errorStream));
                        this.buildResult(buffIn, sb);
                        buffIn.close();
                        buffIn = null;
                    }
                    catch (Exception e2) {
                        Debug.echoError(e2);
                    }
                } else if (hideFailure != null && hideFailure.asBoolean()) {
                    Debug.echoError(e);
                }
            }
            final int status = tempStatus;
            DenizenCore.schedule(new Schedulable(){

                @Override
                public boolean tick(float seconds) {
                    scriptEntry.addObject("failed", new ElementTag("true"));
                    if (status != -1) {
                        scriptEntry.addObject("status", new ElementTag(status));
                        if (saveFile == null) {
                            scriptEntry.addObject("result", new ElementTag(sb.toString()));
                        }
                    }
                    scriptEntry.setFinished(true);
                    return false;
                }
            });
        }
        finally {
            try {
                if (buffIn != null) {
                    buffIn.close();
                }
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
    }
}

