/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.utilities.DenizenAPI;
import java.util.UUID;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class MirrorTrait
extends Trait {
    @Persist(value="")
    public boolean mirror = true;

    public MirrorTrait() {
        super("mirror");
    }

    public static UUID getUUID(NPC npc) {
        UUID uuid = npc.getUniqueId();
        if (uuid.version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            uuid = new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        return uuid;
    }

    public static void respawn(NPC npc) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), () -> {
            if (npc.isSpawned()) {
                Location loc = npc.getEntity().getLocation();
                npc.despawn(DespawnReason.PENDING_RESPAWN);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), () -> npc.spawn(loc));
            }
        });
    }

    public static void mirrorOn(NPC npc) {
        UUID uuid = MirrorTrait.getUUID(npc);
        if (!ProfileEditor.mirrorUUIDs.contains(uuid)) {
            ProfileEditor.mirrorUUIDs.add(uuid);
            MirrorTrait.respawn(npc);
        }
    }

    public static void mirrorOff(NPC npc) {
        UUID uuid = MirrorTrait.getUUID(npc);
        if (ProfileEditor.mirrorUUIDs.contains(uuid)) {
            ProfileEditor.mirrorUUIDs.remove(uuid);
            MirrorTrait.respawn(npc);
        }
    }

    public void enableMirror() {
        this.mirror = true;
        MirrorTrait.mirrorOn(this.npc);
    }

    public void disableMirror() {
        this.mirror = false;
        MirrorTrait.mirrorOff(this.npc);
    }

    public void onSpawn() {
        if (this.mirror) {
            MirrorTrait.mirrorOn(this.npc);
        }
    }

    public void onRemove() {
        if (this.mirror) {
            MirrorTrait.mirrorOff(this.npc);
        }
    }

    public void onAttach() {
        if (this.mirror) {
            MirrorTrait.mirrorOn(this.npc);
        }
    }
}

