/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.npc.DenizenNPCHelper;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.FishingTrait;
import com.denizenscript.denizen.npc.traits.NicknameTrait;
import com.denizenscript.denizen.npc.traits.PushableTrait;
import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.npc.EngageCommand;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.Pose;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class NPCTag
implements ObjectTag,
Adjustable,
InventoryHolder,
EntityFormObject {
    public NPC npc;
    private String prefix = "npc";
    public static ObjectTagProcessor<NPCTag> tagProcessor = new ObjectTagProcessor();

    public static NPCRegistry getRegistryByName(String name) {
        NPCRegistry registry = CitizensAPI.getNamedNPCRegistry((String)name);
        if (registry != null) {
            return registry;
        }
        for (NPCRegistry possible : CitizensAPI.getNPCRegistries()) {
            if (!possible.getName().equals(name)) continue;
            return possible;
        }
        return null;
    }

    public static NPCTag fromEntity(Entity entity) {
        return new NPCTag(((NPCHolder)entity).getNPC());
    }

    @Deprecated
    public static NPCTag valueOf(String string) {
        return NPCTag.valueOf(string, null);
    }

    @Fetchable(value="n")
    public static NPCTag valueOf(String string, TagContext context) {
        NPCRegistry registry;
        if (string == null) {
            return null;
        }
        if (string.startsWith("n@")) {
            string = string.substring("n@".length());
        }
        int commaIndex = string.indexOf(44);
        String idText = string;
        if (commaIndex == -1) {
            registry = CitizensAPI.getNPCRegistry();
        } else {
            registry = NPCTag.getRegistryByName(string.substring(commaIndex + 1));
            if (registry == null) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("Unknown NPC registry for '" + string + "'.");
                }
                return null;
            }
            idText = string.substring(0, commaIndex);
        }
        if (ArgumentHelper.matchesInteger(idText)) {
            int id = Integer.parseInt(idText);
            NPC npc = registry.getById(id);
            if (npc != null) {
                return new NPCTag(npc);
            }
            if (context == null || context.showErrors()) {
                Debug.echoError("NPC '" + id + "' does not exist in " + registry.getName() + ".");
            }
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("n@")) {
            return true;
        }
        return NPCTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public boolean isValid() {
        return this.npc != null && this.npc.getOwningRegistry().getById(this.npc.getId()) != null;
    }

    public NPCTag(NPC citizensNPC) {
        this.npc = citizensNPC;
    }

    public NPC getCitizen() {
        return this.npc;
    }

    public Entity getEntity() {
        try {
            return this.getCitizen().getEntity();
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC entity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public LivingEntity getLivingEntity() {
        try {
            if (this.getCitizen().getEntity() instanceof LivingEntity) {
                return (LivingEntity)this.getCitizen().getEntity();
            }
            Debug.log("Uh oh! Tried to get the living entity of a non-living NPC!");
            return null;
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC livingEntity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    @Override
    public EntityTag getDenizenEntity() {
        try {
            return new EntityTag(this.getCitizen().getEntity());
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC EntityTag. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public org.bukkit.inventory.Inventory getInventory() {
        return DenizenNPCHelper.getInventory(this.getCitizen());
    }

    public InventoryTag getDenizenInventory() {
        return new InventoryTag(this.getInventory(), this);
    }

    public EntityType getEntityType() {
        return this.getCitizen().getEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.npc.getId();
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public InteractScriptContainer getInteractScript(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScript(this, player, triggerType);
    }

    public InteractScriptContainer getInteractScriptQuietly(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        InteractScriptHelper.debugGet = false;
        InteractScriptContainer script = InteractScriptHelper.getInteractScript(this, player, triggerType);
        InteractScriptHelper.debugGet = true;
        return script;
    }

    public void destroy() {
        this.getCitizen().destroy();
    }

    @Override
    public LocationTag getLocation() {
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public LocationTag getEyeLocation() {
        if (this.isSpawned() && this.getCitizen().getEntity() instanceof LivingEntity) {
            return new LocationTag(((LivingEntity)this.getCitizen().getEntity()).getEyeLocation());
        }
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.identify();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        return this.npc.isSpawned();
    }

    public String getOwner() {
        if (((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId() == null) {
            return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwner();
        }
        return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId().toString();
    }

    public AssignmentTrait getAssignmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(AssignmentTrait.class)) {
            npc.addTrait(AssignmentTrait.class);
        }
        return (AssignmentTrait)npc.getTrait(AssignmentTrait.class);
    }

    public Equipment getEquipmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Equipment.class)) {
            npc.addTrait(Equipment.class);
        }
        return (Equipment)npc.getTrait(Equipment.class);
    }

    public NicknameTrait getNicknameTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(NicknameTrait.class)) {
            npc.addTrait(NicknameTrait.class);
        }
        return (NicknameTrait)npc.getTrait(NicknameTrait.class);
    }

    public FishingTrait getFishingTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(FishingTrait.class)) {
            npc.addTrait(FishingTrait.class);
        }
        return (FishingTrait)npc.getTrait(FishingTrait.class);
    }

    public Inventory getInventoryTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Inventory.class)) {
            npc.addTrait(Inventory.class);
        }
        return (Inventory)npc.getTrait(Inventory.class);
    }

    public PushableTrait getPushableTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(PushableTrait.class)) {
            npc.addTrait(PushableTrait.class);
        }
        return (PushableTrait)npc.getTrait(PushableTrait.class);
    }

    public LookClose getLookCloseTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(LookClose.class)) {
            npc.addTrait(LookClose.class);
        }
        return (LookClose)npc.getTrait(LookClose.class);
    }

    public TriggerTrait getTriggerTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(TriggerTrait.class)) {
            npc.addTrait(TriggerTrait.class);
        }
        return (TriggerTrait)npc.getTrait(TriggerTrait.class);
    }

    public String action(String actionName, PlayerTag player, Map<String, ObjectTag> context) {
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return DenizenAPI.getCurrentInstance().getNPCHelper().getActionHandler().doAction(actionName, this, player, this.getAssignmentTrait().getAssignment(), context);
        }
        return "none";
    }

    public String action(String actionName, PlayerTag player) {
        return this.action(actionName, player, null);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        if (this.npc.getOwningRegistry() == CitizensAPI.getNPCRegistry()) {
            return "n@" + this.npc.getId() + "<GR> (" + this.getName() + ")";
        }
        return "n@" + this.npc.getId() + "<G>," + this.npc.getOwningRegistry().getName() + "<GR> (" + this.getName() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "NPC";
    }

    @Override
    public String identify() {
        if (this.npc.getOwningRegistry() == CitizensAPI.getNPCRegistry()) {
            return "n@" + this.npc.getId();
        }
        return "n@" + this.npc.getId() + "," + this.npc.getOwningRegistry().getName();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public NPCTag setPrefix(String prefix) {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NPCTag)) {
            return false;
        }
        return this.getId() == ((NPCTag)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    public static void registerTags() {
        NPCTag.registerTag("is_npc", (attribute, object) -> new ElementTag(true), new String[0]);
        NPCTag.registerTag("location", (attribute, object) -> {
            if (attribute.startsWith("previous_location", 2)) {
                attribute.fulfill(1);
                Deprecations.npcPreviousLocationTag.warn(attribute.context);
                return NPCTagBase.previousLocations.get(object.getId());
            }
            if (object.isSpawned()) {
                return new EntityTag((NPCTag)object).getObjectAttribute(attribute);
            }
            return object.getLocation();
        }, new String[0]);
        NPCTag.registerTag("previous_location", (attribute, object) -> NPCTagBase.previousLocations.get(object.getId()), new String[0]);
        NPCTag.registerTag("eye_location", (attribute, object) -> object.getEyeLocation(), new String[0]);
        NPCTag.registerTag("has_nickname", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            return new ElementTag(citizen.hasTrait(NicknameTrait.class) && ((NicknameTrait)citizen.getTrait(NicknameTrait.class)).hasNickname());
        }, new String[0]);
        NPCTag.registerTag("nickname", (attribute, object) -> new ElementTag(object.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)object.getCitizen().getTrait(NicknameTrait.class)).getNickname() : object.getName()), new String[0]);
        NPCTag.registerTag("name", (attribute, object) -> {
            if (attribute.startsWith("nickname", 2)) {
                Deprecations.npcNicknameTag.warn(attribute.context);
                attribute.fulfill(1);
                return new ElementTag(object.getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)object.getCitizen().getTrait(NicknameTrait.class)).getNickname() : object.getName());
            }
            return new ElementTag(object.getName());
        }, new String[0]);
        NPCTag.registerTag("traits", (attribute, object) -> {
            ArrayList<String> list = new ArrayList<String>();
            for (Trait trait : object.getCitizen().getTraits()) {
                list.add(trait.getName());
            }
            return new ListTag((List<String>)list);
        }, "list_traits");
        NPCTag.registerTag("has_trait", (attribute, object) -> {
            Class trait;
            if (attribute.hasContext(1) && (trait = CitizensAPI.getTraitFactory().getTraitClass(attribute.getContext(1))) != null) {
                return new ElementTag(object.getCitizen().hasTrait(trait));
            }
            return null;
        }, new String[0]);
        NPCTag.registerTag("pushable", (attribute, object) -> new ElementTag(object.getPushableTrait().isPushable()), "is_pushable");
        NPCTag.registerTag("has_trigger", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            if (!object.getCitizen().hasTrait(TriggerTrait.class)) {
                return new ElementTag(false);
            }
            TriggerTrait trait = (TriggerTrait)object.getCitizen().getTrait(TriggerTrait.class);
            return new ElementTag(trait.hasTrigger(attribute.getContext(1)));
        }, new String[0]);
        NPCTag.registerTag("has_anchors", (attribute, object) -> new ElementTag(((Anchors)object.getCitizen().getTrait(Anchors.class)).getAnchors().size() > 0), new String[0]);
        NPCTag.registerTag("list_anchors", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Anchor anchor : ((Anchors)object.getCitizen().getTrait(Anchors.class)).getAnchors()) {
                list.add(anchor.getName());
            }
            return list;
        }, new String[0]);
        NPCTag.registerTag("anchor", (attribute, object) -> {
            Anchors trait = (Anchors)object.getCitizen().getTrait(Anchors.class);
            if (attribute.hasContext(1)) {
                Anchor anchor = trait.getAnchor(attribute.getContext(1));
                if (anchor != null) {
                    return new LocationTag(anchor.getLocation());
                }
                attribute.echoError("NPC Anchor '" + attribute.getContext(1) + "' is not defined.");
                return null;
            }
            if (attribute.startsWith("list", 2)) {
                attribute.fulfill(1);
                Deprecations.npcAnchorListTag.warn(attribute.context);
                ListTag list = new ListTag();
                for (Anchor anchor : trait.getAnchors()) {
                    list.add(anchor.getName());
                }
                return list;
            }
            attribute.echoError("npc.anchor[...] tag must have an input.");
            return null;
        }, "anchors");
        NPCTag.registerTag("has_flag", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            return new ElementTag(FlagManager.npcHasFlag(object, flag_name));
        }, new String[0]);
        NPCTag.registerTag("flag", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            if (attribute.startsWith("is_expired", 2) || attribute.startsWith("isexpired", 22)) {
                attribute.fulfill(1);
                return new ElementTag(!FlagManager.npcHasFlag(object, flag_name));
            }
            if (attribute.startsWith("size", 2) && !FlagManager.npcHasFlag(object, flag_name)) {
                attribute.fulfill(1);
                return new ElementTag(0);
            }
            if (FlagManager.npcHasFlag(object, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(object.getId(), flag_name);
                if (attribute.startsWith("expiration", 2)) {
                    attribute.fulfill(1);
                    return flag.expiration();
                }
                return new ListTag(flag.toString(), true, flag.values());
            }
            return null;
        }, new String[0]);
        NPCTag.registerTag("list_flags", (attribute, object) -> {
            FlagManager.listFlagsTagWarning.warn(attribute.context);
            ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listNPCFlags(object.getId()));
            ListTag searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new ListTag();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        Debug.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
            }
            return searchFlags == null ? allFlags : searchFlags;
        }, new String[0]);
        NPCTag.registerTag("constant", (attribute, object) -> {
            if (attribute.hasContext(1)) {
                if (object.getCitizen().hasTrait(ConstantsTrait.class) && ((ConstantsTrait)object.getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1)) != null) {
                    return new ElementTag(((ConstantsTrait)object.getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1)));
                }
                return null;
            }
            return null;
        }, new String[0]);
        NPCTag.registerTag("has_pose", (attribute, object) -> {
            if (attribute.hasContext(1)) {
                return new ElementTag(((Poses)object.getCitizen().getTrait(Poses.class)).hasPose(attribute.getContext(1)));
            }
            return null;
        }, new String[0]);
        NPCTag.registerTag("pose", (attribute, object) -> {
            if (attribute.hasContext(1)) {
                Pose pose = ((Poses)object.getCitizen().getTrait(Poses.class)).getPose(attribute.getContext(1));
                return new LocationTag((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0, pose.getYaw(), pose.getPitch());
            }
            return null;
        }, "get_pose");
        NPCTag.registerTag("is_sneaking", (attribute, object) -> {
            if (!object.isSpawned() && object.getEntity() instanceof Player) {
                return null;
            }
            return new ElementTag(((Player)object.getEntity()).isSneaking());
        }, new String[0]);
        NPCTag.registerTag("engaged", (attribute, object) -> new ElementTag(object.isEngaged()), "is_engaged");
        NPCTag.registerTag("invulnerable", (attribute, object) -> new ElementTag((Boolean)object.getCitizen().data().get("protected", (Object)true)), "vulnerable");
        NPCTag.registerTag("id", (attribute, object) -> new ElementTag(object.getId()), new String[0]);
        NPCTag.registerTag("owner", (attribute, object) -> {
            String owner = object.getOwner();
            PlayerTag player = null;
            if (!owner.equalsIgnoreCase("server")) {
                player = PlayerTag.valueOfInternal(owner, false);
            }
            if (player != null) {
                return player;
            }
            return new ElementTag(owner);
        }, new String[0]);
        NPCTag.registerTag("has_skin", (attribute, object) -> new ElementTag(object.getCitizen().hasTrait(SkinTrait.class) && ((SkinTrait)object.getCitizen().getTrait(SkinTrait.class)).getSkinName() != null), new String[0]);
        NPCTag.registerTag("skin_blob", (attribute, object) -> {
            if (object.getCitizen().hasTrait(SkinTrait.class)) {
                SkinTrait skin = (SkinTrait)object.getCitizen().getTrait(SkinTrait.class);
                String tex = skin.getTexture();
                String sign = "";
                if (skin.getSignature() != null) {
                    sign = ";" + skin.getSignature();
                }
                return new ElementTag(tex + sign);
            }
            return null;
        }, new String[0]);
        NPCTag.registerTag("skull_skin", (attribute, object) -> {
            if (!object.getCitizen().hasTrait(SkinTrait.class)) {
                return null;
            }
            SkinTrait skin = (SkinTrait)object.getCitizen().getTrait(SkinTrait.class);
            return new ElementTag(skin.getSkinName() + "|" + skin.getTexture());
        }, new String[0]);
        NPCTag.registerTag("skin", (attribute, object) -> {
            if (object.getCitizen().hasTrait(SkinTrait.class)) {
                return new ElementTag(((SkinTrait)object.getCitizen().getTrait(SkinTrait.class)).getSkinName());
            }
            return null;
        }, new String[0]);
        NPCTag.registerTag("inventory", (attribute, object) -> object.getDenizenInventory(), new String[0]);
        NPCTag.registerTag("is_spawned", (attribute, object) -> new ElementTag(object.isSpawned()), new String[0]);
        NPCTag.registerTag("is_protected", (attribute, object) -> new ElementTag(object.getCitizen().isProtected()), new String[0]);
        NPCTag.registerTag("lookclose", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            if (citizen.hasTrait(LookClose.class)) {
                String lookclose = ((LookClose)citizen.getTrait(LookClose.class)).toString();
                lookclose = lookclose.substring(10, lookclose.length() - 1);
                return new ElementTag(Boolean.valueOf(lookclose));
            }
            return new ElementTag(false);
        }, new String[0]);
        NPCTag.registerTag("teleport_on_stuck", (attribute, object) -> new ElementTag(object.getNavigator().getDefaultParameters().stuckAction() == TeleportStuckAction.INSTANCE), new String[0]);
        NPCTag.registerTag("has_script", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            return new ElementTag(citizen.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment());
        }, new String[0]);
        NPCTag.registerTag("script", (attribute, object) -> {
            NPC citizen = object.getCitizen();
            if (!citizen.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()) {
                return null;
            }
            return new ScriptTag(((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).getAssignment().getName());
        }, new String[0]);
        NPCTag.registerTag("distance_margin", (attribute, object) -> new ElementTag(object.getNavigator().getDefaultParameters().distanceMargin()), new String[0]);
        NPCTag.registerTag("path_distance_margin", (attribute, object) -> new ElementTag(object.getNavigator().getDefaultParameters().pathDistanceMargin()), new String[0]);
        NPCTag.registerTag("is_navigating", (attribute, object) -> new ElementTag(object.getNavigator().isNavigating()), new String[0]);
        NPCTag.registerTag("speed", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().speed()), new String[0]);
        NPCTag.registerTag("range", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().range()), new String[0]);
        NPCTag.registerTag("attack_range", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().attackRange()), new String[0]);
        NPCTag.registerTag("attack_strategy", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().attackStrategy().toString()), new String[0]);
        NPCTag.registerTag("speed_modifier", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().speedModifier()), new String[0]);
        NPCTag.registerTag("base_speed", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().baseSpeed()), new String[0]);
        NPCTag.registerTag("avoid_water", (attribute, object) -> new ElementTag(object.getNavigator().getLocalParameters().avoidWater()), new String[0]);
        NPCTag.registerTag("target_location", (attribute, object) -> {
            if (object.getNavigator().getTargetAsLocation() == null) {
                return null;
            }
            return new LocationTag(object.getNavigator().getTargetAsLocation());
        }, new String[0]);
        NPCTag.registerTag("is_fighting", (attribute, object) -> new ElementTag(object.getNavigator().getEntityTarget() != null && object.getNavigator().getEntityTarget().isAggressive()), new String[0]);
        NPCTag.registerTag("target_type", (attribute, object) -> {
            if (object.getNavigator().getTargetType() == null) {
                return null;
            }
            return new ElementTag(object.getNavigator().getTargetType().toString());
        }, new String[0]);
        NPCTag.registerTag("target_entity", (attribute, object) -> {
            if (object.getNavigator().getEntityTarget() == null || object.getNavigator().getEntityTarget().getTarget() == null) {
                return null;
            }
            return new EntityTag(object.getNavigator().getEntityTarget().getTarget());
        }, new String[0]);
        NPCTag.registerTag("registry_name", (attribute, object) -> new ElementTag(object.getCitizen().getOwningRegistry().getName()), new String[0]);
        NPCTag.registerTag("navigator", (attribute, object) -> {
            Deprecations.oldNPCNavigator.warn(attribute.context);
            return object;
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<NPCTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        if (this.getEntity() != null) {
            return new EntityTag(this);
        }
        return new ElementTag(this.identify());
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to an NPC!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Waypoints wp;
        SkinTrait skinTrait;
        if (mechanism.matches("set_assignment") && mechanism.requireObject(ScriptTag.class)) {
            this.getAssignmentTrait().setAssignment(mechanism.valueAsType(ScriptTag.class).getName(), null);
        }
        if (mechanism.matches("remove_assignment")) {
            this.getAssignmentTrait().removeAssignment(null);
        }
        if (mechanism.matches("set_nickname")) {
            this.getNicknameTrait().setNickname(mechanism.getValue().asString());
        }
        if (mechanism.matches("remove_nickname")) {
            this.getNicknameTrait().removeNickname();
        }
        if (mechanism.matches("set_entity_type") && mechanism.requireObject(EntityTag.class)) {
            this.getCitizen().setBukkitEntityType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
        }
        if (mechanism.matches("name") || mechanism.matches("set_name")) {
            this.getCitizen().setName(mechanism.getValue().asString().length() > 64 ? mechanism.getValue().asString().substring(0, 64) : mechanism.getValue().asString());
        }
        if (mechanism.matches("owner")) {
            if (PlayerTag.matches(mechanism.getValue().asString())) {
                ((Owner)this.getCitizen().getTrait(Owner.class)).setOwner((CommandSender)mechanism.valueAsType(PlayerTag.class).getPlayerEntity());
            } else {
                ((Owner)this.getCitizen().getTrait(Owner.class)).setOwner(mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin_blob")) {
            if (!mechanism.hasValue()) {
                if (this.getCitizen().hasTrait(SkinTrait.class)) {
                    ((SkinTrait)this.getCitizen().getTrait(SkinTrait.class)).clearTexture();
                    if (this.getCitizen().isSpawned()) {
                        this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                        this.getCitizen().spawn(this.getCitizen().getStoredLocation());
                    }
                }
            } else {
                skinTrait = (SkinTrait)this.getCitizen().getTrait(SkinTrait.class);
                String[] dat = mechanism.getValue().asString().split(";");
                if (dat.length < 2) {
                    Debug.echoError("Invalid skin_blob input. Must specify texture;signature;name in full.");
                    return;
                }
                skinTrait.setSkinPersistent(dat.length > 2 ? dat[2] : UUID.randomUUID().toString(), dat[1], dat[0]);
                if (this.getCitizen().isSpawned() && this.getCitizen().getEntity() instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.getCitizen().getEntity()).getSkinTracker().notifySkinChange(true);
                }
            }
        }
        if (mechanism.matches("skin")) {
            if (!mechanism.hasValue()) {
                if (this.getCitizen().hasTrait(SkinTrait.class)) {
                    ((SkinTrait)this.getCitizen().getTrait(SkinTrait.class)).clearTexture();
                }
            } else {
                skinTrait = (SkinTrait)this.getCitizen().getTrait(SkinTrait.class);
                skinTrait.setSkinName(mechanism.getValue().asString());
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("item_type") && mechanism.requireObject(ItemTag.class)) {
            ItemTag item = mechanism.valueAsType(ItemTag.class);
            Material mat = item.getMaterial().getMaterial();
            switch (this.getEntity().getType()) {
                case DROPPED_ITEM: {
                    ((Item)this.getEntity()).getItemStack().setType(mat);
                    break;
                }
                case ITEM_FRAME: {
                    ((ItemFrame)this.getEntity()).getItem().setType(mat);
                    break;
                }
                case FALLING_BLOCK: {
                    this.getCitizen().data().setPersistent("item-type-id", (Object)mat.name());
                    this.getCitizen().data().setPersistent("item-type-data", (Object)0);
                    break;
                }
                default: {
                    Debug.echoError("NPC is the not an item type!");
                }
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn();
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("spawn")) {
            Deprecations.npcSpawnMechanism.warn(mechanism.context);
            if (mechanism.requireObject("Invalid LocationTag specified. Assuming last known NPC location.", LocationTag.class)) {
                this.getCitizen().spawn((Location)mechanism.valueAsType(LocationTag.class));
            } else {
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().range(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("attack_range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().attackRange((double)mechanism.getValue().asFloat());
        }
        if (mechanism.matches("speed") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().speedModifier(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("despawn")) {
            this.getCitizen().despawn(DespawnReason.PLUGIN);
        }
        if (mechanism.matches("set_sneaking") && mechanism.requireBoolean()) {
            SneakingTrait trait;
            if (!this.getCitizen().hasTrait(SneakingTrait.class)) {
                this.getCitizen().addTrait(SneakingTrait.class);
            }
            if ((trait = (SneakingTrait)this.getCitizen().getTrait(SneakingTrait.class)).isSneaking() && !mechanism.getValue().asBoolean()) {
                trait.sneak();
            } else if (!trait.isSneaking() && mechanism.getValue().asBoolean()) {
                trait.stand();
            }
        }
        if (mechanism.matches("set_protected") && mechanism.requireBoolean()) {
            this.getCitizen().setProtected(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("lookclose") && mechanism.requireBoolean()) {
            this.getLookCloseTrait().lookClose(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("teleport_on_stuck") && mechanism.requireBoolean()) {
            if (mechanism.getValue().asBoolean()) {
                this.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
            } else {
                this.getNavigator().getDefaultParameters().stuckAction(null);
            }
        }
        if ((mechanism.matches("distance_margin") || mechanism.matches("set_distance")) && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().distanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("path_distance_margin") && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().pathDistanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("name_visible")) {
            this.getCitizen().data().setPersistent("nameplate-visible", (Object)mechanism.getValue().asString());
        }
        if (mechanism.matches("clear_waypoints")) {
            if (!this.getCitizen().hasTrait(Waypoints.class)) {
                this.getCitizen().addTrait(Waypoints.class);
            }
            if ((wp = (Waypoints)this.getCitizen().getTrait(Waypoints.class)).getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).clear();
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                List locs = ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres();
                for (Location loc : locs) {
                    locs.remove(loc);
                }
            }
        }
        if (mechanism.matches("add_waypoint") && mechanism.requireObject(LocationTag.class)) {
            if (!this.getCitizen().hasTrait(Waypoints.class)) {
                this.getCitizen().addTrait(Waypoints.class);
            }
            if ((wp = (Waypoints)this.getCitizen().getTrait(Waypoints.class)).getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).add(new Waypoint((Location)mechanism.valueAsType(LocationTag.class)));
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres().add(mechanism.valueAsType(LocationTag.class));
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled() && this.isSpawned()) {
            new EntityTag(this.getEntity()).adjust(mechanism);
        }
    }
}

