/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.scripts.commands.server.BossBarCommand;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.CommandScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.ScoreboardHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.core.SQLCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.FutureWarning;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.map.MapCursor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ServerTagBase {
    public static final long serverStartTimeMillis = System.currentTimeMillis();

    public ServerTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTagBase.this.serverTag(event);
            }
        }, "server", "global");
    }

    /*
     * WARNING - void declaration
     */
    public void serverTag(ReplaceableTagEvent event) {
        block274: {
            BanEntry ban;
            ListTag players;
            String flag;
            Object matchPlayer;
            ListTag plugins;
            String group;
            Object npc;
            File folder;
            Enchantment ench;
            ListTag allMats;
            ListTag enchants;
            ListTag allBiomes;
            ListTag list;
            String flag_name;
            com.denizenscript.denizencore.tags.Attribute attribute;
            if (!event.matches("server", "global") || event.replaced()) {
                return;
            }
            if (event.matches("global")) {
                Deprecations.globalTagName.warn(event.getScriptEntry());
            }
            if ((attribute = event.getAttributes().fulfill(1)).startsWith("economy")) {
                if (Depends.economy == null) {
                    attribute.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    return;
                }
                if ((attribute = attribute.fulfill(1)).startsWith("format") && attribute.hasContext(1)) {
                    double amount = attribute.getDoubleContext(1);
                    event.setReplacedObject(new ElementTag(Depends.economy.format(amount)).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_name") && attribute.hasContext(1)) {
                    double amount = attribute.getDoubleContext(1);
                    event.setReplacedObject(new ElementTag(amount == 1.0 ? Depends.economy.currencyNameSingular() : Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_plural")) {
                    event.setReplacedObject(new ElementTag(Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("currency_singular")) {
                    event.setReplacedObject(new ElementTag(Depends.economy.currencyNameSingular()).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                return;
            }
            if (attribute.startsWith("slot_id") && attribute.hasContext(1)) {
                int slotId = SlotHelper.nameToIndex(attribute.getContext(1));
                if (slotId != -1) {
                    event.setReplacedObject(new ElementTag(slotId).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("parse_bukkit_item") && attribute.hasContext(1)) {
                YamlConfiguration config = new YamlConfiguration();
                try {
                    config.loadFromString(attribute.getContext(1));
                    ItemStack itemStack = config.getItemStack("item");
                    if (itemStack != null) {
                        event.setReplacedObject(new ItemTag(itemStack).getObjectAttribute(attribute.fulfill(1)));
                    }
                }
                catch (Exception exception) {
                    Debug.echoError(exception);
                }
                return;
            }
            if (attribute.startsWith("recipe_ids") || attribute.startsWith("list_recipe_ids")) {
                ServerTagBase.listDeprecateWarn(attribute);
                String type = attribute.hasContext(1) ? CoreUtilities.toLowerCase(attribute.getContext(1)) : null;
                ListTag listTag = new ListTag();
                Iterator iterator = Bukkit.recipeIterator();
                while (iterator.hasNext()) {
                    Recipe recipe = (Recipe)iterator.next();
                    if (!Utilities.isRecipeOfType(recipe, type) || !(recipe instanceof Keyed)) continue;
                    listTag.add(((Keyed)recipe).getKey().toString());
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("recipe_items") && attribute.hasContext(1)) {
                NamespacedKey key = Utilities.parseNamespacedKey(attribute.getContext(1));
                Recipe recipe = NMSHandler.getItemHelper().getRecipeById(key);
                if (recipe == null) {
                    return;
                }
                ListTag listTag = new ListTag();
                Consumer<RecipeChoice> addChoice = choice -> {
                    if (choice == null) {
                        result.addObject(new ItemTag(Material.AIR));
                    } else if (choice instanceof RecipeChoice.ExactChoice) {
                        result.addObject(new ItemTag(choice.getItemStack()));
                    } else {
                        result.add("material:" + choice.getItemStack().getType().name());
                    }
                };
                if (recipe instanceof ShapedRecipe) {
                    for (String row : ((ShapedRecipe)recipe).getShape()) {
                        for (char column : row.toCharArray()) {
                            addChoice.accept((RecipeChoice)((ShapedRecipe)recipe).getChoiceMap().get(Character.valueOf(column)));
                        }
                    }
                } else if (recipe instanceof ShapelessRecipe) {
                    for (RecipeChoice choice2 : ((ShapelessRecipe)recipe).getChoiceList()) {
                        addChoice.accept(choice2);
                    }
                } else if (recipe instanceof CookingRecipe) {
                    addChoice.accept(((CookingRecipe)recipe).getInputChoice());
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("recipe_shape") && attribute.hasContext(1)) {
                NamespacedKey key = Utilities.parseNamespacedKey(attribute.getContext(1));
                Recipe recipe = NMSHandler.getItemHelper().getRecipeById(key);
                if (!(recipe instanceof ShapedRecipe)) {
                    return;
                }
                String[] stringArray = ((ShapedRecipe)recipe).getShape();
                event.setReplacedObject(new ElementTag(stringArray[0].length() + "x" + stringArray.length));
                return;
            }
            if (attribute.startsWith("recipe_type") && attribute.hasContext(1)) {
                NamespacedKey key = Utilities.parseNamespacedKey(attribute.getContext(1));
                Recipe recipe = NMSHandler.getItemHelper().getRecipeById(key);
                if (recipe == null) {
                    return;
                }
                event.setReplacedObject(new ElementTag(Utilities.getRecipeType(recipe)));
                return;
            }
            if (attribute.startsWith("recipe_result") && attribute.hasContext(1)) {
                NamespacedKey key = Utilities.parseNamespacedKey(attribute.getContext(1));
                Recipe recipe = NMSHandler.getItemHelper().getRecipeById(key);
                if (recipe == null) {
                    return;
                }
                event.setReplacedObject(new ItemTag(recipe.getResult()));
                return;
            }
            if (attribute.startsWith("scoreboard")) {
                Scoreboard board;
                String string = "main";
                if (attribute.hasContext(1)) {
                    String string2 = attribute.getContext(1);
                    board = ScoreboardHelper.getScoreboard(string2);
                } else {
                    board = ScoreboardHelper.getMain();
                }
                attribute = attribute.fulfill(1);
                if (attribute.startsWith("exists")) {
                    event.setReplacedObject(new ElementTag(board != null).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (board == null) {
                    void var4_22;
                    attribute.echoError("Scoreboard '" + (String)var4_22 + "' does not exist.");
                    return;
                }
                if (attribute.startsWith("objectives")) {
                    ListTag listTag = new ListTag();
                    for (Objective objective : board.getObjectives()) {
                        listTag.add(objective.getName());
                    }
                    event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                }
                if (attribute.startsWith("objective") && attribute.hasContext(1)) {
                    Objective objective = board.getObjective(attribute.getContext(1));
                    if (objective == null) {
                        attribute.echoError("Scoreboard objective '" + attribute.getContext(1) + "' does not exist.");
                        return;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("criteria")) {
                        event.setReplacedObject(new ElementTag(objective.getCriteria()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("display_name")) {
                        event.setReplacedObject(new ElementTag(objective.getDisplayName()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    if (attribute.startsWith("display_slot")) {
                        if (objective.getDisplaySlot() == null) {
                            return;
                        }
                        event.setReplacedObject(new ElementTag(objective.getDisplaySlot().name()).getObjectAttribute(attribute.fulfill(1)));
                    }
                }
                if (attribute.startsWith("team_names")) {
                    ListTag listTag = new ListTag();
                    for (Team team : board.getTeams()) {
                        listTag.add(team.getName());
                    }
                    event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                }
                if (attribute.startsWith("team") && attribute.hasContext(1)) {
                    Team team = board.getTeam(attribute.getContext(1));
                    if (team == null) {
                        attribute.echoError("Scoreboard team '" + attribute.getContext(1) + "' does not exist.");
                        return;
                    }
                    if ((attribute = attribute.fulfill(1)).startsWith("members")) {
                        event.setReplacedObject(new ListTag(team.getEntries()).getObjectAttribute(attribute.fulfill(1)));
                    }
                    return;
                }
            }
            if (attribute.startsWith("object_is_valid")) {
                ObjectTag o = ObjectFetcher.pickObjectFor(attribute.getContext(1), new BukkitTagContext(null, null, null, false, null));
                event.setReplacedObject(new ElementTag(o != null && !(o instanceof ElementTag)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_whitelist")) {
                event.setReplacedObject(new ElementTag(Bukkit.hasWhitelist()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_flag")) {
                if (!attribute.hasContext(1)) {
                    return;
                }
                flag_name = attribute.getContext(1);
                event.setReplacedObject(new ElementTag(FlagManager.serverHasFlag(flag_name)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("flag") && attribute.hasContext(1)) {
                flag_name = attribute.getContext(1);
                attribute.fulfill(1);
                if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                    event.setReplacedObject(new ElementTag(!FlagManager.serverHasFlag(flag_name)).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("size") && !FlagManager.serverHasFlag(flag_name)) {
                    event.setReplacedObject(new ElementTag(0).getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
                if (FlagManager.serverHasFlag(flag_name)) {
                    FlagManager.Flag flag2 = DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flag_name);
                    if (attribute.startsWith("expiration")) {
                        event.setReplacedObject(flag2.expiration().getObjectAttribute(attribute.fulfill(1)));
                        return;
                    }
                    event.setReplacedObject(new ListTag(flag2.toString(), true, flag2.values()).getObjectAttribute(attribute));
                }
                return;
            }
            if ((attribute.startsWith("traits") || attribute.startsWith("list_traits")) && Depends.citizens != null) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allTraits = new ListTag();
                for (TraitInfo traitInfo : CitizensAPI.getTraitFactory().getRegisteredTraits()) {
                    allTraits.add(traitInfo.getTraitName());
                }
                event.setReplacedObject(allTraits.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("commands") || attribute.startsWith("list_commands")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag(CommandScriptHelper.knownCommands.keySet());
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("advancement_types") || attribute.startsWith("list_advancements")) {
                if (attribute.matches("list_advancements")) {
                    Debug.echoError("list_advancements is deprecated: use advancement_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                Bukkit.advancementIterator().forEachRemaining(adv -> list.add(adv.getKey().toString()));
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("nbt_attribute_types") || attribute.startsWith("list_nbt_attribute_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (Attribute attribute2 : Attribute.values()) {
                    list.add(attribute2.name());
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("damage_causes") || attribute.startsWith("list_damage_causes")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (EntityDamageEvent.DamageCause damageCause : EntityDamageEvent.DamageCause.values()) {
                    list.add(damageCause.name());
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("biome_types") || attribute.startsWith("list_biome_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                allBiomes = new ListTag();
                for (Biome biome : Biome.values()) {
                    allBiomes.addObject(new BiomeTag(biome));
                }
                event.setReplacedObject(allBiomes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_biomes")) {
                Deprecations.serverListBiomeNames.warn(attribute.context);
                allBiomes = new ListTag();
                for (Biome biome : Biome.values()) {
                    allBiomes.add(biome.name());
                }
                event.setReplacedObject(allBiomes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_types") || attribute.startsWith("list_enchantments")) {
                if (attribute.matches("list_enchantments")) {
                    Debug.echoError("list_enchantments is deprecated: use enchantment_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                enchants = new ListTag();
                for (Enchantment enchantment : Enchantment.values()) {
                    enchants.add(enchantment.getName());
                }
                event.setReplacedObject(enchants.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_keys") || attribute.startsWith("list_enchantment_keys")) {
                ServerTagBase.listDeprecateWarn(attribute);
                enchants = new ListTag();
                for (Enchantment enchantment : Enchantment.values()) {
                    enchants.add(enchantment.getKey().getKey());
                }
                event.setReplacedObject(enchants.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("entity_types") || attribute.startsWith("list_entity_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allEnt = new ListTag();
                for (EntityType entityType : EntityType.values()) {
                    allEnt.add(entityType.name());
                }
                event.setReplacedObject(allEnt.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("material_types") || attribute.startsWith("list_material_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                allMats = new ListTag();
                for (Material material : Material.values()) {
                    allMats.addObject(new MaterialTag(material));
                }
                event.setReplacedObject(allMats.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_materials")) {
                Deprecations.serverListMaterialNames.warn(attribute.context);
                allMats = new ListTag();
                for (Material material : Material.values()) {
                    allMats.add(material.name());
                }
                event.setReplacedObject(allMats.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("sound_types") || attribute.startsWith("list_sounds")) {
                if (attribute.matches("list_sounds")) {
                    Debug.echoError("list_sounds is deprecated: use sound_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag sounds = new ListTag();
                for (Sound sound : Sound.values()) {
                    sounds.add(sound.toString());
                }
                event.setReplacedObject(sounds.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("particle_types") || attribute.startsWith("list_particles")) {
                if (attribute.matches("list_particles")) {
                    Debug.echoError("list_particles is deprecated: use particle_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag particleTypes = new ListTag();
                for (Particle particle : Particle.values()) {
                    particleTypes.add(particle.toString());
                }
                event.setReplacedObject(particleTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("effect_types") || attribute.startsWith("list_effects")) {
                if (attribute.matches("list_effects")) {
                    Debug.echoError("list_effects is deprecated: use effect_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag effectTypes = new ListTag();
                for (Effect effect : Effect.values()) {
                    effectTypes.add(effect.toString());
                }
                event.setReplacedObject(effectTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("pattern_types") || attribute.startsWith("list_patterns")) {
                if (attribute.matches("list_patterns")) {
                    Debug.echoError("list_patterns is deprecated: use pattern_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allPatterns = new ListTag();
                for (PatternType patternType : PatternType.values()) {
                    allPatterns.add(patternType.toString());
                }
                event.setReplacedObject(allPatterns.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("potion_effect_types") || attribute.startsWith("list_potion_effects")) {
                if (attribute.matches("list_potion_effects")) {
                    Debug.echoError("list_potion_effects is deprecated: use potion_effect_types");
                }
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag statuses = new ListTag();
                for (PotionEffectType potionEffectType : PotionEffectType.values()) {
                    if (potionEffectType == null) continue;
                    statuses.add(potionEffectType.getName());
                }
                event.setReplacedObject(statuses.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("potion_types") || attribute.startsWith("list_potion_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag potionTypes = new ListTag();
                for (PotionType potionType : PotionType.values()) {
                    potionTypes.add(potionType.toString());
                }
                event.setReplacedObject(potionTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("tree_types") || attribute.startsWith("list_tree_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allTrees = new ListTag();
                for (TreeType treeType : TreeType.values()) {
                    allTrees.add(treeType.name());
                }
                event.setReplacedObject(allTrees.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("map_cursor_types") || attribute.startsWith("list_map_cursor_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag mapCursors = new ListTag();
                for (MapCursor.Type type : MapCursor.Type.values()) {
                    mapCursors.add(type.toString());
                }
                event.setReplacedObject(mapCursors.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("world_types") || attribute.startsWith("list_world_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag worldTypes = new ListTag();
                for (WorldType worldType : WorldType.values()) {
                    worldTypes.add(worldType.toString());
                }
                event.setReplacedObject(worldTypes.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("statistic_types") || attribute.startsWith("list_statistics")) {
                void var7_250;
                ServerTagBase.listDeprecateWarn(attribute);
                if (attribute.matches("list_statistics")) {
                    Debug.echoError("list_statistics is deprecated: use statistic_types");
                }
                Statistic.Type type = null;
                if (attribute.hasContext(1)) {
                    type = Statistic.Type.valueOf((String)attribute.getContext(1).toUpperCase());
                }
                ListTag listTag = new ListTag();
                Statistic[] statisticArray = Statistic.values();
                int addChoice = statisticArray.length;
                boolean bl = false;
                while (var7_250 < addChoice) {
                    Statistic stat = statisticArray[var7_250];
                    if (type == null || type == stat.getType()) {
                        listTag.add(stat.toString());
                    }
                    ++var7_250;
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("structure_types") || attribute.startsWith("list_structure_types")) {
                ServerTagBase.listDeprecateWarn(attribute);
                event.setReplacedObject(new ListTag(StructureType.getStructureTypes().keySet()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_flags")) {
                void var4_64;
                FlagManager.listFlagsTagWarning.warn(attribute.context);
                ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listGlobalFlags());
                Object var4_62 = null;
                if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                    ListTag listTag = new ListTag();
                    String string = attribute.getContext(1);
                    if (string.startsWith("regex:")) {
                        try {
                            Pattern pattern = Pattern.compile(string.substring(6), 2);
                            for (String flag3 : allFlags) {
                                if (!pattern.matcher(flag3).matches()) continue;
                                listTag.add(flag3);
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                    } else {
                        String string3 = CoreUtilities.toLowerCase(string);
                        for (String string4 : allFlags) {
                            if (!CoreUtilities.toLowerCase(string4).contains(string3)) continue;
                            listTag.add(string4);
                        }
                    }
                    DenizenAPI.getCurrentInstance().flagManager().shrinkGlobalFlags(listTag);
                } else {
                    DenizenAPI.getCurrentInstance().flagManager().shrinkGlobalFlags(allFlags);
                }
                event.setReplacedObject(var4_64 == null ? allFlags.getObjectAttribute(attribute.fulfill(1)) : var4_64.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("notables") || attribute.startsWith("list_notables")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag allNotables = new ListTag();
                if (attribute.hasContext(1)) {
                    String string = CoreUtilities.toLowerCase(attribute.getContext(1));
                    for (Map.Entry<String, Class> typeClass : NotableManager.getReverseClassIdMap().entrySet()) {
                        if (!string.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                        for (Object notable : NotableManager.getAllType(typeClass.getValue())) {
                            allNotables.addObject((ObjectTag)notable);
                        }
                        break;
                    }
                } else {
                    for (Notable notable : NotableManager.notableObjects.values()) {
                        allNotables.addObject((ObjectTag)((Object)notable));
                    }
                }
                event.setReplacedObject(allNotables.getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("statistic_type") && attribute.hasContext(1)) {
                Statistic statistic;
                try {
                    statistic = Statistic.valueOf((String)attribute.getContext(1).toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    attribute.echoError("Statistic '" + attribute.getContext(1) + "' does not exist: " + illegalArgumentException.getMessage());
                    return;
                }
                event.setReplacedObject(new ElementTag(statistic.getType().name()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_max_level") && attribute.hasContext(1)) {
                ench = Utilities.getEnchantmentByName(attribute.getContext(1));
                if (ench == null) {
                    attribute.echoError("Enchantment '" + attribute.getContext(1) + "' does not exist.");
                    return;
                }
                event.setReplacedObject(new ElementTag(ench.getMaxLevel()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("enchantment_start_level") && attribute.hasContext(1)) {
                ench = Utilities.getEnchantmentByName(attribute.getContext(1));
                if (ench == null) {
                    attribute.echoError("Enchantment '" + attribute.getContext(1) + "' does not exist.");
                    return;
                }
                event.setReplacedObject(new ElementTag(ench.getStartLevel()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("start_time")) {
                event.setReplacedObject(new DurationTag(Denizen.startTime / 50L).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("disk_free")) {
                folder = DenizenAPI.getCurrentInstance().getDataFolder();
                event.setReplacedObject(new ElementTag(folder.getUsableSpace()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("disk_total")) {
                folder = DenizenAPI.getCurrentInstance().getDataFolder();
                event.setReplacedObject(new ElementTag(folder.getTotalSpace()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("disk_usage")) {
                folder = DenizenAPI.getCurrentInstance().getDataFolder();
                event.setReplacedObject(new ElementTag(folder.getTotalSpace() - folder.getFreeSpace()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_allocated")) {
                event.setReplacedObject(new ElementTag(Runtime.getRuntime().totalMemory()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_max")) {
                event.setReplacedObject(new ElementTag(Runtime.getRuntime().maxMemory()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_free")) {
                event.setReplacedObject(new ElementTag(Runtime.getRuntime().freeMemory()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_usage")) {
                event.setReplacedObject(new ElementTag(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("available_processors")) {
                event.setReplacedObject(new ElementTag(Runtime.getRuntime().availableProcessors()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("current_tick")) {
                event.setReplacedObject(new ElementTag(TickScriptEvent.instance.ticks).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("delta_time_since_start")) {
                event.setReplacedObject(new DurationTag(TickScriptEvent.instance.ticks).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("real_time_since_start")) {
                event.setReplacedObject(new DurationTag((double)(System.currentTimeMillis() - serverStartTimeMillis) / 1000.0).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("current_time_millis")) {
                event.setReplacedObject(new ElementTag(System.currentTimeMillis()).getObjectAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("selected_npc")) {
                npc = ((Citizens)Bukkit.getPluginManager().getPlugin("Citizens")).getNPCSelector().getSelected((CommandSender)Bukkit.getConsoleSender());
                if (npc == null) {
                    return;
                }
                event.setReplacedObject(new NPCTag((NPC)npc).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("npcs_named") || attribute.startsWith("list_npcs_named")) && Depends.citizens != null && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag npcs2 = new ListTag();
                String string = attribute.getContext(1);
                for (NPC npc2 : CitizensAPI.getNPCRegistry()) {
                    if (!CoreUtilities.equalsIgnoreCase(npc2.getName(), string)) continue;
                    npcs2.addObject(new NPCTag(npc2));
                }
                event.setReplacedObject(npcs2.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_file") && attribute.hasContext(1)) {
                File f = new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1));
                try {
                    if (!Utilities.canReadFile(f)) {
                        attribute.echoError("Invalid path specified. Invalid paths have been denied by the server administrator.");
                        return;
                    }
                }
                catch (Exception exception) {
                    Debug.echoError(exception);
                    return;
                }
                event.setReplacedObject(new ElementTag(f.exists()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_files") && attribute.hasContext(1)) {
                folder = new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1));
                try {
                    if (!Utilities.canReadFile(folder)) {
                        attribute.echoError("Invalid path specified. Invalid paths have been denied by the server administrator.");
                        return;
                    }
                    if (!folder.exists() || !folder.isDirectory()) {
                        attribute.echoError("Invalid path specified. No directory exists at that path.");
                        return;
                    }
                }
                catch (Exception exception) {
                    Debug.echoError(exception);
                    return;
                }
                File[] fileArray = folder.listFiles();
                if (fileArray == null) {
                    return;
                }
                ListTag listTag = new ListTag();
                for (File file : fileArray) {
                    listTag.add(file.getName());
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_permissions")) {
                event.setReplacedObject(new ElementTag(Depends.permissions != null && Depends.permissions.isEnabled()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_economy")) {
                event.setReplacedObject(new ElementTag(Depends.economy != null && Depends.economy.isEnabled()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("denizen_version")) {
                event.setReplacedObject(new ElementTag(DenizenAPI.getCurrentInstance().getDescription().getVersion()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("bukkit_version")) {
                event.setReplacedObject(new ElementTag(Bukkit.getBukkitVersion()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("version")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getVersion()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("java_version")) {
                event.setReplacedObject(new ElementTag(System.getProperty("java.version")).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("max_players")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getMaxPlayers()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("sql_connections") || attribute.startsWith("list_sql_connections")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                for (Map.Entry<String, Connection> entry : SQLCommand.connections.entrySet()) {
                    try {
                        if (!entry.getValue().isClosed()) {
                            list.add(entry.getKey());
                            continue;
                        }
                        SQLCommand.connections.remove(entry.getKey());
                    }
                    catch (SQLException e) {
                        Debug.echoError(attribute.getScriptEntry().getResidingQueue(), e);
                    }
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_prefix")) {
                if (Depends.permissions == null) {
                    attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getContext(1);
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    attribute.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.startsWith("world", 2)) {
                    WorldTag worldTag = attribute.contextAsType(2, WorldTag.class);
                    if (worldTag != null) {
                        event.setReplacedObject(new ElementTag(Depends.chat.getGroupPrefix(worldTag.getWorld(), group)).getObjectAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplacedObject(new ElementTag(Depends.chat.getGroupPrefix((World)Bukkit.getWorlds().get(0), group)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_suffix")) {
                if (Depends.permissions == null) {
                    attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getContext(1);
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    attribute.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.startsWith("world", 2)) {
                    WorldTag worldTag = attribute.contextAsType(2, WorldTag.class);
                    if (worldTag != null) {
                        event.setReplacedObject(new ElementTag(Depends.chat.getGroupSuffix(worldTag.getWorld(), group)).getObjectAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplacedObject(new ElementTag(Depends.chat.getGroupSuffix((World)Bukkit.getWorlds().get(0), group)).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("permission_groups") || attribute.startsWith("list_permission_groups")) {
                if (Depends.permissions == null) {
                    attribute.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                ServerTagBase.listDeprecateWarn(attribute);
                event.setReplacedObject(new ListTag(Arrays.asList(Depends.permissions.getGroups())).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_plugin_names")) {
                Deprecations.serverPluginNamesTag.warn(attribute.context);
                plugins = new ListTag();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.add(plugin.getName());
                }
                event.setReplacedObject(plugins.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("scripts") || attribute.startsWith("list_scripts")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag scripts = new ListTag();
                for (ScriptContainer scriptContainer : ScriptRegistry.scriptContainers.values()) {
                    scripts.addObject(new ScriptTag(scriptContainer));
                }
                event.setReplacedObject(scripts.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("match_player") && attribute.hasContext(1)) {
                matchPlayer = null;
                String string = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (CoreUtilities.equalsIgnoreCase(player.getName(), string)) {
                        matchPlayer = player;
                        break;
                    }
                    if (!CoreUtilities.toLowerCase(player.getName()).contains(string) || matchPlayer != null) continue;
                    matchPlayer = player;
                }
                if (matchPlayer != null) {
                    event.setReplacedObject(new PlayerTag((Player)matchPlayer).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("match_offline_player") && attribute.hasContext(1)) {
                matchPlayer = null;
                String string = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                    if (CoreUtilities.equalsIgnoreCase(entry.getKey(), string)) {
                        matchPlayer = entry.getValue();
                        break;
                    }
                    if (!CoreUtilities.toLowerCase(entry.getKey()).contains(string) || matchPlayer != null) continue;
                    matchPlayer = entry.getValue();
                }
                if (matchPlayer != null) {
                    event.setReplacedObject(new PlayerTag((UUID)matchPlayer).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if ((attribute.startsWith("npcs_assigned") || attribute.startsWith("list_npcs_assigned")) && Depends.citizens != null && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                ScriptTag script = attribute.contextAsType(1, ScriptTag.class);
                if (script == null || !(script.getContainer() instanceof AssignmentScriptContainer)) {
                    attribute.echoError("Invalid script specified.");
                } else {
                    ListTag listTag = new ListTag();
                    for (NPC npc3 : CitizensAPI.getNPCRegistry()) {
                        if (!npc3.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).hasAssignment() || !CoreUtilities.equalsIgnoreCase(((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).getAssignment().getName(), script.getName())) continue;
                        listTag.addObject(new NPCTag(npc3));
                    }
                    event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                    return;
                }
            }
            if ((attribute.startsWith("online_players_flagged") || attribute.startsWith("list_online_players_flagged")) && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getContext(1);
                ListTag listTag = new ListTag();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(new PlayerTag(player), flag).size() <= 0) continue;
                    listTag.addObject(new PlayerTag(player));
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("players_flagged") || attribute.startsWith("list_players_flagged")) && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getContext(1);
                ListTag listTag = new ListTag();
                for (Map.Entry<String, UUID> entry : PlayerTag.getAllPlayers().entrySet()) {
                    if (!FlagManager.playerHasFlag(new PlayerTag(entry.getValue()), flag)) continue;
                    listTag.addObject(new PlayerTag(entry.getValue()));
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("spawned_npcs_flagged") || attribute.startsWith("list_spawned_npcs_flagged")) && Depends.citizens != null && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getContext(1);
                ListTag listTag = new ListTag();
                for (NPC npc4 : CitizensAPI.getNPCRegistry()) {
                    NPCTag nPCTag = new NPCTag(npc4);
                    if (!nPCTag.isSpawned() || !FlagManager.npcHasFlag(nPCTag, flag)) continue;
                    listTag.addObject(nPCTag);
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("npcs_flagged") || attribute.startsWith("list_npcs_flagged")) && Depends.citizens != null && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                flag = attribute.getContext(1);
                ListTag listTag = new ListTag();
                for (NPC npc5 : CitizensAPI.getNPCRegistry()) {
                    NPCTag nPCTag = new NPCTag(npc5);
                    if (!FlagManager.npcHasFlag(nPCTag, flag)) continue;
                    listTag.addObject(nPCTag);
                }
                event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("npc_registries") && Depends.citizens != null) {
                ListTag result = new ListTag();
                for (NPCRegistry nPCRegistry : CitizensAPI.getNPCRegistries()) {
                    result.add(nPCRegistry.getName());
                }
                event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if ((attribute.startsWith("npcs") || attribute.startsWith("list_npcs")) && Depends.citizens != null) {
                void var4_90;
                NPCRegistry nPCRegistry;
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag npcs = new ListTag();
                NPCRegistry nPCRegistry2 = CitizensAPI.getNPCRegistry();
                if (attribute.hasContext(1) && (nPCRegistry = NPCTag.getRegistryByName(attribute.getContext(1))) == null) {
                    attribute.echoError("NPC Registry '" + attribute.getContext(1) + "' does not exist.");
                    return;
                }
                for (NPC npc6 : var4_90) {
                    npcs.addObject(new NPCTag(npc6));
                }
                event.setReplacedObject(npcs.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("worlds") || attribute.startsWith("list_worlds")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag worlds = new ListTag();
                for (World world : Bukkit.getWorlds()) {
                    worlds.addObject(WorldTag.mirrorBukkitWorld(world));
                }
                event.setReplacedObject(worlds.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("plugins") || attribute.startsWith("list_plugins")) {
                ServerTagBase.listDeprecateWarn(attribute);
                plugins = new ListTag();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.addObject(new PluginTag(plugin));
                }
                event.setReplacedObject(plugins.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("players") || attribute.startsWith("list_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("online_players") || attribute.startsWith("list_online_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.addObject(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("offline_players") || attribute.startsWith("list_offline_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (offlinePlayer.isOnline()) continue;
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("banned_players") || attribute.startsWith("list_banned_players")) {
                ServerTagBase.listDeprecateWarn(attribute);
                ListTag banned = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getBannedPlayers()) {
                    banned.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(banned.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("banned_addresses") || attribute.startsWith("list_banned_addresses")) {
                ServerTagBase.listDeprecateWarn(attribute);
                list = new ListTag();
                list.addAll(Bukkit.getIPBans());
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("is_banned") && attribute.hasContext(1)) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getContext(1));
                if (ban == null) {
                    event.setReplacedObject(new ElementTag(false).getObjectAttribute(attribute.fulfill(1)));
                } else if (ban.getExpiration() == null) {
                    event.setReplacedObject(new ElementTag(true).getObjectAttribute(attribute.fulfill(1)));
                } else {
                    event.setReplacedObject(new ElementTag(ban.getExpiration().after(new Date())).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("ban_info") && attribute.hasContext(1)) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getContext(1));
                attribute.fulfill(1);
                if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                    return;
                }
                if (attribute.startsWith("expiration") && ban.getExpiration() != null) {
                    event.setReplacedObject(new DurationTag(ban.getExpiration().getTime() / 50L).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("reason")) {
                    event.setReplacedObject(new ElementTag(ban.getReason()).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("created")) {
                    event.setReplacedObject(new DurationTag(ban.getCreated().getTime() / 50L).getObjectAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("source")) {
                    event.setReplacedObject(new ElementTag(ban.getSource()).getObjectAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("ops") || attribute.startsWith("list_ops")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOperators()) {
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("online_ops") || attribute.startsWith("list_online_ops")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOperators()) {
                    if (!offlinePlayer.isOnline()) continue;
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("offline_ops") || attribute.startsWith("list_offline_ops")) {
                ServerTagBase.listDeprecateWarn(attribute);
                players = new ListTag();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.isOp() || offlinePlayer.isOnline()) continue;
                    players.addObject(PlayerTag.mirrorBukkitPlayer(offlinePlayer));
                }
                event.setReplacedObject(players.getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("motd")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getMotd()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("view_distance")) {
                event.setReplacedObject(new ElementTag(Bukkit.getServer().getViewDistance()).getObjectAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("entity_is_spawned") && attribute.hasContext(1)) {
                EntityTag ent = EntityTag.valueOf(attribute.getContext(1), new BukkitTagContext(null, null, null, false, null));
                event.setReplacedObject(new ElementTag(ent != null && ent.isUnique() && ent.isSpawnedOrValidForTag() ? "true" : "false").getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("player_is_valid") && attribute.hasContext(1)) {
                event.setReplacedObject(new ElementTag(PlayerTag.playerNameIsValid(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("npc_is_valid") && attribute.hasContext(1)) {
                npc = NPCTag.valueOf(attribute.getContext(1), new BukkitTagContext(null, null, null, false, null));
                event.setReplacedObject(new ElementTag(npc != null && ((NPCTag)npc).isValid()).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("current_bossbars")) {
                ListTag dl = new ListTag(BossBarCommand.bossBarMap.keySet());
                event.setReplacedObject(dl.getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("recent_tps")) {
                list = new ListTag();
                for (double d : NMSHandler.getInstance().getRecentTps()) {
                    list.addObject(new ElementTag(d));
                }
                event.setReplacedObject(list.getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("port")) {
                event.setReplacedObject(new ElementTag(NMSHandler.getInstance().getPort()).getObjectAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("debug_enabled")) {
                event.setReplacedObject(new ElementTag(Debug.showDebug).getObjectAttribute(attribute.fulfill(1)));
            } else if ((attribute.matches("plugins_handling_event") || attribute.matches("list_plugins_handling_event")) && attribute.hasContext(1)) {
                ServerTagBase.listDeprecateWarn(attribute);
                String eventName = attribute.getContext(1);
                if (CoreUtilities.contains(eventName, '.')) {
                    try {
                        Class<?> clazz = Class.forName(eventName, false, ServerTagBase.class.getClassLoader());
                        ListTag listTag = ServerTagBase.getHandlerPluginList(clazz);
                        if (listTag != null) {
                            event.setReplacedObject(listTag.getObjectAttribute(attribute.fulfill(1)));
                        }
                        break block274;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError(classNotFoundException);
                        }
                        break block274;
                    }
                }
                ScriptEvent scriptEvent = ScriptEvent.eventLookup.get(CoreUtilities.toLowerCase(eventName));
                if (scriptEvent instanceof Listener) {
                    Denizen denizen = DenizenAPI.getCurrentInstance();
                    for (Class clazz : denizen.getPluginLoader().createRegisteredListeners((Listener)scriptEvent, (Plugin)denizen).keySet()) {
                        ListTag result = ServerTagBase.getHandlerPluginList(clazz);
                        if (result == null || result.size() <= 0) continue;
                        event.setReplacedObject(result.getObjectAttribute(attribute.fulfill(1)));
                        return;
                    }
                    event.setReplacedObject(new ListTag().getObjectAttribute(attribute.fulfill(1)));
                }
            }
        }
    }

    public static void listDeprecateWarn(com.denizenscript.denizencore.tags.Attribute attribute) {
        if (FutureWarning.futureWarningsEnabled && attribute.getAttribute(1).startsWith("list_")) {
            Deprecations.listStyleTags.warn(attribute.context);
            Debug.echoError("Tag '" + attribute.getAttribute(1) + "' is deprecated: remove the 'list_' prefix.");
        }
    }

    public static ListTag getHandlerPluginList(Class eventClass) {
        HandlerList handlers;
        if (Event.class.isAssignableFrom(eventClass) && (handlers = BukkitScriptEvent.getEventListeners(eventClass)) != null) {
            ListTag result = new ListTag();
            HashSet<String> deduplicationSet = new HashSet<String>();
            for (RegisteredListener listener : handlers.getRegisteredListeners()) {
                if (!deduplicationSet.add(listener.getPlugin().getName())) continue;
                result.addObject(new PluginTag(listener.getPlugin()));
            }
            return result;
        }
        return null;
    }

    public static void adjustServer(Mechanism mechanism) {
        if (mechanism.matches("delete_file") && mechanism.hasValue()) {
            if (!Settings.allowDelete()) {
                Debug.echoError("File deletion disabled by administrator.");
                return;
            }
            File file = new File(DenizenAPI.getCurrentInstance().getDataFolder(), mechanism.getValue().asString());
            if (!Utilities.canWriteToFile(file)) {
                Debug.echoError("Cannot delete that file (unsafe path).");
                return;
            }
            try {
                if (!file.delete()) {
                    Debug.echoError("Failed to delete file: returned false");
                }
            }
            catch (Exception e) {
                Debug.echoError("Failed to delete file: " + e.getMessage());
            }
        }
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            Deprecations.serverRedirectLogging.warn(mechanism.context);
            if (!Settings.allowConsoleRedirection()) {
                Debug.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
        if (mechanism.matches("reset_event_stats")) {
            for (ScriptEvent se : ScriptEvent.events) {
                se.stats.fires = 0L;
                se.stats.scriptFires = 0L;
                se.stats.nanoTimes = 0L;
            }
        }
        if (mechanism.matches("reset_recipes")) {
            Bukkit.resetRecipes();
            DenizenAPI.getCurrentInstance().itemScriptHelper.rebuildRecipes();
        }
        if (mechanism.matches("remove_recipes")) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            for (String str : list) {
                NMSHandler.getItemHelper().removeRecipe(Utilities.parseNamespacedKey(str));
            }
        }
        if (mechanism.matches("cleanmem")) {
            System.gc();
        }
        if (mechanism.matches("restart")) {
            if (!Settings.allowServerRestart()) {
                Debug.echoError("Server restart disabled by administrator. Consider using 'shutdown'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server restarted by a Denizen script, see config to prevent this!");
            Bukkit.spigot().restart();
        }
        if (mechanism.matches("save")) {
            DenizenAPI.getCurrentInstance().saveSaves();
        }
        if (Depends.citizens != null && mechanism.matches("save_citizens")) {
            Depends.citizens.storeNPCs(new CommandContext(new String[0]));
        }
        if (mechanism.matches("shutdown")) {
            if (!Settings.allowServerStop()) {
                Debug.echoError("Server stop disabled by administrator. Consider using 'restart'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server shutdown by a Denizen script, see config to prevent this!");
            Bukkit.shutdown();
        }
    }
}

