/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUnbreakable
implements Property {
    dItem item;

    public static boolean describes(dObject object) {
        return object instanceof dItem;
    }

    public static ItemUnbreakable getFrom(dObject object) {
        if (!ItemUnbreakable.describes(object)) {
            return null;
        }
        return new ItemUnbreakable((dItem)object);
    }

    private ItemUnbreakable(dItem item) {
        this.item = item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("unbreakable")) {
            return new Element(this.getPropertyString() != null).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        ItemStack itemStack = this.item.getItemStack();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
            return itemStack.hasItemMeta() && itemStack.getItemMeta().isUnbreakable() ? "true" : null;
        }
        return itemStack.hasItemMeta() && itemStack.getItemMeta().spigot().isUnbreakable() ? "true" : null;
    }

    @Override
    public String getPropertyId() {
        return "unbreakable";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unbreakable") && mechanism.requireBoolean()) {
            ItemStack itemStack = this.item.getItemStack().clone();
            ItemMeta meta = itemStack.getItemMeta();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1)) {
                meta.setUnbreakable(mechanism.getValue().asBoolean());
            } else {
                meta.spigot().setUnbreakable(mechanism.getValue().asBoolean());
            }
            itemStack.setItemMeta(meta);
            this.item.setItemStack(itemStack);
        }
    }
}

