/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.containers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.ScriptEntrySet;
import net.aufdemrand.denizencore.scripts.ScriptHelper;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ScriptContainer
implements Debuggable {
    YamlConfiguration contents;
    private String name;
    public ScriptEntrySet baseEntries = null;
    private Map<String, ScriptEntrySet> scriptsMap = new HashMap<String, ScriptEntrySet>();
    private Boolean shouldDebug = null;

    public ScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        if (configurationSection == null) {
            dB.echoError("Null configuration section while generating a ScriptContainer?!");
        }
        this.contents = configurationSection;
        this.name = scriptContainerName.toUpperCase();
    }

    public YamlConfiguration getContents() {
        return this.contents;
    }

    public <T extends ScriptContainer> T getAsContainerType(Class<T> type) {
        return (T)((ScriptContainer)type.cast(this));
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return ScriptHelper.getSource(this.getName());
    }

    public String getOriginalName() {
        return ScriptHelper.getOriginalName(this.getName());
    }

    public dScript getAsScriptArg() {
        return dScript.valueOf(this.name);
    }

    public String getContainerType() {
        return this.contents.contains("TYPE") ? this.contents.getString("TYPE").toUpperCase() : null;
    }

    public boolean contains(String path) {
        return this.contents.contains(path.toUpperCase());
    }

    public String getString(String path) {
        return this.contents.getString(path.toUpperCase());
    }

    public String getString(String path, String def) {
        return this.contents.getString(path.toUpperCase(), def);
    }

    public List<String> getStringList(String path) {
        return this.contents.getStringList(path.toUpperCase());
    }

    public YamlConfiguration getConfigurationSection(String path) {
        if (path.length() == 0) {
            return this.contents;
        }
        return this.contents.getConfigurationSection(path.toUpperCase());
    }

    public void set(String path, Object object) {
        this.contents.set(path.toUpperCase(), object);
    }

    public List<ScriptEntry> getBaseEntries(ScriptEntryData data) {
        if (this.baseEntries == null) {
            this.baseEntries = this.getSetFor("script");
        }
        return ScriptContainer.cleanDup(data, this.baseEntries);
    }

    public static List<ScriptEntry> cleanDup(ScriptEntryData data, ScriptEntrySet set) {
        if (set == null) {
            return null;
        }
        set = set.duplicate();
        for (ScriptEntry entry : set.entries) {
            entry.entryData = data.clone();
        }
        return set.entries;
    }

    public List<ScriptEntry> getEntries(ScriptEntryData data, String path) {
        if (path == null) {
            path = "script";
        }
        return ScriptContainer.cleanDup(data, this.getSetFor(path));
    }

    public ScriptEntrySet getSetFor(String path) {
        ScriptEntrySet got = this.scriptsMap.get(path);
        if (got != null) {
            return got;
        }
        List<Object> stringEntries = this.contents.getList(path);
        if (stringEntries == null || stringEntries.size() == 0) {
            return null;
        }
        List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(stringEntries, this, null);
        got = new ScriptEntrySet(entries);
        this.scriptsMap.put(path, got);
        return got;
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebug == null) {
            this.shouldDebug = !this.contents.contains("debug") || !this.contents.getString("debug").equalsIgnoreCase("false");
        }
        return this.shouldDebug;
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.name.equalsIgnoreCase(criteria.replace("s@", ""));
    }

    public String toString() {
        return "s@" + CoreUtilities.toLowerCase(this.getName());
    }
}

