/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashSet;

public class Argument
implements Cloneable {
    public String raw_value;
    public String prefix = null;
    public String lower_prefix = null;
    public String value;
    public String lower_value;
    public ObjectTag object = null;
    public boolean needsFill = false;
    public boolean hasSpecialPrefix = false;
    public ScriptEntry scriptEntry = null;
    public static AsciiMatcher prefixCharsAllowed = new AsciiMatcher("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_");

    public Argument clone() {
        try {
            return (Argument)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public String generateRaw() {
        return this.prefix == null ? this.value : this.prefix + ":" + this.value;
    }

    public Argument(String prefix, String value) {
        this.prefix = prefix;
        this.value = value;
        if (prefix != null) {
            if (prefix.equals("no_prefix")) {
                this.prefix = null;
                this.raw_value = this.value;
            } else {
                this.raw_value = prefix + ":" + this.value;
                this.lower_prefix = CoreUtilities.toLowerCase(prefix);
            }
        } else {
            this.raw_value = this.value;
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
        this.object = new ElementTag(this.value);
    }

    public void fillStr(String string) {
        this.raw_value = string;
        int first_colon = string.indexOf(58);
        int first_not_prefix = prefixCharsAllowed.indexOfFirstNonMatch(string);
        if (first_not_prefix > -1 && first_not_prefix < first_colon || first_colon == -1) {
            this.value = string;
            if (this.object == null) {
                this.object = new ElementTag(this.value);
            }
        } else {
            this.prefix = string.substring(0, first_colon);
            if (this.prefix.equals("no_prefix")) {
                this.prefix = null;
            } else {
                this.lower_prefix = CoreUtilities.toLowerCase(this.prefix);
            }
            this.value = string.substring(first_colon + 1);
            this.object = new ElementTag(this.value);
        }
        this.lower_value = CoreUtilities.toLowerCase(this.value);
    }

    public Argument(String string) {
        this.fillStr(string);
    }

    public static Argument valueOf(String string) {
        return new Argument(string);
    }

    public boolean startsWith(String string) {
        return this.lower_value.startsWith(string);
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public Argument getPrefix() {
        if (this.prefix == null) {
            return null;
        }
        return Argument.valueOf(this.prefix);
    }

    public boolean matches(String value) {
        return value.equals(this.lower_value);
    }

    public boolean matches(String ... values) {
        for (String value : values) {
            if (!value.equals(this.lower_value)) continue;
            return true;
        }
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public ListTag getList(TagContext context) {
        if (this.object instanceof ListTag) {
            return (ListTag)this.object;
        }
        if (context == null && this.scriptEntry != null) {
            context = this.scriptEntry.getContext();
        }
        return ListTag.valueOf(this.value, context);
    }

    public static HashSet<String> precalcEnum(Enum<?>[] values) {
        HashSet<String> toRet = new HashSet<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            toRet.add(values[i].name().toUpperCase().replace("_", ""));
        }
        return toRet;
    }

    public boolean matchesEnum(HashSet<String> values) {
        String upper = this.value.replace("_", "").toUpperCase();
        return values.contains(upper);
    }

    public boolean matchesEnum(Enum<?>[] values) {
        String upper = this.value.replace("_", "").toUpperCase();
        for (Enum<?> value : values) {
            if (!value.name().replace("_", "").equals(upper)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesEnumList(Enum<?>[] values) {
        ListTag list = this.getList(CoreUtilities.noDebugContext);
        for (String string : list) {
            String tval = string.replace("_", "");
            for (Enum<?> value : values) {
                if (!CoreUtilities.equalsIgnoreCase(value.name().replace("_", ""), tval)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesPrefix(String value) {
        if (!this.hasPrefix()) {
            return false;
        }
        return value.equals(this.lower_prefix);
    }

    public boolean matchesPrefix(String ... values) {
        if (!this.hasPrefix()) {
            return false;
        }
        for (String value : values) {
            if (!value.equals(this.lower_prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesBoolean() {
        return this.lower_value.equals("true") || this.lower_value.equals("false");
    }

    public boolean matchesInteger() {
        return this.matchesFloat();
    }

    public boolean matchesFloat() {
        return ArgumentHelper.matchesDouble(this.lower_value);
    }

    public boolean matchesArgumentType(Class<? extends ObjectTag> dClass) {
        return CoreUtilities.canPossiblyBeType(this.object, dClass);
    }

    public boolean matchesArgumentTypes(Class<? extends ObjectTag> ... dClasses) {
        for (Class<? extends ObjectTag> c : dClasses) {
            if (!this.matchesArgumentType(c)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesArgumentList(Class<? extends ObjectTag> dClass) {
        ListTag list = this.getList(CoreUtilities.noDebugContext);
        return list.isEmpty() || list.containsObjectsFrom(dClass);
    }

    public ElementTag asElement() {
        if (this.object instanceof ElementTag) {
            return (ElementTag)this.object;
        }
        return new ElementTag(this.prefix, this.value);
    }

    public <T extends ObjectTag> T asType(Class<T> clazz) {
        T arg = CoreUtilities.asType(this.object, clazz, DenizenCore.getImplementation().getTagContext(this.scriptEntry));
        if (arg == null) {
            Debug.echoError("Cannot process argument '" + this.object + "' as type '" + clazz.getSimpleName() + "' (conversion returned null).");
            return null;
        }
        arg.setPrefix(this.prefix);
        return arg;
    }

    public void reportUnhandled() {
        if (TagManager.recentTagError) {
            Debug.echoError('\'' + this.raw_value + "' is an unknown argument! This was probably caused by a tag not parsing properly.");
            return;
        }
        if (this.prefix != null) {
            Debug.echoError('\'' + this.raw_value + "' is an unknown argument! Did you mess up the command syntax?");
        } else {
            Debug.echoError('\'' + this.raw_value + "' is an unknown argument! Did you forget quotes, or did you mess up the command syntax?");
        }
        if (this.scriptEntry != null && this.scriptEntry.getCommand() != null) {
            Debug.log("Command usage: " + this.scriptEntry.getCommand().getUsageHint());
        }
    }

    public String toString() {
        return this.raw_value;
    }
}

