/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.BlockHelper;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.MaterialCompat;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Utilities {
    private static final String colors = "0123456789abcdefklmnorABCDEFKLMNOR";
    private static final String colorsLimited = "0123456789abcdef";

    public static boolean canReadFile(File f) {
        if (Settings.allowStupids()) {
            return true;
        }
        try {
            return Settings.allowStrangeYAMLSaves() || f.getCanonicalPath().startsWith(new File(".").getCanonicalPath());
        }
        catch (Exception ex) {
            dB.echoError(ex);
            return false;
        }
    }

    public static boolean isFileCanonicalStringSafe(String lown) {
        if (lown.contains("denizen/config.yml")) {
            return false;
        }
        if (lown.contains("denizen/scripts/")) {
            return false;
        }
        if (lown.endsWith(".jar") || lown.endsWith(".java")) {
            return false;
        }
        return !lown.endsWith("plugins/");
    }

    public static boolean isSafeFile(File f) {
        if (Settings.allowStupids()) {
            return true;
        }
        try {
            String lown = CoreUtilities.toLowerCase(f.getCanonicalPath()).replace('\\', '/');
            if (dB.verbose) {
                dB.log("Checking file : " + lown);
            }
            if (!Settings.allowStrangeYAMLSaves() && !f.getCanonicalPath().startsWith(new File(".").getCanonicalPath())) {
                return false;
            }
            return Utilities.isFileCanonicalStringSafe(lown) && Utilities.isFileCanonicalStringSafe(lown + "/");
        }
        catch (Exception ex) {
            dB.echoError(ex);
            return false;
        }
    }

    public static Location getWalkableLocationNear(Location location, int range) {
        ArrayList<Location> locations = new ArrayList<Location>();
        location = location.getBlock().getLocation();
        for (double x = (double)(-range); x <= (double)range; x += 1.0) {
            for (double y = (double)(-range); y <= (double)range; y += 1.0) {
                for (double z = (double)(-range); z <= (double)range; z += 1.0) {
                    Location loc = location.clone().add(x, y, z);
                    if (!Utilities.checkLocation(location, loc, (double)range) || !Utilities.isWalkable(loc)) continue;
                    locations.add(loc);
                }
            }
        }
        if (locations.isEmpty()) {
            return null;
        }
        return (Location)locations.get(CoreUtilities.getRandom().nextInt(locations.size()));
    }

    public static boolean isWalkable(Location location) {
        BlockHelper blockHelper = NMSHandler.getInstance().getBlockHelper();
        return !blockHelper.isSafeBlock(location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType()) && blockHelper.isSafeBlock(location.getBlock().getType()) && blockHelper.isSafeBlock(location.clone().add(0.0, 1.0, 0.0).getBlock().getType());
    }

    public static String[] wrapWords(String text, int width) {
        StringBuilder sb = new StringBuilder(text);
        int i = 0;
        while (i + width < sb.length() && (i = sb.lastIndexOf(" ", i + width)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return sb.toString().split("\n");
    }

    public static void talkToNPC(String message, dPlayer player, dNPC npc, double range) {
        String replacer = String.valueOf('\u0004');
        String talkFormat = Settings.chatToNpcFormat().replaceAll("(?i)<TEXT>", replacer);
        String bystanderFormat = Settings.chatToNpcOverheardFormat().replaceAll("(?i)<TEXT>", replacer);
        talkFormat = TagManager.tag(talkFormat, new BukkitTagContext(player, npc, false, null, true, null)).replace(replacer, message);
        bystanderFormat = TagManager.tag(bystanderFormat, new BukkitTagContext(player, npc, false, null, true, null)).replace(replacer, message);
        player.getPlayerEntity().sendMessage(talkFormat);
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target == player.getPlayerEntity() || !target.getWorld().equals(player.getPlayerEntity().getWorld()) || !(target.getLocation().distance(player.getPlayerEntity().getLocation()) <= range)) continue;
            target.sendMessage(bystanderFormat);
        }
    }

    public static int lastIndexOfUCL(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isBetween(double a, double b, double c) {
        return b > a ? c >= a && c < b : c >= b && c < a;
    }

    public static dNPC getClosestNPC_ChatTrigger(Location location, int range) {
        dNPC closestNPC = null;
        double closestDistance = Math.pow(range, 2.0);
        for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
            dLocation loc = npc.getLocation();
            if (!npc.getCitizen().hasTrait(TriggerTrait.class) || !npc.getTriggerTrait().hasTrigger("CHAT") || !loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < closestDistance)) continue;
            closestNPC = npc;
            closestDistance = npc.getLocation().distanceSquared(location);
        }
        return closestNPC;
    }

    public static boolean checkLocation(LivingEntity entity, Location theLocation, double theLeeway) {
        if (entity.getWorld() != theLocation.getWorld()) {
            return false;
        }
        Location entityLocation = entity.getLocation();
        if (Math.abs(entityLocation.getX() - theLocation.getX()) > theLeeway) {
            return false;
        }
        if (Math.abs(entityLocation.getY() - theLocation.getY()) > theLeeway) {
            return false;
        }
        return !(Math.abs(entityLocation.getZ() - theLocation.getZ()) > theLeeway);
    }

    public static boolean checkLocation(Location baseLocation, Location theLocation, double theLeeway) {
        if (!baseLocation.getWorld().getName().equals(theLocation.getWorld().getName())) {
            return false;
        }
        return baseLocation.distanceSquared(theLocation) < theLeeway * theLeeway;
    }

    public static void setSignLines(Sign sign, String[] lines) {
        for (int n = 0; n < 4; ++n) {
            sign.setLine(n, lines[n]);
        }
        sign.update();
    }

    public static BlockFace chooseSignRotation(Block signBlock) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            Block block = signBlock.getRelative(blockFace);
            Material material = block.getType();
            if (material == Material.AIR || material == MaterialCompat.SIGN || material == Material.WALL_SIGN) continue;
            return blockFace.getOppositeFace();
        }
        return BlockFace.SOUTH;
    }

    public static BlockFace chooseSignRotation(String direction) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            if (!blockFace.name().startsWith(direction.toUpperCase().substring(0, 1))) continue;
            return blockFace;
        }
        return BlockFace.SOUTH;
    }

    public static void setSignRotation(BlockState signState) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            Block block = signState.getBlock().getRelative(blockFace);
            Material material = block.getType();
            if (material == Material.AIR || material == MaterialCompat.SIGN || material == Material.WALL_SIGN) continue;
            ((org.bukkit.material.Sign)signState.getData()).setFacingDirection(blockFace.getOppositeFace());
            signState.update();
        }
    }

    public static void setSignRotation(BlockState signState, String direction) {
        BlockFace[] blockFaces;
        for (BlockFace blockFace : blockFaces = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH}) {
            if (!blockFace.name().startsWith(direction.toUpperCase().substring(0, 1))) continue;
            ((org.bukkit.material.Sign)signState.getData()).setFacingDirection(blockFace);
        }
        signState.update();
    }

    public static boolean isBlock(Location block, Location location) {
        if (!block.getWorld().getName().equals(location.getWorld().getName())) {
            return false;
        }
        if (Math.abs(block.getBlockX() - location.getBlockX()) > 0) {
            return false;
        }
        if (Math.abs(block.getBlockY() - location.getBlockY()) > 0) {
            return false;
        }
        return Math.abs(block.getBlockZ() - location.getBlockZ()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(File jarFile, String fileName, String destDir) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> myEnum = jar.entries();
            while (myEnum.hasMoreElements()) {
                JarEntry file = myEnum.nextElement();
                if (!file.getName().equalsIgnoreCase(fileName)) continue;
                File f = new File(destDir + "/" + file.getName());
                if (file.isDirectory()) continue;
                InputStream is = jar.getInputStream(file);
                FileOutputStream fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
                return;
            }
            dB.echoError(fileName + " not found in the jar!");
        }
        catch (IOException e) {
            dB.echoError(e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    dB.echoError(e);
                }
            }
        }
    }

    public static String generateRandomColors(int count) {
        String ret = "";
        for (int i = 0; i < count; ++i) {
            ret = ret + String.valueOf('\u00a7') + colors.charAt(CoreUtilities.getRandom().nextInt(colors.length()));
        }
        return ret;
    }

    public static String generateRandomColorsWithDots(int count) {
        String ret = "";
        for (int i = 0; i < count; ++i) {
            ret = ret + String.valueOf('\u00a7') + colorsLimited.charAt(CoreUtilities.getRandom().nextInt(colorsLimited.length())) + ".";
        }
        return ret;
    }
}

