/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.properties.item.ItemPotion;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerBeaconEffectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerBeaconEffectScriptEvent instance;
    public BeaconEffectEvent event;

    public PlayerBeaconEffectScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player beacon effect applied");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerBeaconEffect";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (!PlayerBeaconEffectScriptEvent.isDefaultDetermination(determinationObj)) {
            try {
                this.event.setEffect(ItemPotion.parseEffect(determinationObj.toString()));
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return new LocationTag(this.event.getBlock().getLocation());
        }
        if (name.equals("effect")) {
            return new ElementTag(ItemPotion.stringifyEffect(this.event.getEffect()));
        }
        if (name.equals("effect_type")) {
            return new ElementTag(this.event.getEffect().getType().getName());
        }
        if (name.equals("is_primary")) {
            return new ElementTag(this.event.isPrimary());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void beaconEffectEvent(BeaconEffectEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

