/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.tags.TagManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerTagBase
implements Listener {
    public static Map<UUID, List<String>> playerChatHistory = new HashMap<UUID, List<String>>();

    public PlayerTagBase() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        TagManager.registerTagHandler("player", attribute -> {
            if (!attribute.hasContext(1)) {
                PlayerTag player = ((BukkitTagContext)attribute.context).player;
                if (player != null) {
                    return player;
                }
                attribute.echoError("Missing player for player tag.");
                return null;
            }
            return PlayerTag.valueOf(attribute.getContext(1), attribute.context);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void addMessage(final AsyncPlayerChatEvent event) {
        final int maxSize = Settings.chatHistoryMaxMessages();
        if (maxSize > 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                @Override
                public void run() {
                    List<String> history = playerChatHistory.get(event.getPlayer().getUniqueId());
                    if (history == null) {
                        history = new ArrayList<String>();
                    }
                    if (history.size() > maxSize) {
                        history.remove(maxSize - 1);
                    }
                    history.add(0, event.getMessage());
                    playerChatHistory.put(event.getPlayer().getUniqueId(), history);
                }
            }, 1L);
        }
    }
}

