/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.interfaces;

import java.util.UUID;
import net.aufdemrand.denizen.nms.util.BoundingBox;
import net.aufdemrand.denizen.nms.util.jnbt.CompoundTag;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public interface EntityHelper {
    public Entity getFishHook(PlayerFishEvent var1);

    public void forceInteraction(Player var1, Location var2);

    public Entity getEntity(World var1, UUID var2);

    public boolean isBreeding(Animals var1);

    public void setBreeding(Animals var1, boolean var2);

    public void setTarget(Creature var1, LivingEntity var2);

    public CompoundTag getNbtData(Entity var1);

    public void setNbtData(Entity var1, CompoundTag var2);

    public void setSilent(Entity var1, boolean var2);

    public boolean isSilent(Entity var1);

    public ItemStack getItemInHand(LivingEntity var1);

    public void setItemInHand(LivingEntity var1, ItemStack var2);

    public ItemStack getItemInOffHand(LivingEntity var1);

    public void setItemInOffHand(LivingEntity var1, ItemStack var2);

    public void stopFollowing(Entity var1);

    public void stopWalking(Entity var1);

    public void toggleAI(Entity var1, boolean var2);

    public boolean isAIDisabled(Entity var1);

    public double getSpeed(Entity var1);

    public void setSpeed(Entity var1, double var2);

    public void follow(Entity var1, Entity var2, double var3, double var5, double var7, boolean var9);

    public void walkTo(Entity var1, Location var2, double var3, Runnable var5);

    public void hideEntity(Player var1, Entity var2, boolean var3);

    public void unhideEntity(Player var1, Entity var2);

    public boolean isHidden(Player var1, Entity var2);

    public void rotate(Entity var1, float var2, float var3);

    public float getBaseYaw(Entity var1);

    public void look(Entity var1, float var2, float var3);

    public boolean canTrace(World var1, Vector var2, Vector var3);

    public MapTraceResult mapTrace(LivingEntity var1, double var2);

    public Location rayTrace(Location var1, Vector var2, double var3);

    public Location getImpactNormal(Location var1, Vector var2, double var3);

    public Location eyeTrace(LivingEntity var1, double var2);

    default public Location faceLocation(Location from, Location at) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        Location newLocation = from.clone();
        newLocation.setYaw(180.0f - (float)Math.toDegrees(Math.atan2(direction.getX(), direction.getZ())));
        newLocation.setPitch(90.0f - (float)Math.toDegrees(Math.acos(direction.getY())));
        return newLocation;
    }

    public void faceLocation(Entity var1, Location var2);

    public void faceEntity(Entity var1, Entity var2);

    default public boolean isFacingLocation(Location from, Location at, float yawLimitDegrees, float pitchLimitDegrees) {
        Vector direction = from.toVector().subtract(at.toVector()).normalize();
        float pitch = 90.0f - (float)Math.toDegrees(Math.acos(direction.getY()));
        if (from.getPitch() > pitch + pitchLimitDegrees || from.getPitch() < pitch - pitchLimitDegrees) {
            return false;
        }
        return this.isFacingLocation(from, at, yawLimitDegrees);
    }

    default public boolean isFacingLocation(Location from, Location at, float degreeLimit) {
        double currentYaw = this.normalizeYaw(from.getYaw());
        double requiredYaw = this.normalizeYaw(this.getYaw(at.toVector().subtract(from.toVector()).normalize()));
        return Math.abs(requiredYaw - currentYaw) < (double)degreeLimit || Math.abs(requiredYaw + 360.0 - currentYaw) < (double)degreeLimit || Math.abs(currentYaw + 360.0 - requiredYaw) < (double)degreeLimit;
    }

    default public boolean isFacingLocation(Entity from, Location at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at, degreeLimit);
    }

    default public boolean isFacingEntity(Entity from, Entity at, float degreeLimit) {
        return this.isFacingLocation(from.getLocation(), at.getLocation(), degreeLimit);
    }

    default public float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    default public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    default public String getCardinal(float yaw) {
        if (0.0f <= (yaw = this.normalizeYaw(yaw)) && (double)yaw < 22.5) {
            return "south";
        }
        if (22.5 <= (double)yaw && (double)yaw < 67.5) {
            return "southwest";
        }
        if (67.5 <= (double)yaw && (double)yaw < 112.5) {
            return "west";
        }
        if (112.5 <= (double)yaw && (double)yaw < 157.5) {
            return "northwest";
        }
        if (157.5 <= (double)yaw && (double)yaw < 202.5) {
            return "north";
        }
        if (202.5 <= (double)yaw && (double)yaw < 247.5) {
            return "northeast";
        }
        if (247.5 <= (double)yaw && (double)yaw < 292.5) {
            return "east";
        }
        if (292.5 <= (double)yaw && (double)yaw < 337.5) {
            return "southeast";
        }
        if (337.5 <= (double)yaw && (double)yaw < 360.0) {
            return "south";
        }
        return null;
    }

    public void move(Entity var1, Vector var2);

    public void teleport(Entity var1, Vector var2);

    public BoundingBox getBoundingBox(Entity var1);

    public void setBoundingBox(Entity var1, BoundingBox var2);

    public boolean isChestedHorse(Entity var1);

    public boolean isCarryingChest(Entity var1);

    public void setCarryingChest(Entity var1, boolean var2);

    public static class MapTraceResult {
        public Location hitLocation;
        public BlockFace angle;
    }
}

