/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.BracedCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ChooseCommand
extends BracedCommand {
    @Override
    public void onEnable() {
        this.setBraced();
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Iterator<aH.Argument> iterator = aH.interpret(scriptEntry.getArguments()).iterator();
        if (iterator.hasNext()) {
            aH.Argument arg = iterator.next();
            if (!scriptEntry.hasObject("choice")) {
                scriptEntry.addObject("choice", arg.asElement());
                scriptEntry.addObject("braces", ChooseCommand.getBracedCommands(scriptEntry));
            } else {
                arg.reportUnhandled();
            }
        }
        if (!scriptEntry.hasObject("choice")) {
            throw new InvalidArgumentsException("Must have a choice!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        String choice_low;
        Integer resultIndex;
        List bdlist = (List)scriptEntry.getObject("braces");
        if (bdlist == null || bdlist.isEmpty()) {
            dB.echoError(scriptEntry.getResidingQueue(), "Empty sub-commands (internal)!");
            return;
        }
        List<ScriptEntry> bracedCommandsList = ((BracedCommand.BracedData)bdlist.get((int)0)).value;
        HashMap lookupTable = null;
        if (scriptEntry.internal.specialProcessedData instanceof HashMap) {
            lookupTable = (HashMap)scriptEntry.internal.specialProcessedData;
        } else {
            lookupTable = new HashMap();
            for (int i = 0; i < bracedCommandsList.size(); ++i) {
                ScriptEntry se = bracedCommandsList.get(i);
                String cmdName = CoreUtilities.toLowerCase(se.getCommandName());
                if (cmdName.equals("default")) {
                    lookupTable.put("\u0000DEFAULT", i);
                    break;
                }
                if (cmdName.equals("case")) {
                    if (se.getArguments().size() > 0) {
                        for (String arg : se.getArguments()) {
                            lookupTable.put(CoreUtilities.toLowerCase(arg), i);
                        }
                        continue;
                    }
                    dB.echoError("Unknown choose sub-command (missing arguments) '" + se.toString() + "'!");
                    continue;
                }
                dB.echoError("Unknown choose sub-command '" + cmdName + "'!");
            }
            scriptEntry.internal.specialProcessedData = lookupTable;
        }
        Element choice = scriptEntry.getElement("choice");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), choice.debug());
        }
        if ((resultIndex = (Integer)lookupTable.get(choice_low = CoreUtilities.toLowerCase(choice.asString()))) == null && (resultIndex = (Integer)lookupTable.get("\u0000DEFAULT")) == null) {
            dB.echoDebug((Debuggable)scriptEntry, "No result!");
            return;
        }
        ScriptEntry result = bracedCommandsList.get(resultIndex);
        List<BracedCommand.BracedData> new_commands = ChooseCommand.getBracedCommands(result);
        if (new_commands == null || new_commands.isEmpty()) {
            dB.echoError(scriptEntry.getResidingQueue(), "Empty choose command case sub-commands (internal) for case '" + result.toString() + "'");
            return;
        }
        List<ScriptEntry> new_command_list = new_commands.get((int)0).value;
        for (int i = 0; i < new_command_list.size(); ++i) {
            new_command_list.get(i).setInstant(true);
            new_command_list.get(i).addObject("reqid", scriptEntry.getObject("reqid"));
        }
        scriptEntry.setInstant(true);
        scriptEntry.getResidingQueue().injectEntries(new_command_list, 0);
    }
}

